/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.hooks;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.impala.common.InternalException;
import org.apache.impala.hooks.QueryCompleteContext;
import org.apache.impala.hooks.QueryEventHook;
import org.apache.impala.service.BackendConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryEventHookManager {
    private static final Logger LOG = LoggerFactory.getLogger(QueryEventHookManager.class);
    private static final String BE_HOOKS_FLAG = "query_event_hook_classes";
    private static final String BE_HOOKS_THREADS_FLAG = "query_event_hook_nthreads";
    private final List<QueryEventHook> hooks_;
    private final ExecutorService hookExecutor_;

    public static QueryEventHookManager createFromConfig(BackendConfig config) throws InternalException {
        int nHookThreads = config.getNumQueryExecHookThreads();
        String queryExecHookClasses = config.getQueryExecHookClasses();
        LOG.info("QueryEventHook config:");
        LOG.info("- {}={}", (Object)BE_HOOKS_THREADS_FLAG, (Object)nHookThreads);
        LOG.info("- {}={}", (Object)BE_HOOKS_FLAG, (Object)queryExecHookClasses);
        String[] hookClasses = StringUtils.isNotEmpty((String)queryExecHookClasses) ? queryExecHookClasses.split("\\s*,\\s*") : new String[]{};
        return new QueryEventHookManager(nHookThreads, hookClasses);
    }

    private QueryEventHookManager(int nHookExecutorThreads, String[] hookClasses) throws InternalException {
        this.hookExecutor_ = Executors.newFixedThreadPool(nHookExecutorThreads, new ThreadFactoryBuilder().setNameFormat("QueryEventHookExecutor-%d").build());
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.cleanUp()));
        ArrayList<QueryEventHook> hooks = new ArrayList<QueryEventHook>(hookClasses.length);
        this.hooks_ = Collections.unmodifiableList(hooks);
        for (String postExecHook : hookClasses) {
            QueryEventHook hook;
            try {
                Class<?> clsHook = Class.forName(postExecHook);
                hook = (QueryEventHook)clsHook.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                String msg = String.format("Unable to instantiate query event hook class %s. Please check %s config", postExecHook, BE_HOOKS_FLAG);
                LOG.error(msg, (Throwable)e);
                throw new InternalException(msg, e);
            }
            hooks.add(hook);
        }
        for (QueryEventHook hook : hooks) {
            try {
                LOG.debug("Initiating hook.onImpalaStartup for {}", (Object)hook.getClass().getName());
                hook.onImpalaStartup();
            }
            catch (Exception e) {
                String msg = String.format("Exception during onImpalaStartup from QueryEventHook %s instance=%s", hook.getClass(), hook);
                LOG.error(msg, (Throwable)e);
                throw new InternalException(msg, e);
            }
        }
    }

    private void cleanUp() {
        if (!this.hookExecutor_.isShutdown()) {
            this.hookExecutor_.shutdown();
        }
    }

    public List<QueryEventHook> getHooks() {
        return this.hooks_;
    }

    public List<Future<QueryEventHook>> executeQueryCompleteHooks(QueryCompleteContext context) {
        LOG.debug("Query complete hook invoked with: {}", (Object)context);
        return this.hooks_.stream().map(hook -> {
            LOG.debug("Initiating onQueryComplete: {}", (Object)hook.getClass().getName());
            return this.hookExecutor_.submit(() -> {
                try {
                    hook.onQueryComplete(context);
                }
                catch (Throwable t) {
                    String msg = String.format("Exception thrown by QueryEventHook %s.onQueryComplete method.  Hook instance %s. This exception is currently being ignored by Impala, but may cause subsequent problems in that hook's execution", hook.getClass().getName(), hook);
                    LOG.error(msg, t);
                    throw t;
                }
                return hook;
            });
        }).collect(Collectors.toList());
    }
}

