/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.hive.executor;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.impala.catalog.Type;
import org.apache.impala.thrift.TPrimitiveType;
import org.apache.impala.util.UnsafeUtil;

public enum JavaUdfDataType {
    INVALID_TYPE("INVALID_TYPE", TPrimitiveType.INVALID_TYPE),
    BOOLEAN("BOOLEAN", TPrimitiveType.BOOLEAN),
    BOOLEAN_WRITABLE("BOOLEAN_WRITABLE", TPrimitiveType.BOOLEAN),
    TINYINT("TINYINT", TPrimitiveType.TINYINT),
    BYTE_WRITABLE("BYTE_WRITABLE", TPrimitiveType.TINYINT),
    SMALLINT("SMALLINT", TPrimitiveType.SMALLINT),
    SHORT_WRITABLE("SHORT_WRITABLE", TPrimitiveType.SMALLINT),
    INT("INT", TPrimitiveType.INT),
    INT_WRITABLE("INT_WRITABLE", TPrimitiveType.INT),
    BIGINT("BIGINT", TPrimitiveType.BIGINT),
    LONG_WRITABLE("LONG_WRITABLE", TPrimitiveType.BIGINT),
    FLOAT("FLOAT", TPrimitiveType.FLOAT),
    FLOAT_WRITABLE("FLOAT_WRITABLE", TPrimitiveType.FLOAT),
    DOUBLE("DOUBLE", TPrimitiveType.DOUBLE),
    DOUBLE_WRITABLE("DOUBLE", TPrimitiveType.DOUBLE),
    STRING("STRING", TPrimitiveType.STRING),
    TEXT("TEXT", TPrimitiveType.STRING),
    BYTES_WRITABLE("BYTES_WRITABLE", TPrimitiveType.STRING),
    BYTE_ARRAY("BYTE_ARRAY", TPrimitiveType.STRING);

    public static final int STRING_VALUE_LEN_OFFSET = 8;
    private final String description_;
    private final TPrimitiveType thriftType_;

    private JavaUdfDataType(String description, TPrimitiveType thriftType) {
        this.description_ = description;
        this.thriftType_ = thriftType;
    }

    public String toString() {
        return this.description_;
    }

    public String getDescription() {
        return this.description_;
    }

    public TPrimitiveType getPrimitiveType() {
        return this.thriftType_;
    }

    public static JavaUdfDataType[] getTypes(Type[] typeArray) {
        JavaUdfDataType[] types = new JavaUdfDataType[typeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            types[i] = JavaUdfDataType.getType(typeArray[i]);
        }
        return types;
    }

    public static JavaUdfDataType[] getTypes(Class<?>[] typeArray) {
        JavaUdfDataType[] types = new JavaUdfDataType[typeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            types[i] = JavaUdfDataType.getType(typeArray[i]);
        }
        return types;
    }

    public static JavaUdfDataType getType(Type t) {
        switch (t.getPrimitiveType().toThrift()) {
            case BOOLEAN: {
                return BOOLEAN_WRITABLE;
            }
            case TINYINT: {
                return BYTE_WRITABLE;
            }
            case SMALLINT: {
                return SHORT_WRITABLE;
            }
            case INT: {
                return INT_WRITABLE;
            }
            case BIGINT: {
                return LONG_WRITABLE;
            }
            case FLOAT: {
                return FLOAT_WRITABLE;
            }
            case DOUBLE: {
                return DOUBLE_WRITABLE;
            }
            case STRING: {
                return TEXT;
            }
            case BINARY: {
                return BYTES_WRITABLE;
            }
        }
        return null;
    }

    public static JavaUdfDataType getType(ObjectInspector oi) {
        Preconditions.checkState((boolean)(oi instanceof PrimitiveObjectInspector));
        PrimitiveObjectInspector primOi = (PrimitiveObjectInspector)oi;
        PrimitiveObjectInspector.PrimitiveCategory cat = primOi.getPrimitiveCategory();
        boolean writable = primOi.preferWritable();
        switch (cat) {
            case BOOLEAN: {
                return writable ? BOOLEAN_WRITABLE : BOOLEAN;
            }
            case BYTE: {
                return writable ? BYTE_WRITABLE : TINYINT;
            }
            case SHORT: {
                return writable ? SHORT_WRITABLE : SMALLINT;
            }
            case INT: {
                return writable ? INT_WRITABLE : INT;
            }
            case LONG: {
                return writable ? LONG_WRITABLE : BIGINT;
            }
            case FLOAT: {
                return writable ? FLOAT_WRITABLE : FLOAT;
            }
            case DOUBLE: {
                return writable ? DOUBLE_WRITABLE : DOUBLE;
            }
            case STRING: {
                return writable ? TEXT : STRING;
            }
            case BINARY: {
                return writable ? BYTES_WRITABLE : BYTE_ARRAY;
            }
        }
        return null;
    }

    public static JavaUdfDataType getType(Class<?> c) {
        if (c == BooleanWritable.class) {
            return BOOLEAN_WRITABLE;
        }
        if (c == Boolean.TYPE || c == Boolean.class) {
            return BOOLEAN;
        }
        if (c == ByteWritable.class) {
            return BYTE_WRITABLE;
        }
        if (c == Byte.TYPE || c == Byte.class) {
            return TINYINT;
        }
        if (c == ShortWritable.class) {
            return SHORT_WRITABLE;
        }
        if (c == Short.TYPE || c == Short.class) {
            return SMALLINT;
        }
        if (c == IntWritable.class) {
            return INT_WRITABLE;
        }
        if (c == Integer.TYPE || c == Integer.class) {
            return INT;
        }
        if (c == LongWritable.class) {
            return LONG_WRITABLE;
        }
        if (c == Long.TYPE || c == Long.class) {
            return BIGINT;
        }
        if (c == FloatWritable.class) {
            return FLOAT_WRITABLE;
        }
        if (c == Float.TYPE || c == Float.class) {
            return FLOAT;
        }
        if (c == DoubleWritable.class) {
            return DOUBLE_WRITABLE;
        }
        if (c == Double.TYPE || c == Double.class) {
            return DOUBLE;
        }
        if (c == byte[].class) {
            return BYTE_ARRAY;
        }
        if (c == BytesWritable.class) {
            return BYTES_WRITABLE;
        }
        if (c == Text.class) {
            return TEXT;
        }
        if (c == String.class) {
            return STRING;
        }
        return INVALID_TYPE;
    }

    public static boolean isSupported(Type t) {
        if (TPrimitiveType.INVALID_TYPE == t.getPrimitiveType().toThrift()) {
            return false;
        }
        if (t.isBinary()) {
            return true;
        }
        for (JavaUdfDataType javaType : JavaUdfDataType.values()) {
            if (javaType.getPrimitiveType() != t.getPrimitiveType().toThrift()) continue;
            return true;
        }
        return false;
    }

    public boolean isCompatibleWith(TPrimitiveType t) {
        if (t == this.getPrimitiveType()) {
            return true;
        }
        return t == TPrimitiveType.BINARY && (this == BYTE_ARRAY || this == BYTES_WRITABLE);
    }

    public static byte[] loadStringValueFromNativeHeap(long ptr) {
        int length = UnsafeUtil.UNSAFE.getInt(ptr + 8L);
        byte[] buffer = new byte[length];
        long srcPtr = UnsafeUtil.UNSAFE.getLong(ptr);
        UnsafeUtil.Copy(buffer, 0, srcPtr, length);
        return buffer;
    }
}

