/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.hive.executor;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.hive.executor.HiveGenericJavaFunction;
import org.apache.impala.hive.executor.HiveUdfExecutor;
import org.apache.impala.hive.executor.JavaUdfDataType;
import org.apache.impala.hive.executor.Reloadable;
import org.apache.impala.thrift.THiveUdfExecutorCtorParams;
import org.apache.impala.util.UnsafeUtil;
import org.apache.log4j.Logger;

public class HiveUdfExecutorGeneric
extends HiveUdfExecutor {
    private static final Logger LOG = Logger.getLogger(HiveUdfExecutorGeneric.class);
    private GenericUDF genericUDF_;
    private GenericUDF.DeferredObject[] deferredParameters_;
    private GenericUDF.DeferredObject deferredNullParameter_;
    private GenericUDF.DeferredObject[] runtimeDeferredParameters_;

    public HiveUdfExecutorGeneric(THiveUdfExecutorCtorParams request, HiveGenericJavaFunction hiveJavaFn) throws ImpalaRuntimeException {
        super(request, JavaUdfDataType.getType(hiveJavaFn.getReturnObjectInspector()), JavaUdfDataType.getTypes(hiveJavaFn.getParameterTypes()));
        this.genericUDF_ = hiveJavaFn.getGenericUDFInstance();
        this.deferredParameters_ = this.createDeferredObjects();
        this.deferredNullParameter_ = new GenericUDF.DeferredJavaObject(null);
        this.runtimeDeferredParameters_ = new GenericUDF.DeferredObject[this.getNumParams()];
    }

    @Override
    public void closeDerived() {
    }

    @Override
    protected Object evaluateDerived(JavaUdfDataType[] argTypes, long inputNullsPtr, Object[] inputObjectArgs) throws ImpalaRuntimeException {
        try {
            for (int i = 0; i < this.runtimeDeferredParameters_.length; ++i) {
                if (UnsafeUtil.UNSAFE.getByte(inputNullsPtr + (long)i) == 0) {
                    this.runtimeDeferredParameters_[i] = this.deferredParameters_[i];
                    this.runtimeDeferredParameters_[i].prepare(0);
                    continue;
                }
                this.runtimeDeferredParameters_[i] = this.deferredNullParameter_;
            }
            return this.genericUDF_.evaluate(this.runtimeDeferredParameters_);
        }
        catch (HiveException e) {
            throw new ImpalaRuntimeException("UDF failed to evaluate", e);
        }
        catch (IllegalArgumentException e) {
            throw new ImpalaRuntimeException("UDF failed to evaluate", e);
        }
    }

    @Override
    public long evaluateForTesting(Object ... args) throws ImpalaRuntimeException {
        Preconditions.checkState((args.length == this.deferredParameters_.length ? 1 : 0) != 0);
        for (int i = 0; i < this.deferredParameters_.length; ++i) {
            this.deferredParameters_[i] = new GenericUDF.DeferredJavaObject(args[i]);
        }
        return this.evaluate();
    }

    @Override
    public Method getMethod() {
        return null;
    }

    private GenericUDF.DeferredObject[] createDeferredObjects() {
        GenericUDF.DeferredObject[] deferredObjects = new GenericUDF.DeferredObject[this.getNumParams()];
        for (int i = 0; i < deferredObjects.length; ++i) {
            Object inputObject = this.getInputObject(i);
            deferredObjects[i] = inputObject instanceof Reloadable ? new DeferredWritable<Reloadable>((Reloadable)inputObject) : new GenericUDF.DeferredJavaObject(inputObject);
        }
        return deferredObjects;
    }

    private static class DeferredWritable<T extends Reloadable>
    implements GenericUDF.DeferredObject {
        private final T writable;

        public DeferredWritable(T writable) {
            this.writable = writable;
        }

        public void prepare(int ignored) throws HiveException {
            this.writable.reload();
        }

        public Object get() throws HiveException {
            return this.writable;
        }
    }
}

