/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.hive.executor;

import com.google.common.base.Joiner;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.ScalarFunction;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.Type;
import org.apache.impala.hive.executor.HiveJavaFunction;
import org.apache.impala.hive.executor.HiveLegacyFunctionExtractor;
import org.apache.impala.hive.executor.JavaUdfDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveLegacyJavaFunction
implements HiveJavaFunction {
    private static final Logger LOG = LoggerFactory.getLogger(HiveLegacyJavaFunction.class);
    private static final String UDF_FUNCTION_NAME = "evaluate";
    private final Function hiveFn_;
    private final UDF UDF_;
    private final Type retType_;
    private final Type[] parameterTypes_;
    private final Method method_;

    public HiveLegacyJavaFunction(Class<?> udfClass, Function hiveFn, Type retType, Type[] parameterTypes) throws CatalogException {
        try {
            this.hiveFn_ = hiveFn;
            this.retType_ = retType;
            this.parameterTypes_ = parameterTypes;
            this.UDF_ = this.instantiateUDFInstance(udfClass);
            this.method_ = retType != null && retType != ScalarType.INVALID ? this.getMatchingMethod(udfClass) : null;
        }
        catch (CatalogException e) {
            String errorMsg = "Error retrieving class " + udfClass + ": " + e.getMessage();
            throw new CatalogException(errorMsg, e);
        }
    }

    public HiveLegacyJavaFunction(Class<?> udfClass, Type retType, Type[] parameterTypes) throws CatalogException {
        this(udfClass, null, retType, parameterTypes);
    }

    @Override
    public Function getHiveFunction() {
        return this.hiveFn_;
    }

    public Method getMethod() {
        return this.method_;
    }

    public Class<?> getRetType() {
        return this.method_.getReturnType();
    }

    public Class<?>[] getParameterTypes() {
        return this.method_.getParameterTypes();
    }

    public UDF getUDFInstance() {
        return this.UDF_;
    }

    private UDF instantiateUDFInstance(Class<?> udfClass) throws CatalogException {
        try {
            Constructor<?> ctor = udfClass.getConstructor(new Class[0]);
            return (UDF)ctor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new CatalogException("Unable to find constructor with no arguments.", e);
        }
        catch (IllegalArgumentException e) {
            throw new CatalogException("Unable to call UDF constructor with no arguments.", e);
        }
        catch (InstantiationException e) {
            throw new CatalogException("Unable to call create UDF instance.", e);
        }
        catch (IllegalAccessException e) {
            throw new CatalogException("Unable to call create UDF instance.", e);
        }
        catch (InvocationTargetException e) {
            throw new CatalogException("Unable to call create UDF instance.", e);
        }
        catch (ClassCastException e) {
            throw new CatalogException("Unable to cast to UDF instance.", e);
        }
    }

    @Override
    public List<ScalarFunction> extract(HiveLegacyFunctionExtractor extractor) throws CatalogException {
        HashSet<String> addedSignatures = new HashSet<String>();
        ArrayList<ScalarFunction> result = new ArrayList<ScalarFunction>();
        try {
            for (Method m : this.UDF_.getClass().getMethods()) {
                if (!m.getName().equals(UDF_FUNCTION_NAME)) continue;
                ScalarFunction fn = extractor.extract(this.hiveFn_, m);
                if (fn != null) {
                    if (addedSignatures.contains(fn.signatureString())) continue;
                    result.add(fn);
                    addedSignatures.add(fn.signatureString());
                    continue;
                }
                LOG.warn("Ignoring incompatible method: {} during load of Hive UDF: {} from {}", new Object[]{m, this.hiveFn_.getFunctionName(), this.UDF_.getClass()});
            }
        }
        catch (Throwable t) {
            throw new CatalogException("Error loading function " + this.hiveFn_.getFunctionName() + ":  " + t);
        }
        if (result.isEmpty()) {
            throw new CatalogException("No compatible signatures found for function: " + this.hiveFn_.getFunctionName());
        }
        return result;
    }

    private Method getMatchingMethod(Class<?> udfClass) throws CatalogException {
        for (Method m : udfClass.getMethods()) {
            if (!HiveLegacyJavaFunction.methodMatches(m, this.retType_, this.parameterTypes_)) continue;
            return m;
        }
        throw new CatalogException(HiveLegacyJavaFunction.getExceptionString(udfClass.getMethods(), udfClass.toString(), this.parameterTypes_));
    }

    private static boolean methodMatches(Method m, Type retType, Type[] parameterTypes) {
        if (!m.getName().equals(UDF_FUNCTION_NAME)) {
            return false;
        }
        JavaUdfDataType javaRetType = JavaUdfDataType.getType(m.getReturnType());
        if (!javaRetType.isCompatibleWith(retType.getPrimitiveType().toThrift())) {
            return false;
        }
        if (m.getParameterTypes().length != parameterTypes.length) {
            return false;
        }
        for (int i = 0; i < m.getParameterTypes().length; ++i) {
            JavaUdfDataType javaArgType = JavaUdfDataType.getType(m.getParameterTypes()[i]);
            if (javaArgType.isCompatibleWith(parameterTypes[i].getPrimitiveType().toThrift())) continue;
            return false;
        }
        return true;
    }

    public static String getExceptionString(Method[] methods, String className, Type[] parameterTypes) {
        ArrayList<String> signatures = new ArrayList<String>();
        for (Method m : methods) {
            if (!m.getName().equals(UDF_FUNCTION_NAME)) continue;
            signatures.add(m.toGenericString());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Unable to find evaluate function with the correct signature: ").append(className + ".evaluate(").append(Joiner.on((String)", ").join((Object[])parameterTypes)).append(")\n").append("UDF contains: \n    ").append(Joiner.on((String)"\n    ").join(signatures));
        return sb.toString();
    }
}

