/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.hive.executor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.apache.hadoop.hive.metastore.api.ResourceUri;
import org.apache.impala.analysis.FunctionName;
import org.apache.impala.analysis.HdfsUri;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.PrimitiveType;
import org.apache.impala.catalog.ScalarFunction;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.hive.executor.JavaUdfDataType;
import org.apache.impala.thrift.TFunctionBinaryType;
import org.apache.log4j.Logger;

public class HiveLegacyFunctionExtractor {
    private static final Logger LOG = Logger.getLogger(HiveLegacyFunctionExtractor.class);

    public ScalarFunction extract(org.apache.hadoop.hive.metastore.api.Function function, Method method) {
        ScalarType retType;
        List<Type> fnArgsList;
        Class<?> returnType = method.getReturnType();
        Class<?>[] fnArgs = method.getParameterTypes();
        String className = function.getClassName();
        try {
            fnArgsList = this.resolveParameterTypes(Arrays.asList(fnArgs));
            retType = this.resolveReturnType(returnType);
        }
        catch (ImpalaException exception) {
            LOG.debug((Object)("Processing " + className + ": " + exception.getMessage()));
            return null;
        }
        HdfsUri location = null;
        List functionResources = function.getResourceUris();
        if (functionResources != null) {
            ResourceUri jarLocation = (ResourceUri)function.getResourceUris().get(0);
            location = new HdfsUri(jarLocation.getUri());
        }
        ScalarFunction fn = new ScalarFunction(new FunctionName(function.getDbName(), function.getFunctionName()), fnArgsList, retType, location, className, null, null);
        fn.setHasVarArgs(false);
        fn.setBinaryType(TFunctionBinaryType.JAVA);
        fn.setIsPersistent(true);
        return fn;
    }

    private List<Type> resolveParameterTypes(List<Class<?>> arguments) throws ImpalaException {
        ArrayList<Type> resolvedTypes = new ArrayList<Type>();
        for (Class<?> argument : arguments) {
            resolvedTypes.add(this.resolveParameterType(argument));
        }
        return resolvedTypes;
    }

    private ScalarType resolveParameterType(Class<?> param) throws ImpalaException {
        return this.resolveType(param, type -> "Param type " + (Object)type + " not supported");
    }

    private ScalarType resolveReturnType(Class<?> returnType) throws ImpalaException {
        return this.resolveType(returnType, type -> "Return type " + (Object)type + " not supported");
    }

    protected ScalarType resolveType(Class<?> type, Function<JavaUdfDataType, String> errorHandler) throws ImpalaException {
        JavaUdfDataType javaRetType = JavaUdfDataType.getType(type);
        if (javaRetType == JavaUdfDataType.INVALID_TYPE) {
            throw new CatalogException(errorHandler.apply(javaRetType));
        }
        return ScalarType.createType(PrimitiveType.fromThrift(javaRetType.getPrimitiveType()));
    }
}

