/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.hive.executor;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.FunctionType;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.ResourceType;
import org.apache.hadoop.hive.metastore.api.ResourceUri;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.ScalarFunction;
import org.apache.impala.hive.executor.HiveLegacyFunctionExtractor;
import org.apache.impala.thrift.TFunctionBinaryType;

public interface HiveJavaFunction {
    default public List<ScalarFunction> extract() throws CatalogException {
        return this.extract(new HiveLegacyFunctionExtractor());
    }

    public List<ScalarFunction> extract(HiveLegacyFunctionExtractor var1) throws CatalogException;

    public Function getHiveFunction();

    public static Function toHiveFunction(ScalarFunction scalarFn) {
        Preconditions.checkState((scalarFn.getBinaryType() == TFunctionBinaryType.JAVA ? 1 : 0) != 0);
        ArrayList resources = Lists.newArrayList((Object[])new ResourceUri[]{new ResourceUri(ResourceType.JAR, scalarFn.getLocation().toString())});
        return new Function(scalarFn.functionName(), scalarFn.dbName(), scalarFn.getSymbolName(), "", PrincipalType.USER, (int)(System.currentTimeMillis() / 1000L), FunctionType.JAVA, (List)resources);
    }

    public static Function createHiveFunction(String fnName, String dbName, String symbolName, List<ResourceUri> resources) {
        return new Function(fnName, dbName, symbolName, "", PrincipalType.USER, (int)(System.currentTimeMillis() / 1000L), FunctionType.JAVA, resources);
    }
}

