/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.hive.executor;

import com.google.common.base.Joiner;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.ScalarFunction;
import org.apache.impala.catalog.Type;
import org.apache.impala.hive.executor.HiveJavaFunction;
import org.apache.impala.hive.executor.HiveLegacyFunctionExtractor;
import org.apache.log4j.Logger;

public class HiveGenericJavaFunction
implements HiveJavaFunction {
    private static final Logger LOG = Logger.getLogger(HiveGenericJavaFunction.class);
    private final Function hiveFn_;
    private final Type retType_;
    private final ObjectInspector returnOi_;
    private final Type[] parameterTypes_;
    private final GenericUDF genericUDF_;

    public HiveGenericJavaFunction(Class<?> udfClass, Function hiveFn, Type retType, Type[] parameterTypes) throws CatalogException {
        try {
            this.hiveFn_ = hiveFn;
            this.retType_ = retType;
            this.parameterTypes_ = parameterTypes;
            this.genericUDF_ = this.createGenericUDFInstance(udfClass);
            this.returnOi_ = this.initializeWrapper();
            this.checkValidFunction();
        }
        catch (CatalogException e) {
            String errorMsg = "Error retrieving class " + udfClass + ": " + e.getMessage();
            throw new CatalogException(errorMsg, e);
        }
    }

    public HiveGenericJavaFunction(Class<?> udfClass, Type retType, Type[] parameterTypes) throws CatalogException {
        this(udfClass, null, retType, parameterTypes);
    }

    @Override
    public Function getHiveFunction() {
        return this.hiveFn_;
    }

    @Override
    public List<ScalarFunction> extract(HiveLegacyFunctionExtractor extractor) throws CatalogException {
        return new ArrayList<ScalarFunction>();
    }

    public GenericUDF getGenericUDFInstance() {
        return this.genericUDF_;
    }

    public Type getRetType() {
        return this.retType_;
    }

    public ObjectInspector getReturnObjectInspector() {
        return this.returnOi_;
    }

    public Type[] getParameterTypes() {
        return this.parameterTypes_;
    }

    private GenericUDF createGenericUDFInstance(Class<?> udfClass) throws CatalogException {
        try {
            Constructor<?> ctor = udfClass.getConstructor(new Class[0]);
            return (GenericUDF)ctor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new CatalogException("Unable to find constructor with no arguments.", e);
        }
        catch (IllegalArgumentException e) {
            throw new CatalogException("Unable to call UDF constructor with no arguments.", e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new CatalogException("Unable to call create UDF instance.", e);
        }
    }

    private void checkValidFunction() throws CatalogException {
        if (this.returnOi_ != this.getInspector(this.retType_, true) && this.returnOi_ != this.getInspector(this.retType_, false) && !this.returnOi_.getTypeName().equals("void")) {
            throw new CatalogException("Function expected return type " + this.returnOi_.getTypeName() + " but was created with " + this.retType_);
        }
    }

    private ObjectInspector initializeWrapper() throws CatalogException {
        ObjectInspector[] parameterOIs = this.getInspectors(this.parameterTypes_, true);
        try {
            return this.genericUDF_.initialize(parameterOIs);
        }
        catch (UDFArgumentException e) {
            LOG.info((Object)("GenericUDF initialization failed: " + e.getMessage()));
            throw new CatalogException("Function cannot be created with the following parameters: (" + Joiner.on((String)",").join((Object[])this.parameterTypes_) + "). ");
        }
    }

    private ObjectInspector[] getInspectors(Type[] typeArray, boolean useWritable) throws CatalogException {
        ObjectInspector[] OIArray = new ObjectInspector[typeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            OIArray[i] = this.getInspector(typeArray[i], useWritable);
        }
        return OIArray;
    }

    private ObjectInspector getInspector(Type t, boolean useWritable) throws CatalogException {
        PrimitiveObjectInspector.PrimitiveCategory cat = this.getPrimitiveCategory(t);
        return useWritable ? PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)cat) : PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)cat);
    }

    private PrimitiveObjectInspector.PrimitiveCategory getPrimitiveCategory(Type t) throws CatalogException {
        switch (t.getPrimitiveType().toThrift()) {
            case BOOLEAN: {
                return PrimitiveObjectInspector.PrimitiveCategory.BOOLEAN;
            }
            case TINYINT: {
                return PrimitiveObjectInspector.PrimitiveCategory.BYTE;
            }
            case SMALLINT: {
                return PrimitiveObjectInspector.PrimitiveCategory.SHORT;
            }
            case INT: {
                return PrimitiveObjectInspector.PrimitiveCategory.INT;
            }
            case BIGINT: {
                return PrimitiveObjectInspector.PrimitiveCategory.LONG;
            }
            case FLOAT: {
                return PrimitiveObjectInspector.PrimitiveCategory.FLOAT;
            }
            case DOUBLE: {
                return PrimitiveObjectInspector.PrimitiveCategory.DOUBLE;
            }
            case STRING: {
                return PrimitiveObjectInspector.PrimitiveCategory.STRING;
            }
            case BINARY: {
                return PrimitiveObjectInspector.PrimitiveCategory.BINARY;
            }
        }
        throw new CatalogException("Unsupported type: " + t);
    }
}

