/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.fb;

import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.impala.fb.FbIcebergPartitionTransformValue;

public final class FbIcebergMetadata
extends Table {
    public static FbIcebergMetadata getRootAsFbIcebergMetadata(ByteBuffer _bb) {
        return FbIcebergMetadata.getRootAsFbIcebergMetadata(_bb, new FbIcebergMetadata());
    }

    public static FbIcebergMetadata getRootAsFbIcebergMetadata(ByteBuffer _bb, FbIcebergMetadata obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.bb_pos = _i;
        this.bb = _bb;
    }

    public FbIcebergMetadata __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public byte fileFormat() {
        int o = this.__offset(4);
        return o != 0 ? this.bb.get(o + this.bb_pos) : (byte)0;
    }

    public boolean mutateFileFormat(byte file_format) {
        int o = this.__offset(4);
        if (o != 0) {
            this.bb.put(o + this.bb_pos, file_format);
            return true;
        }
        return false;
    }

    public long recordCount() {
        int o = this.__offset(6);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public boolean mutateRecordCount(long record_count) {
        int o = this.__offset(6);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, record_count);
            return true;
        }
        return false;
    }

    public long dataSequenceNumber() {
        int o = this.__offset(8);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public boolean mutateDataSequenceNumber(long data_sequence_number) {
        int o = this.__offset(8);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, data_sequence_number);
            return true;
        }
        return false;
    }

    public int specId() {
        int o = this.__offset(10);
        return o != 0 ? this.bb.getShort(o + this.bb_pos) & 0xFFFF : 0;
    }

    public boolean mutateSpecId(int spec_id) {
        int o = this.__offset(10);
        if (o != 0) {
            this.bb.putShort(o + this.bb_pos, (short)spec_id);
            return true;
        }
        return false;
    }

    public FbIcebergPartitionTransformValue partitionKeys(int j) {
        return this.partitionKeys(new FbIcebergPartitionTransformValue(), j);
    }

    public FbIcebergPartitionTransformValue partitionKeys(FbIcebergPartitionTransformValue obj, int j) {
        int o = this.__offset(12);
        return o != 0 ? obj.__assign(this.__indirect(this.__vector(o) + j * 4), this.bb) : null;
    }

    public int partitionKeysLength() {
        int o = this.__offset(12);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public int equalityFieldIds(int j) {
        int o = this.__offset(14);
        return o != 0 ? this.bb.getInt(this.__vector(o) + j * 4) : 0;
    }

    public int equalityFieldIdsLength() {
        int o = this.__offset(14);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public ByteBuffer equalityFieldIdsAsByteBuffer() {
        return this.__vector_as_bytebuffer(14, 4);
    }

    public ByteBuffer equalityFieldIdsInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 14, 4);
    }

    public boolean mutateEqualityFieldIds(int j, int equality_field_ids) {
        int o = this.__offset(14);
        if (o != 0) {
            this.bb.putInt(this.__vector(o) + j * 4, equality_field_ids);
            return true;
        }
        return false;
    }

    public static int createFbIcebergMetadata(FlatBufferBuilder builder, byte file_format, long record_count, long data_sequence_number, int spec_id, int partition_keysOffset, int equality_field_idsOffset) {
        builder.startObject(6);
        FbIcebergMetadata.addDataSequenceNumber(builder, data_sequence_number);
        FbIcebergMetadata.addRecordCount(builder, record_count);
        FbIcebergMetadata.addEqualityFieldIds(builder, equality_field_idsOffset);
        FbIcebergMetadata.addPartitionKeys(builder, partition_keysOffset);
        FbIcebergMetadata.addSpecId(builder, spec_id);
        FbIcebergMetadata.addFileFormat(builder, file_format);
        return FbIcebergMetadata.endFbIcebergMetadata(builder);
    }

    public static void startFbIcebergMetadata(FlatBufferBuilder builder) {
        builder.startObject(6);
    }

    public static void addFileFormat(FlatBufferBuilder builder, byte fileFormat) {
        builder.addByte(0, fileFormat, 0);
    }

    public static void addRecordCount(FlatBufferBuilder builder, long recordCount) {
        builder.addLong(1, recordCount, 0L);
    }

    public static void addDataSequenceNumber(FlatBufferBuilder builder, long dataSequenceNumber) {
        builder.addLong(2, dataSequenceNumber, 0L);
    }

    public static void addSpecId(FlatBufferBuilder builder, int specId) {
        builder.addShort(3, (short)specId, 0);
    }

    public static void addPartitionKeys(FlatBufferBuilder builder, int partitionKeysOffset) {
        builder.addOffset(4, partitionKeysOffset, 0);
    }

    public static int createPartitionKeysVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addOffset(data[i]);
        }
        return builder.endVector();
    }

    public static void startPartitionKeysVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static void addEqualityFieldIds(FlatBufferBuilder builder, int equalityFieldIdsOffset) {
        builder.addOffset(5, equalityFieldIdsOffset, 0);
    }

    public static int createEqualityFieldIdsVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addInt(data[i]);
        }
        return builder.endVector();
    }

    public static void startEqualityFieldIdsVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static int endFbIcebergMetadata(FlatBufferBuilder builder) {
        int o = builder.endObject();
        return o;
    }
}

