/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.fb;

import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.impala.fb.FbIcebergColumnStats;

public final class FbIcebergDataFile
extends Table {
    public static FbIcebergDataFile getRootAsFbIcebergDataFile(ByteBuffer _bb) {
        return FbIcebergDataFile.getRootAsFbIcebergDataFile(_bb, new FbIcebergDataFile());
    }

    public static FbIcebergDataFile getRootAsFbIcebergDataFile(ByteBuffer _bb, FbIcebergDataFile obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.bb_pos = _i;
        this.bb = _bb;
    }

    public FbIcebergDataFile __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public String path() {
        int o = this.__offset(4);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer pathAsByteBuffer() {
        return this.__vector_as_bytebuffer(4, 1);
    }

    public ByteBuffer pathInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 4, 1);
    }

    public byte format() {
        int o = this.__offset(6);
        return o != 0 ? this.bb.get(o + this.bb_pos) : (byte)0;
    }

    public boolean mutateFormat(byte format) {
        int o = this.__offset(6);
        if (o != 0) {
            this.bb.put(o + this.bb_pos, format);
            return true;
        }
        return false;
    }

    public long recordCount() {
        int o = this.__offset(8);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public boolean mutateRecordCount(long record_count) {
        int o = this.__offset(8);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, record_count);
            return true;
        }
        return false;
    }

    public long fileSizeInBytes() {
        int o = this.__offset(10);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public boolean mutateFileSizeInBytes(long file_size_in_bytes) {
        int o = this.__offset(10);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, file_size_in_bytes);
            return true;
        }
        return false;
    }

    public int specId() {
        int o = this.__offset(12);
        return o != 0 ? this.bb.getShort(o + this.bb_pos) & 0xFFFF : 0;
    }

    public boolean mutateSpecId(int spec_id) {
        int o = this.__offset(12);
        if (o != 0) {
            this.bb.putShort(o + this.bb_pos, (short)spec_id);
            return true;
        }
        return false;
    }

    public String partitionPath() {
        int o = this.__offset(14);
        return o != 0 ? this.__string(o + this.bb_pos) : null;
    }

    public ByteBuffer partitionPathAsByteBuffer() {
        return this.__vector_as_bytebuffer(14, 1);
    }

    public ByteBuffer partitionPathInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 14, 1);
    }

    public String rawPartitionFields(int j) {
        int o = this.__offset(16);
        return o != 0 ? this.__string(this.__vector(o) + j * 4) : null;
    }

    public int rawPartitionFieldsLength() {
        int o = this.__offset(16);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public FbIcebergColumnStats perColumnStats(int j) {
        return this.perColumnStats(new FbIcebergColumnStats(), j);
    }

    public FbIcebergColumnStats perColumnStats(FbIcebergColumnStats obj, int j) {
        int o = this.__offset(18);
        return o != 0 ? obj.__assign(this.__indirect(this.__vector(o) + j * 4), this.bb) : null;
    }

    public int perColumnStatsLength() {
        int o = this.__offset(18);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public static int createFbIcebergDataFile(FlatBufferBuilder builder, int pathOffset, byte format, long record_count, long file_size_in_bytes, int spec_id, int partition_pathOffset, int raw_partition_fieldsOffset, int per_column_statsOffset) {
        builder.startObject(8);
        FbIcebergDataFile.addFileSizeInBytes(builder, file_size_in_bytes);
        FbIcebergDataFile.addRecordCount(builder, record_count);
        FbIcebergDataFile.addPerColumnStats(builder, per_column_statsOffset);
        FbIcebergDataFile.addRawPartitionFields(builder, raw_partition_fieldsOffset);
        FbIcebergDataFile.addPartitionPath(builder, partition_pathOffset);
        FbIcebergDataFile.addPath(builder, pathOffset);
        FbIcebergDataFile.addSpecId(builder, spec_id);
        FbIcebergDataFile.addFormat(builder, format);
        return FbIcebergDataFile.endFbIcebergDataFile(builder);
    }

    public static void startFbIcebergDataFile(FlatBufferBuilder builder) {
        builder.startObject(8);
    }

    public static void addPath(FlatBufferBuilder builder, int pathOffset) {
        builder.addOffset(0, pathOffset, 0);
    }

    public static void addFormat(FlatBufferBuilder builder, byte format) {
        builder.addByte(1, format, 0);
    }

    public static void addRecordCount(FlatBufferBuilder builder, long recordCount) {
        builder.addLong(2, recordCount, 0L);
    }

    public static void addFileSizeInBytes(FlatBufferBuilder builder, long fileSizeInBytes) {
        builder.addLong(3, fileSizeInBytes, 0L);
    }

    public static void addSpecId(FlatBufferBuilder builder, int specId) {
        builder.addShort(4, (short)specId, 0);
    }

    public static void addPartitionPath(FlatBufferBuilder builder, int partitionPathOffset) {
        builder.addOffset(5, partitionPathOffset, 0);
    }

    public static void addRawPartitionFields(FlatBufferBuilder builder, int rawPartitionFieldsOffset) {
        builder.addOffset(6, rawPartitionFieldsOffset, 0);
    }

    public static int createRawPartitionFieldsVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addOffset(data[i]);
        }
        return builder.endVector();
    }

    public static void startRawPartitionFieldsVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static void addPerColumnStats(FlatBufferBuilder builder, int perColumnStatsOffset) {
        builder.addOffset(7, perColumnStatsOffset, 0);
    }

    public static int createPerColumnStatsVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addOffset(data[i]);
        }
        return builder.endVector();
    }

    public static void startPerColumnStatsVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static int endFbIcebergDataFile(FlatBufferBuilder builder) {
        int o = builder.endObject();
        return o;
    }
}

