/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.fb;

import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class FbFileBlock
extends Table {
    public static FbFileBlock getRootAsFbFileBlock(ByteBuffer _bb) {
        return FbFileBlock.getRootAsFbFileBlock(_bb, new FbFileBlock());
    }

    public static FbFileBlock getRootAsFbFileBlock(ByteBuffer _bb, FbFileBlock obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.bb_pos = _i;
        this.bb = _bb;
    }

    public FbFileBlock __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public long offset() {
        int o = this.__offset(4);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public boolean mutateOffset(long offset) {
        int o = this.__offset(4);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, offset);
            return true;
        }
        return false;
    }

    public long length() {
        int o = this.__offset(6);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : -1L;
    }

    public boolean mutateLength(long length) {
        int o = this.__offset(6);
        if (o != 0) {
            this.bb.putLong(o + this.bb_pos, length);
            return true;
        }
        return false;
    }

    public int replicaHostIdxs(int j) {
        int o = this.__offset(8);
        return o != 0 ? this.bb.getShort(this.__vector(o) + j * 2) & 0xFFFF : 0;
    }

    public int replicaHostIdxsLength() {
        int o = this.__offset(8);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public ByteBuffer replicaHostIdxsAsByteBuffer() {
        return this.__vector_as_bytebuffer(8, 2);
    }

    public ByteBuffer replicaHostIdxsInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 8, 2);
    }

    public boolean mutateReplicaHostIdxs(int j, int replica_host_idxs) {
        int o = this.__offset(8);
        if (o != 0) {
            this.bb.putShort(this.__vector(o) + j * 2, (short)replica_host_idxs);
            return true;
        }
        return false;
    }

    public short diskIds(int j) {
        int o = this.__offset(10);
        return o != 0 ? this.bb.getShort(this.__vector(o) + j * 2) : (short)0;
    }

    public int diskIdsLength() {
        int o = this.__offset(10);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public ByteBuffer diskIdsAsByteBuffer() {
        return this.__vector_as_bytebuffer(10, 2);
    }

    public ByteBuffer diskIdsInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 10, 2);
    }

    public boolean mutateDiskIds(int j, short disk_ids) {
        int o = this.__offset(10);
        if (o != 0) {
            this.bb.putShort(this.__vector(o) + j * 2, disk_ids);
            return true;
        }
        return false;
    }

    public static int createFbFileBlock(FlatBufferBuilder builder, long offset, long length, int replica_host_idxsOffset, int disk_idsOffset) {
        builder.startObject(4);
        FbFileBlock.addLength(builder, length);
        FbFileBlock.addOffset(builder, offset);
        FbFileBlock.addDiskIds(builder, disk_idsOffset);
        FbFileBlock.addReplicaHostIdxs(builder, replica_host_idxsOffset);
        return FbFileBlock.endFbFileBlock(builder);
    }

    public static void startFbFileBlock(FlatBufferBuilder builder) {
        builder.startObject(4);
    }

    public static void addOffset(FlatBufferBuilder builder, long offset) {
        builder.addLong(0, offset, 0L);
    }

    public static void addLength(FlatBufferBuilder builder, long length) {
        builder.addLong(1, length, -1L);
    }

    public static void addReplicaHostIdxs(FlatBufferBuilder builder, int replicaHostIdxsOffset) {
        builder.addOffset(2, replicaHostIdxsOffset, 0);
    }

    public static int createReplicaHostIdxsVector(FlatBufferBuilder builder, short[] data) {
        builder.startVector(2, data.length, 2);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addShort(data[i]);
        }
        return builder.endVector();
    }

    public static void startReplicaHostIdxsVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(2, numElems, 2);
    }

    public static void addDiskIds(FlatBufferBuilder builder, int diskIdsOffset) {
        builder.addOffset(3, diskIdsOffset, 0);
    }

    public static int createDiskIdsVector(FlatBufferBuilder builder, short[] data) {
        builder.startVector(2, data.length, 2);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addShort(data[i]);
        }
        return builder.endVector();
    }

    public static void startDiskIdsVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(2, numElems, 2);
    }

    public static int endFbFileBlock(FlatBufferBuilder builder) {
        int o = builder.endObject();
        return o;
    }
}

