/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.extdatasource.jdbc.dao;

import org.apache.impala.extdatasource.jdbc.dao.GenericJdbcDatabaseAccessor;

public class PostgresDatabaseAccessor
extends GenericJdbcDatabaseAccessor {
    @Override
    public String getCaseSensitiveName(String name) {
        if (!name.isEmpty() && name.charAt(0) != '\"') {
            StringBuilder sb = new StringBuilder("\"");
            sb.append(name);
            sb.append("\"");
            return sb.toString();
        }
        return name;
    }

    @Override
    protected String addLimitAndOffsetToQuery(String sql, int limit, int offset) {
        if (offset == 0) {
            return this.addLimitToQuery(sql, limit);
        }
        if (limit == -1) {
            return sql;
        }
        return sql + " LIMIT " + limit + " OFFSET " + offset;
    }

    @Override
    protected String addLimitToQuery(String sql, int limit) {
        if (limit == -1) {
            return sql;
        }
        return sql + " LIMIT " + limit;
    }

    @Override
    protected boolean isAdditionalPropertiesSupported() {
        return true;
    }

    @Override
    protected String getPropertiesDelimiter(boolean precededDelimiter) {
        return precededDelimiter ? "?" : "&";
    }
}

