/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.extdatasource.jdbc.dao;

import org.apache.hadoop.conf.Configuration;
import org.apache.impala.extdatasource.jdbc.conf.DatabaseType;
import org.apache.impala.extdatasource.jdbc.conf.JdbcStorageConfig;
import org.apache.impala.extdatasource.jdbc.dao.DB2DatabaseAccessor;
import org.apache.impala.extdatasource.jdbc.dao.DatabaseAccessor;
import org.apache.impala.extdatasource.jdbc.dao.GenericJdbcDatabaseAccessor;
import org.apache.impala.extdatasource.jdbc.dao.ImpalaDatabaseAccessor;
import org.apache.impala.extdatasource.jdbc.dao.JethroDatabaseAccessor;
import org.apache.impala.extdatasource.jdbc.dao.MsSqlDatabaseAccessor;
import org.apache.impala.extdatasource.jdbc.dao.MySqlDatabaseAccessor;
import org.apache.impala.extdatasource.jdbc.dao.OracleDatabaseAccessor;
import org.apache.impala.extdatasource.jdbc.dao.PostgresDatabaseAccessor;

public class DatabaseAccessorFactory {
    private DatabaseAccessorFactory() {
    }

    public static DatabaseAccessor getAccessor(DatabaseType dbType) {
        GenericJdbcDatabaseAccessor accessor;
        switch (dbType) {
            case MYSQL: {
                accessor = new MySqlDatabaseAccessor();
                break;
            }
            case JETHRO_DATA: {
                accessor = new JethroDatabaseAccessor();
                break;
            }
            case POSTGRES: {
                accessor = new PostgresDatabaseAccessor();
                break;
            }
            case ORACLE: {
                accessor = new OracleDatabaseAccessor();
                break;
            }
            case MSSQL: {
                accessor = new MsSqlDatabaseAccessor();
                break;
            }
            case DB2: {
                accessor = new DB2DatabaseAccessor();
                break;
            }
            case IMPALA: {
                accessor = new ImpalaDatabaseAccessor();
                break;
            }
            default: {
                accessor = new GenericJdbcDatabaseAccessor();
            }
        }
        return accessor;
    }

    public static DatabaseAccessor getAccessor(Configuration conf) {
        DatabaseType dbType = DatabaseType.valueOf(conf.get(JdbcStorageConfig.DATABASE_TYPE.getPropertyName()).toUpperCase());
        return DatabaseAccessorFactory.getAccessor(dbType);
    }
}

