/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.extdatasource.jdbc.dao;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.BasicDataSourceFactory;
import org.apache.hadoop.fs.Path;
import org.apache.impala.common.FileSystemUtil;
import org.apache.impala.extdatasource.jdbc.exception.JdbcDatabaseAccessException;
import org.apache.impala.service.BackendConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceObjectCache {
    private static final Logger LOG = LoggerFactory.getLogger(DataSourceObjectCache.class);
    private static final long CLEANUP_INTERVAL_MS = 10000L;
    private static final long DEFAULT_IDLE_DATA_SOURCE_TIMEOUT_MS = 300000L;
    private final Map<String, Entry> cacheMap_ = new HashMap<String, Entry>();
    private Thread cleanupThread_ = new Thread(new Runnable(){

        @Override
        public void run() {
            DataSourceObjectCache.this.cleanup();
        }
    });

    public DataSourceObjectCache() {
        this.cleanupThread_.setDaemon(true);
        this.cleanupThread_.setName("DataSourceObjectCache daemon thread");
        this.cleanupThread_.start();
    }

    public DataSource get(String cacheKey, Properties props) throws JdbcDatabaseAccessException {
        DataSourceObjectCache dataSourceObjectCache = this;
        synchronized (dataSourceObjectCache) {
            Entry entry = this.cacheMap_.get(cacheKey);
            if (entry != null) {
                entry.incrementReference();
                return entry.getDataSource();
            }
            LOG.info("Datasource for '{}' was not cached. Loading now.", (Object)cacheKey);
            String driverUrl = props.getProperty("driverUrl");
            try {
                BasicDataSource dbcpDs = BasicDataSourceFactory.createDataSource((Properties)props);
                String driverLocalPath = FileSystemUtil.copyFileFromUriToLocal(driverUrl);
                URL driverJarUrl = new File(driverLocalPath).toURI().toURL();
                URLClassLoader driverLoader = URLClassLoader.newInstance(new URL[]{driverJarUrl}, this.getClass().getClassLoader());
                dbcpDs.setDriverClassLoader((ClassLoader)driverLoader);
                entry = new Entry((DataSource)dbcpDs, driverLocalPath);
                this.cacheMap_.put(cacheKey, entry);
                return dbcpDs;
            }
            catch (Exception e) {
                throw new JdbcDatabaseAccessException(String.format("Unable to fetch jdbc driver jar from location '%s'. ", driverUrl));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String cacheKey, boolean cleanDbcpDSCache) {
        if (Strings.isNullOrEmpty((String)cacheKey)) {
            return;
        }
        Entry entry = null;
        DataSourceObjectCache dataSourceObjectCache = this;
        synchronized (dataSourceObjectCache) {
            entry = this.cacheMap_.get(cacheKey);
            if (entry == null) {
                return;
            }
            Preconditions.checkState((entry.getReference() > 0 ? 1 : 0) != 0);
            entry.decrementReference();
            if (entry.getReference() > 0) {
                return;
            }
            if (!cleanDbcpDSCache) {
                entry.setIdleTimeStamp(System.currentTimeMillis());
                return;
            }
            this.cacheMap_.remove(cacheKey);
        }
        this.closeDataSource(cacheKey, entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        long idleTimeoutInMS = BackendConfig.INSTANCE.getDbcpDataSourceIdleTimeoutInSeconds() * 1000;
        if (idleTimeoutInMS < 0L) {
            idleTimeoutInMS = 300000L;
        }
        while (true) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                LOG.info("Thread.sleep failed, ", (Throwable)e);
            }
            long currTime = System.currentTimeMillis();
            HashMap<String, Entry> entriesToBeClosed = new HashMap<String, Entry>();
            DataSourceObjectCache dataSourceObjectCache = this;
            synchronized (dataSourceObjectCache) {
                Iterator<Map.Entry<String, Entry>> iterator = this.cacheMap_.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Entry> mapEntry = iterator.next();
                    String cacheKey = mapEntry.getKey();
                    Entry entry = mapEntry.getValue();
                    if (entry.getReference() > 0 || currTime - entry.getIdleTimeStamp() <= idleTimeoutInMS) continue;
                    iterator.remove();
                    entriesToBeClosed.put(cacheKey, entry);
                }
            }
            for (Map.Entry entry : entriesToBeClosed.entrySet()) {
                this.closeDataSource((String)entry.getKey(), (Entry)entry.getValue());
            }
            entriesToBeClosed.clear();
        }
    }

    private void closeDataSource(String cacheKey, Entry entry) {
        if (Strings.isNullOrEmpty((String)cacheKey) || entry == null) {
            return;
        }
        DataSource ds = entry.getDataSource();
        String driverFilePath = entry.getDriverFilePath();
        Preconditions.checkState((boolean)(ds instanceof BasicDataSource));
        BasicDataSource dbcpDs = (BasicDataSource)ds;
        try {
            dbcpDs.close();
            LOG.info("Close datasource for '{}'.", (Object)cacheKey);
            if (driverFilePath != null) {
                Path localJarPath = new Path("file://" + driverFilePath);
                FileSystemUtil.deleteIfExists(localJarPath);
            }
        }
        catch (SQLException e) {
            LOG.warn("Caught exception during datasource cleanup.", (Throwable)e);
        }
    }

    class Entry {
        private DataSource dbcpDataSource_;
        private String driverFilePath_;
        private int referenceCount_;
        private long idleTimeStamp_;

        public Entry(DataSource dataSource, String driverFilePath) {
            this.dbcpDataSource_ = dataSource;
            this.driverFilePath_ = driverFilePath;
            this.referenceCount_ = 1;
            this.idleTimeStamp_ = 0L;
        }

        public DataSource getDataSource() {
            return this.dbcpDataSource_;
        }

        public int getReference() {
            return this.referenceCount_;
        }

        public String getDriverFilePath() {
            return this.driverFilePath_;
        }

        public void incrementReference() {
            ++this.referenceCount_;
        }

        public int decrementReference() {
            return --this.referenceCount_;
        }

        public long getIdleTimeStamp() {
            return this.idleTimeStamp_;
        }

        public void setIdleTimeStamp(long timeStamp) {
            this.idleTimeStamp_ = timeStamp;
        }
    }
}

