/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.extdatasource.jdbc.conf;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.impala.extdatasource.jdbc.conf.DatabaseType;
import org.apache.impala.extdatasource.jdbc.conf.JdbcStorageConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcStorageConfigManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcStorageConfigManager.class);

    public static Configuration convertMapToConfiguration(Map<String, String> props) {
        JdbcStorageConfigManager.checkRequiredPropertiesAreDefined(props);
        Configuration conf = new Configuration();
        for (Map.Entry<String, String> entry : props.entrySet()) {
            conf.set(entry.getKey(), entry.getValue());
        }
        return conf;
    }

    public static String getPasswordFromProperties(Configuration conf) {
        String keystore;
        String username = conf.get(JdbcStorageConfig.DBCP_USERNAME.getPropertyName());
        String passwd = conf.get(JdbcStorageConfig.DBCP_PASSWORD.getPropertyName());
        if (JdbcStorageConfigManager.countNonNull(passwd, keystore = conf.get(JdbcStorageConfig.DBCP_PASSWORD_KEYSTORE.getPropertyName())) > 1) {
            LOGGER.warn("Only one of " + passwd + ", " + keystore + " can be set");
        }
        if (passwd == null && keystore != null) {
            String key = conf.get(JdbcStorageConfig.DBCP_PASSWORD_KEY.getPropertyName());
            if (key == null) {
                key = username;
            }
            LOGGER.info("hadoop keystore: " + keystore + " hadoop key: " + key);
            try {
                passwd = JdbcStorageConfigManager.getPasswdFromKeystore(keystore, key);
            }
            catch (IOException e) {
                LOGGER.error("Failed to get password from keystore " + key + ", error: " + e);
            }
        }
        return passwd;
    }

    private static int countNonNull(String ... values) {
        int count = 0;
        for (String str : values) {
            if (str == null) continue;
            ++count;
        }
        return count;
    }

    public static String getPasswdFromKeystore(String keystore, String key) throws IOException {
        String passwd = null;
        if (keystore != null && key != null) {
            Configuration conf = new Configuration();
            conf.set("hadoop.security.credential.provider.path", keystore);
            char[] pwdCharArray = conf.getPassword(key);
            if (pwdCharArray != null) {
                passwd = new String(pwdCharArray);
            } else {
                LOGGER.error("empty or null password for " + key);
            }
        }
        return passwd;
    }

    private static void checkRequiredPropertiesAreDefined(Map<String, String> props) {
        try {
            String dbTypeName = props.get(JdbcStorageConfig.DATABASE_TYPE.getPropertyName());
            DatabaseType.valueOf(dbTypeName.toUpperCase());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unknown database type.", e);
        }
        for (JdbcStorageConfig config : JdbcStorageConfig.values()) {
            if (!config.isRequired() || props.containsKey(config.getPropertyName())) continue;
            throw new IllegalArgumentException(String.format("Required config '%s' was not present!", config.getPropertyName()));
        }
    }

    public static String getConfigValue(JdbcStorageConfig key, Configuration config) {
        return config.get(key.getPropertyName());
    }

    public static String getOrigQueryToExecute(Configuration config) {
        String tableName = config.get(JdbcStorageConfig.TABLE.getPropertyName());
        String query2 = tableName != null ? "select * from " + tableName : config.get(JdbcStorageConfig.QUERY.getPropertyName());
        return query2;
    }

    public static String getQueryToExecute(Configuration config) {
        String query2 = config.get(JdbcStorageConfig.QUERY.getPropertyName());
        if (query2 != null) {
            return query2;
        }
        String tableName = config.get(JdbcStorageConfig.TABLE.getPropertyName());
        query2 = "select * from " + tableName;
        return query2;
    }

    private static boolean isEmptyString(String value) {
        return value == null || value.trim().isEmpty();
    }
}

