/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.extdatasource.jdbc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.impala.extdatasource.jdbc.conf.JdbcStorageConfig;
import org.apache.impala.extdatasource.jdbc.conf.JdbcStorageConfigManager;
import org.apache.impala.extdatasource.jdbc.dao.DatabaseAccessor;
import org.apache.impala.extdatasource.jdbc.dao.DatabaseAccessorFactory;
import org.apache.impala.extdatasource.jdbc.dao.JdbcRecordIterator;
import org.apache.impala.extdatasource.jdbc.exception.JdbcDatabaseAccessException;
import org.apache.impala.extdatasource.jdbc.util.QueryConditionUtil;
import org.apache.impala.extdatasource.thrift.TBinaryPredicate;
import org.apache.impala.extdatasource.thrift.TCloseParams;
import org.apache.impala.extdatasource.thrift.TCloseResult;
import org.apache.impala.extdatasource.thrift.TColumnDesc;
import org.apache.impala.extdatasource.thrift.TComparisonOp;
import org.apache.impala.extdatasource.thrift.TGetNextParams;
import org.apache.impala.extdatasource.thrift.TGetNextResult;
import org.apache.impala.extdatasource.thrift.TOpenParams;
import org.apache.impala.extdatasource.thrift.TOpenResult;
import org.apache.impala.extdatasource.thrift.TPrepareParams;
import org.apache.impala.extdatasource.thrift.TPrepareResult;
import org.apache.impala.extdatasource.thrift.TRowBatch;
import org.apache.impala.extdatasource.thrift.TTableSchema;
import org.apache.impala.extdatasource.v1.ExternalDataSource;
import org.apache.impala.thrift.TColumnData;
import org.apache.impala.thrift.TErrorCode;
import org.apache.impala.thrift.TStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcDataSource
implements ExternalDataSource {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcDataSource.class);
    private static final TStatus STATUS_OK = new TStatus(TErrorCode.OK, Lists.newArrayList());
    private boolean eos_ = false;
    private int batchSize_;
    private TTableSchema schema_;
    private DataSourceState state_ = DataSourceState.CREATED;
    private String scanHandle_;
    private boolean cleanDbcpDSCache_ = true;
    private Configuration tableConfig_;
    private DatabaseAccessor dbAccessor_ = null;
    private JdbcRecordIterator iterator_ = null;
    private long currRow_ = 0L;
    private long totalNumberOfRecords_ = 0L;

    public TPrepareResult prepare(TPrepareParams params) {
        Preconditions.checkState((this.state_ == DataSourceState.CREATED ? 1 : 0) != 0);
        if (!this.convertInitStringToConfiguration(params.getInit_string())) {
            return new TPrepareResult(new TStatus(TErrorCode.JDBC_CONFIGURATION_ERROR, Lists.newArrayList((Object[])new String[]{"Invalid init_string value"})));
        }
        List<Integer> acceptedPredicates = this.acceptedPredicates(params.getPredicates());
        return new TPrepareResult(STATUS_OK).setAccepted_conjuncts(acceptedPredicates);
    }

    public TOpenResult open(TOpenParams params) {
        Preconditions.checkState((this.state_ == DataSourceState.CREATED ? 1 : 0) != 0);
        this.state_ = DataSourceState.OPENED;
        this.batchSize_ = params.getBatch_size();
        this.schema_ = params.getRow_schema();
        if (params.isSetClean_dbcp_ds_cache()) {
            this.cleanDbcpDSCache_ = params.isClean_dbcp_ds_cache();
        }
        if (!this.convertInitStringToConfiguration(params.getInit_string())) {
            return new TOpenResult(new TStatus(TErrorCode.JDBC_CONFIGURATION_ERROR, Lists.newArrayList((Object[])new String[]{"Invalid init_string value"})));
        }
        try {
            Preconditions.checkState((this.tableConfig_ != null ? 1 : 0) != 0);
            this.dbAccessor_ = DatabaseAccessorFactory.getAccessor(this.tableConfig_);
            this.buildQueryAndExecute(params);
        }
        catch (JdbcDatabaseAccessException e) {
            if (this.dbAccessor_ != null) {
                this.dbAccessor_.close(null, this.cleanDbcpDSCache_);
                this.dbAccessor_ = null;
            }
            return new TOpenResult(new TStatus(TErrorCode.RUNTIME_ERROR, Lists.newArrayList((Object[])new String[]{e.getMessage()})));
        }
        this.scanHandle_ = UUID.randomUUID().toString();
        return new TOpenResult(STATUS_OK).setScan_handle(this.scanHandle_);
    }

    public TGetNextResult getNext(TGetNextParams params) {
        Preconditions.checkState((this.state_ == DataSourceState.OPENED ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)params.getScan_handle().equals(this.scanHandle_));
        if (this.eos_) {
            return new TGetNextResult(STATUS_OK).setEos(this.eos_);
        }
        ArrayList cols = Lists.newArrayList();
        long numRows = 0L;
        if (this.schema_.getColsSize() != 0) {
            if (this.iterator_ == null) {
                return new TGetNextResult(new TStatus(TErrorCode.RUNTIME_ERROR, Lists.newArrayList((Object[])new String[]{"Iterator of JDBC resultset is null"})));
            }
            for (int i = 0; i < this.schema_.getColsSize(); ++i) {
                cols.add(new TColumnData().setIs_null(Lists.newArrayList()));
            }
            boolean hasNext = true;
            try {
                while (numRows < (long)this.batchSize_ && (hasNext = this.iterator_.hasNext())) {
                    this.iterator_.next(this.schema_.getCols(), cols);
                    ++numRows;
                }
            }
            catch (UnsupportedOperationException e) {
                try {
                    Connection connToBeClosed = null;
                    if (this.iterator_ != null) {
                        Preconditions.checkNotNull((Object)this.dbAccessor_);
                        connToBeClosed = this.iterator_.getConnection();
                        this.iterator_.close();
                    }
                    if (this.dbAccessor_ != null) {
                        this.dbAccessor_.close(connToBeClosed, this.cleanDbcpDSCache_);
                    }
                    this.iterator_ = null;
                    this.dbAccessor_ = null;
                }
                catch (JdbcDatabaseAccessException e2) {
                    LOG.warn("Failed to close connection or DataSource", (Throwable)e2);
                }
                return new TGetNextResult(new TStatus(TErrorCode.JDBC_CONFIGURATION_ERROR, Lists.newArrayList((Object[])new String[]{e.getMessage()})));
            }
            catch (Exception e) {
                hasNext = false;
            }
            if (!hasNext) {
                this.eos_ = true;
            }
        } else {
            numRows = this.totalNumberOfRecords_ - this.currRow_ <= Integer.MAX_VALUE ? this.totalNumberOfRecords_ - this.currRow_ : Integer.MAX_VALUE;
            this.currRow_ += numRows;
            this.eos_ = this.currRow_ == this.totalNumberOfRecords_;
        }
        return new TGetNextResult(STATUS_OK).setEos(this.eos_).setRows(new TRowBatch().setCols(cols).setNum_rows(numRows));
    }

    public TCloseResult close(TCloseParams params) {
        Preconditions.checkState((this.state_ == DataSourceState.OPENED ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)params.getScan_handle().equals(this.scanHandle_));
        try {
            Connection connToBeClosed = null;
            if (this.iterator_ != null) {
                Preconditions.checkNotNull((Object)this.dbAccessor_);
                connToBeClosed = this.iterator_.getConnection();
                this.iterator_.close();
            }
            if (this.dbAccessor_ != null) {
                this.dbAccessor_.close(connToBeClosed, this.cleanDbcpDSCache_);
            }
            this.state_ = DataSourceState.CLOSED;
            return new TCloseResult(STATUS_OK);
        }
        catch (Exception e) {
            return new TCloseResult(new TStatus(TErrorCode.RUNTIME_ERROR, Lists.newArrayList((Object[])new String[]{e.getMessage()})));
        }
    }

    protected boolean convertInitStringToConfiguration(String initString) {
        Preconditions.checkState((initString != null ? 1 : 0) != 0);
        if (this.tableConfig_ == null) {
            try {
                TypeReference<HashMap<String, String>> typeRef = new TypeReference<HashMap<String, String>>(){};
                initString = initString.replace('\n', ' ');
                Map config = (Map)new ObjectMapper().readValue(initString, (TypeReference)typeRef);
                this.tableConfig_ = JdbcStorageConfigManager.convertMapToConfiguration(config);
            }
            catch (JsonProcessingException e) {
                String errorMessage = String.format("Invalid JSON from initString_ '%s'", initString);
                LOG.error(errorMessage, (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private List<Integer> acceptedPredicates(List<List<TBinaryPredicate>> predicates) {
        ArrayList acceptedPredicates = Lists.newArrayList();
        if (predicates == null || predicates.isEmpty()) {
            return acceptedPredicates;
        }
        for (int i = 0; i < predicates.size(); ++i) {
            boolean accepted = true;
            for (TBinaryPredicate predicate : predicates.get(i)) {
                if (predicate.getOp() != TComparisonOp.DISTINCT_FROM && predicate.getOp() != TComparisonOp.NOT_DISTINCT) continue;
                accepted = false;
                break;
            }
            if (!accepted) continue;
            acceptedPredicates.add(i);
        }
        return acceptedPredicates;
    }

    private void buildQueryAndExecute(TOpenParams params) throws JdbcDatabaseAccessException {
        Map<String, String> columnMapping = this.getColumnMapping(this.tableConfig_.get(JdbcStorageConfig.COLUMN_MAPPING.getPropertyName()));
        StringBuilder sb = new StringBuilder("SELECT ");
        String project = this.schema_.getColsSize() == 0 ? "*" : this.schema_.getCols().stream().map(TColumnDesc::getName).map(name -> columnMapping.getOrDefault(name, (String)name)).collect(Collectors.joining(", "));
        sb.append(project);
        sb.append(" FROM ");
        String jdbcTableName = this.tableConfig_.get(JdbcStorageConfig.TABLE.getPropertyName());
        if (!columnMapping.isEmpty()) {
            jdbcTableName = this.dbAccessor_.getCaseSensitiveName(jdbcTableName);
        }
        sb.append(jdbcTableName);
        String condition = QueryConditionUtil.buildCondition(params.getPredicates(), columnMapping, this.dbAccessor_);
        if (StringUtils.isNotBlank((String)condition)) {
            sb.append(" WHERE ").append(condition);
        }
        this.tableConfig_.set(JdbcStorageConfig.QUERY.getPropertyName(), sb.toString());
        LOG.trace("JDBC Query: " + sb.toString());
        if (this.schema_.getColsSize() != 0) {
            int limit = -1;
            if (params.isSetLimit()) {
                limit = (int)params.getLimit();
            }
            this.iterator_ = this.dbAccessor_.getRecordIterator(this.tableConfig_, limit, 0);
        } else {
            this.totalNumberOfRecords_ = this.dbAccessor_.getTotalNumberOfRecords(this.tableConfig_);
        }
    }

    private Map<String, String> getColumnMapping(String columnMapping) {
        String[] mappingPairs;
        if (columnMapping == null || columnMapping.trim().isEmpty()) {
            return Maps.newHashMap();
        }
        HashMap columnMap = Maps.newHashMap();
        for (String mapPair : mappingPairs = columnMapping.split(",")) {
            String[] columns = mapPair.split("=");
            String jdbcColumnName = this.dbAccessor_.getCaseSensitiveName(columns[1].trim());
            columnMap.put(columns[0].trim(), jdbcColumnName);
        }
        return columnMap;
    }

    private static enum DataSourceState {
        CREATED,
        OPENED,
        CLOSED;

    }
}

