/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.compat;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.RetryingMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FireEventRequest;
import org.apache.hadoop.hive.metastore.api.FireEventRequestData;
import org.apache.hadoop.hive.metastore.api.InsertEventRequestData;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.NotificationEventRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableValidWriteIds;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.hadoop.hive.metastore.messaging.AlterTableMessage;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;
import org.apache.hadoop.hive.metastore.messaging.MessageDeserializer;
import org.apache.hadoop.hive.metastore.messaging.MessageFactory;
import org.apache.hadoop.hive.metastore.messaging.json.JSONDropDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageFactory;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.utils.FileUtils;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.CatalogServiceCatalog;
import org.apache.impala.catalog.DataSource;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.HdfsPartition;
import org.apache.impala.catalog.HdfsTable;
import org.apache.impala.catalog.Hive3MetastoreShimBase;
import org.apache.impala.catalog.MetaStoreClientPool;
import org.apache.impala.catalog.events.MetastoreEvents;
import org.apache.impala.catalog.events.MetastoreEventsProcessor;
import org.apache.impala.catalog.events.MetastoreNotificationException;
import org.apache.impala.catalog.events.SelfEventContext;
import org.apache.impala.catalog.local.MetaProvider;
import org.apache.impala.catalog.metastore.ICatalogMetastoreServer;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.common.Metrics;
import org.apache.impala.service.CatalogOpExecutor;
import org.apache.impala.util.AcidUtils;
import org.apache.impala.util.HiveMetadataFormatUtils;
import org.apache.impala.util.MetaStoreUtil;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetastoreShim
extends Hive3MetastoreShimBase {
    private static final Logger LOG = LoggerFactory.getLogger(MetastoreShim.class);
    public static final byte ACCESSTYPE_NONE = 1;
    public static final byte ACCESSTYPE_READONLY = 2;
    public static final byte ACCESSTYPE_WRITEONLY = 4;
    public static final byte ACCESSTYPE_READWRITE = 8;
    private static final String ACCESSTYPE = "accessType";
    private static final String WRITEID = "writeId";
    private static final String ID = "id";
    private static final String MANAGEDLOCATIONURI = "managedLocationUri";
    private static final String CONNECTORREAD = "CONNECTORREAD";
    private static final String CONNECTORWRITE = "CONNECTORWRITE";
    private static List<String> processorCapabilities = Lists.newArrayList();

    public static void alterTableWithTransaction(IMetaStoreClient client, Table tbl, AcidUtils.TblTransaction tblTxn) throws ImpalaRuntimeException {
        throw new UnsupportedOperationException("alterTableWithTransaction is not supported.");
    }

    public static void alterPartitionsWithTransaction(IMetaStoreClient client, String dbName, String tblName, List<Partition> partitions, AcidUtils.TblTransaction tblTxn) throws InvalidOperationException, MetaException, TException {
        throw new UnsupportedOperationException("alterPartitionsWithTransaction is not supported.");
    }

    public static List<ColumnStatisticsObj> getTableColumnStatistics(IMetaStoreClient client, String dbName, String tableName, List<String> colNames) throws NoSuchObjectException, MetaException, TException {
        return client.getTableColumnStatistics(dbName, tableName, colNames);
    }

    public static boolean deleteTableColumnStatistics(IMetaStoreClient client, String dbName, String tableName, String colName) throws NoSuchObjectException, MetaException, InvalidObjectException, TException, InvalidInputException {
        return client.deleteTableColumnStatistics(dbName, tableName, colName);
    }

    public static ColumnStatistics createNewHiveColStats() {
        ColumnStatistics colStats = new ColumnStatistics();
        return colStats;
    }

    public static MessageDeserializer getMessageDeserializer() {
        return MessageFactory.getInstance().getDeserializer();
    }

    public static String makePartName(List<String> partitionColNames, List<String> values) {
        return FileUtils.makePartName(partitionColNames, values);
    }

    @VisibleForTesting
    public static AlterTableMessage buildAlterTableMessage(Table before, Table after, boolean isTruncateOp, long writeId) {
        return JSONMessageFactory.getInstance().buildAlterTableMessage(before, after, isTruncateOp);
    }

    @VisibleForTesting
    public static String serializeEventMessage(EventMessage message) {
        return message.toString();
    }

    public static ValidWriteIdList fetchValidWriteIds(IMetaStoreClient client, String tableFullName) throws TException {
        ValidTxnList txns = client.getValidTxns();
        List<String> tablesList = Collections.singletonList(tableFullName);
        List writeIdList = client.getValidWriteIds(tablesList, txns.toString());
        return TxnUtils.createValidReaderWriteIdList((TableValidWriteIds)((TableValidWriteIds)writeIdList.get(0)));
    }

    public static long getWriteIdFromMSPartition(Partition partition) {
        Preconditions.checkNotNull((Object)partition);
        return NumberUtils.toLong((String)((String)partition.getParameters().get(WRITEID)), (long)-1L);
    }

    public static void setWriteIdToMSPartition(Partition partition, long writeId) {
        Preconditions.checkNotNull((Object)partition);
        partition.getParameters().put(WRITEID, String.valueOf(writeId));
    }

    public static long getWriteIdFromMSTable(Table msTbl) {
        Preconditions.checkNotNull((Object)msTbl);
        return NumberUtils.toLong((String)((String)msTbl.getParameters().get(WRITEID)), (long)-1L);
    }

    public static synchronized void setHiveClientCapabilities() {
        if (capabilitiestSet_) {
            return;
        }
        Object[] capabilities = new String[]{"EXTWRITE", "EXTREAD", "HIVEMANAGEDINSERTREAD", "HIVEMANAGEDINSERTWRITE", "HIVEFULLACIDREAD", "HIVEFULLACIDWRITE", "HIVESQL", "HIVEMQT", "HIVEBUCKET2"};
        processorCapabilities = Lists.newArrayList((Object[])capabilities);
        capabilitiestSet_ = true;
    }

    public static boolean hasTableCapability(Table msTbl, byte requiredCapability) {
        Preconditions.checkNotNull((Object)msTbl);
        return requiredCapability != 1 && (MetastoreShim.getAccessType(msTbl) & requiredCapability) != 0;
    }

    public static String getTableAccessType(Table msTbl) {
        Preconditions.checkNotNull((Object)msTbl);
        switch (MetastoreShim.getAccessType(msTbl)) {
            case 2: {
                return "READONLY";
            }
            case 4: {
                return "WRITEONLY";
            }
            case 8: {
                return "READWRITE";
            }
        }
        return "NONE";
    }

    public static void setTableAccessType(Table msTbl, byte accessType) {
        Preconditions.checkNotNull((Object)msTbl);
        msTbl.getParameters().put(ACCESSTYPE, String.valueOf(accessType));
    }

    public static void setTableColumnStatsTransactional(IMetaStoreClient client, Table msTbl, ColumnStatistics colStats, AcidUtils.TblTransaction tblTxn) throws ImpalaRuntimeException {
        throw new UnsupportedOperationException("setTableColumnStatsTransactional is not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Long> fireInsertEvents(MetaStoreClientPool.MetaStoreClient msClient, MetaStoreUtil.TableInsertEventInfo insertEventInfo, String dbName, String tableName) {
        Stopwatch sw;
        block5: {
            List<Long> list;
            sw = Stopwatch.createStarted();
            try {
                if (insertEventInfo.isTransactional()) {
                    MetastoreShim.fireInsertTransactionalEventHelper(msClient.getHiveClient(), insertEventInfo, dbName, tableName);
                    break block5;
                }
                list = MetastoreShim.fireInsertEventHelper(msClient.getHiveClient(), insertEventInfo.getInsertEventReqData(), insertEventInfo.getInsertEventPartVals(), dbName, tableName);
            }
            catch (Exception e) {
                try {
                    LOG.error("Failed to fire insert event. Some tables might not be refreshed on other impala clusters.", (Throwable)e);
                }
                catch (Throwable throwable) {
                    LOG.info("Time taken to fire insert events on table {}.{}: {} msec", new Object[]{dbName, tableName, sw.stop().elapsed(TimeUnit.MILLISECONDS)});
                    msClient.close();
                    throw throwable;
                }
                LOG.info("Time taken to fire insert events on table {}.{}: {} msec", new Object[]{dbName, tableName, sw.stop().elapsed(TimeUnit.MILLISECONDS)});
                msClient.close();
            }
            LOG.info("Time taken to fire insert events on table {}.{}: {} msec", new Object[]{dbName, tableName, sw.stop().elapsed(TimeUnit.MILLISECONDS)});
            msClient.close();
            return list;
        }
        LOG.info("Time taken to fire insert events on table {}.{}: {} msec", new Object[]{dbName, tableName, sw.stop().elapsed(TimeUnit.MILLISECONDS)});
        msClient.close();
        return Collections.emptyList();
    }

    private static void fireInsertTransactionalEventHelper(IMetaStoreClient hiveClient, MetaStoreUtil.TableInsertEventInfo insertEventInfo, String dbName, String tableName) throws TException {
        throw new UnsupportedOperationException("fireInsertTransactionalEventHelper is not supported.");
    }

    @VisibleForTesting
    public static List<Long> fireInsertEventHelper(IMetaStoreClient msClient, List<InsertEventRequestData> insertEventDataList, List<List<String>> insertEventPartValList, String dbName, String tableName) throws TException {
        Preconditions.checkNotNull((Object)msClient);
        Preconditions.checkNotNull((Object)dbName);
        Preconditions.checkNotNull((Object)tableName);
        Preconditions.checkState((!insertEventDataList.isEmpty() ? 1 : 0) != 0, (Object)"Atleast one insert event info must be provided.");
        Preconditions.checkState((insertEventDataList.size() == insertEventPartValList.size() ? 1 : 0) != 0);
        LOG.debug(String.format("Firing %s insert event(s) for %s.%s", insertEventDataList.size(), dbName, tableName));
        for (int i = 0; i < insertEventDataList.size(); ++i) {
            InsertEventRequestData insertEventData = insertEventDataList.get(i);
            List<String> partitionVals = insertEventPartValList.get(i);
            FireEventRequestData data = new FireEventRequestData();
            FireEventRequest rqst = new FireEventRequest(true, data);
            rqst.setDbName(dbName);
            rqst.setTableName(tableName);
            if (partitionVals != null && !partitionVals.isEmpty()) {
                rqst.setPartitionVals(partitionVals);
            }
            data.setInsertData(insertEventData);
            msClient.fireListenerEvent(rqst);
        }
        return Collections.EMPTY_LIST;
    }

    @VisibleForTesting
    public static List<Long> fireReloadEventHelper(MetaStoreClientPool.MetaStoreClient msClient, boolean isRefresh, List<String> partVals, String dbName, String tableName, Map<String, String> selfEventParams) throws TException {
        throw new UnsupportedOperationException("Reload event is not supported.");
    }

    public static Map<String, Object> getFieldsFromReloadEvent(NotificationEvent event) throws MetastoreNotificationException {
        throw new UnsupportedOperationException("Reload event is not supported.");
    }

    public static String getPartitionNameFromCommitCompactionEvent(NotificationEvent event) {
        throw new UnsupportedOperationException("CommitCompaction event is not supported.");
    }

    public static NotificationEventResponse getNextNotification(IMetaStoreClient msClient, NotificationEventRequest eventRequest, List<String> eventTypeSkipList) throws TException {
        return MetastoreShim.getThriftClient(msClient).get_next_notification(eventRequest);
    }

    private static ThriftHiveMetastore.Client getThriftClient(IMetaStoreClient msClient) throws MetaException {
        try {
            Object client;
            if (Proxy.isProxyClass(msClient.getClass())) {
                RetryingMetaStoreClient handler = (RetryingMetaStoreClient)Proxy.getInvocationHandler(msClient);
                msClient = (IMetaStoreClient)FieldUtils.readField((Object)handler, (String)"base", (boolean)true);
            }
            if ((client = FieldUtils.readField((Object)msClient, (String)"client", (boolean)true)) == null) {
                throw new MetaException("Client is not initialized");
            }
            if (!(client instanceof ThriftHiveMetastore.Client)) {
                throw new MetaException("getThriftClient is only supported in remote metastore mode.");
            }
            return (ThriftHiveMetastore.Client)client;
        }
        catch (IllegalAccessException e) {
            throw new MetaException("getThriftClient() fail: " + e.getMessage());
        }
    }

    public static void setManagedLocationUri(Database db, String managedLocation) {
        db.getParameters().put(MANAGEDLOCATIONURI, managedLocation);
    }

    public static String getManagedLocationUri(Database db) {
        if (db.getParameters().containsKey(MANAGEDLOCATIONURI)) {
            return (String)db.getParameters().get(MANAGEDLOCATIONURI);
        }
        return null;
    }

    public static void setTableLocation(Db db, Table tbl) throws ImpalaRuntimeException {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)tbl);
        try {
            if (tbl.getSd().getLocation() == null || tbl.getSd().getLocation().isEmpty()) {
                tbl.getSd().setLocation(MetastoreShim.getPathForNewTable(db.getMetaStoreDb(), tbl));
            }
        }
        catch (MetaException e) {
            throw new ImpalaRuntimeException("setTableLocation", e);
        }
    }

    public static long getTableId(Table tbl) {
        return NumberUtils.toLong((String)((String)tbl.getParameters().get(ID)), (long)-1L);
    }

    public static Database getDatabaseObject(JSONDropDatabaseMessage dropDatabaseMessage) {
        Database database = new Database();
        database.setName(dropDatabaseMessage.getDB());
        return database;
    }

    public static void truncateTable(IMetaStoreClient msClient, String dbName, String tableName, List<String> partNames, String validWriteIds, long writeId) throws TException {
        msClient.truncateTable(dbName, tableName, partNames);
    }

    public static List<Partition> getPartitions(IMetaStoreClient msClient, String testDbName, String testTblName) throws TException {
        return msClient.listPartitions(testDbName, testTblName, (short)-1);
    }

    public static void setPartitionVal(InsertEventRequestData insertEventRequestData, List<String> partVals) {
    }

    public static void addToSubDirectoryList(InsertEventRequestData insertEventRequestData, String acidDirPath) {
        throw new UnsupportedOperationException("addToSubDirectoryList is not supported.");
    }

    public static List<HdfsPartition.Builder> getPartitionsForRefreshingFileMetadata(CatalogServiceCatalog catalog, HdfsTable hdfsTable) throws CatalogException {
        throw new UnsupportedOperationException("getPartitionsForRefreshingFileMetadata is not supported.");
    }

    public static Map<String, Long> getLatestCompactions(MetaStoreClientPool.MetaStoreClient client, String dbName, String tableName, List<String> partitionNames, String unPartitionedName, long lastCompactionId) throws TException {
        throw new UnsupportedOperationException("getLatestCompactions is not supported.");
    }

    public static List<MetaProvider.PartitionRef> checkLatestCompaction(MetaStoreClientPool msClientPool, String dbName, String tableName, MetaProvider.TableMetaRef table, Map<MetaProvider.PartitionRef, MetaProvider.PartitionMetadata> metas, String unPartitionedName) throws TException {
        throw new UnsupportedOperationException("checkLatestCompaction is not supported.");
    }

    public static ICatalogMetastoreServer getCatalogMetastoreServer(CatalogOpExecutor catalogOpExecutor) {
        throw new UnsupportedOperationException("getCatalogMetastoreServer is not supported.");
    }

    private static byte getAccessType(Table msTbl) {
        Preconditions.checkNotNull((Object)msTbl);
        byte accessType = 1;
        Map params = msTbl.getParameters();
        if (params.containsKey(ACCESSTYPE)) {
            String accessTypeStr = (String)msTbl.getParameters().get(ACCESSTYPE);
            accessType = accessTypeStr.getBytes()[0];
        } else {
            if (!capabilitiestSet_) {
                MetastoreShim.setHiveClientCapabilities();
            }
            String tableType = msTbl.getTableType();
            String tCapabilities = (String)params.get("OBJCAPABILITIES");
            int numBuckets = msTbl.isSetSd() ? msTbl.getSd().getNumBuckets() : 0;
            boolean isBucketed = numBuckets > 0;
            LOG.info("Table " + msTbl.getTableName() + ",#bucket=" + numBuckets + ",isBucketed:" + isBucketed + ",tableType=" + tableType + ",tableCapabilities=" + tCapabilities);
            if (tCapabilities == null) {
                LOG.debug("Table has no specific required capabilities");
                switch (tableType) {
                    case "EXTERNAL_TABLE": {
                        if (numBuckets > 0) {
                            if (processorCapabilities.contains("HIVEBUCKET2")) {
                                LOG.debug("External bucketed table with HB2 capability:RW");
                                accessType = 8;
                                break;
                            }
                            LOG.debug("External bucketed table without HB2 capability:RO");
                            accessType = 2;
                            break;
                        }
                        if (processorCapabilities.contains("EXTWRITE") && processorCapabilities.contains("EXTREAD")) {
                            LOG.debug("External unbucketed table with EXTREAD/WRITE capability:RW");
                            accessType = 8;
                            break;
                        }
                        if (processorCapabilities.contains("EXTREAD")) {
                            LOG.debug("External unbucketed table with EXTREAD capability:RO");
                            accessType = 2;
                            break;
                        }
                        LOG.debug("External unbucketed table without EXTREAD/WRITE capability:NONE");
                        accessType = 1;
                        break;
                    }
                    case "MANAGED_TABLE": {
                        String txnal = (String)params.get("transactional");
                        if (txnal == null || txnal.equalsIgnoreCase("FALSE")) {
                            LOG.debug("Managed non-acid table:RW");
                            accessType = 8;
                        }
                        if (txnal == null || !txnal.equalsIgnoreCase("TRUE")) break;
                        String txntype = (String)params.get("transactional_properties");
                        if (txntype != null && txntype.equalsIgnoreCase("insert_only")) {
                            if (processorCapabilities.contains("HIVEMANAGEDINSERTWRITE") || processorCapabilities.contains(CONNECTORWRITE)) {
                                LOG.debug("Managed acid table with INSERTWRITE or CONNECTORWRITE capability:RW");
                                accessType = 8;
                                LOG.info("Processor has one of the write capabilities on insert-only, granting RW");
                                break;
                            }
                            if (processorCapabilities.contains("HIVEMANAGEDINSERTREAD") || processorCapabilities.contains(CONNECTORREAD)) {
                                LOG.debug("Managed acid table with INSERTREAD or CONNECTORREAD capability:RO");
                                accessType = 2;
                                LOG.info("Processor has one of the read capabilities on insert-only, granting RO");
                                break;
                            }
                            accessType = 1;
                            LOG.info("Processor has no read or write capabilities on insert-only, NO access");
                            break;
                        }
                        if (processorCapabilities.contains("HIVEFULLACIDWRITE") || processorCapabilities.contains(CONNECTORWRITE)) {
                            LOG.debug("Full acid table with ACIDWRITE or CONNECTORWRITE capability:RW");
                            accessType = 8;
                            break;
                        }
                        if (processorCapabilities.contains("HIVEFULLACIDREAD") || processorCapabilities.contains(CONNECTORREAD)) {
                            LOG.debug("Full acid table with ACIDREAD or CONNECTORREAD capability:RO");
                            accessType = 2;
                            break;
                        }
                        LOG.debug("Full acid table without ACIDREAD/WRITE or CONNECTORREAD/WRITE capability:NONE");
                        accessType = 1;
                        break;
                    }
                    case "VIRTUAL_VIEW": {
                        if (processorCapabilities.contains("HIVESQL") || processorCapabilities.contains(CONNECTORREAD)) {
                            accessType = 2;
                            break;
                        }
                        accessType = 1;
                        break;
                    }
                    case "MATERIALIZED_VIEW": {
                        if ((processorCapabilities.contains(CONNECTORREAD) || processorCapabilities.contains("HIVEFULLACIDREAD")) && processorCapabilities.contains("HIVEMQT")) {
                            LOG.info("Processor has one of the READ abilities and HIVEMQT, AccessType=RO");
                            accessType = 2;
                            break;
                        }
                        LOG.info("Processor has no READ abilities or HIVEMQT, AccessType=None");
                        accessType = 1;
                        break;
                    }
                    default: {
                        accessType = 1;
                    }
                }
                return accessType;
            }
            tCapabilities = tCapabilities.replaceAll("\\s", "").toUpperCase();
            List<String> requiredCapabilities = Arrays.asList(tCapabilities.split(","));
            switch (tableType) {
                case "EXTERNAL_TABLE": {
                    if (processorCapabilities.containsAll(requiredCapabilities)) {
                        LOG.info("Abilities for match: Table type=" + tableType + ",accesstype is RW");
                        accessType = 8;
                        break;
                    }
                    if (requiredCapabilities.contains("EXTWRITE") && processorCapabilities.contains("EXTWRITE") && !isBucketed) {
                        LOG.info("EXTWRITE Matches, accessType=8");
                        accessType = 8;
                        return accessType;
                    }
                    if (requiredCapabilities.contains("EXTREAD") && processorCapabilities.contains("EXTREAD")) {
                        LOG.info("EXTREAD Matches, accessType=2");
                        accessType = 2;
                        break;
                    }
                    LOG.debug("No matches, accessType=1");
                    accessType = 1;
                    break;
                }
                case "MANAGED_TABLE": {
                    if (processorCapabilities.size() == 0) {
                        LOG.info("Client has no capabilities for type " + tableType + ",accesstype is NONE");
                        accessType = 1;
                        return accessType;
                    }
                    if (processorCapabilities.containsAll(requiredCapabilities)) {
                        LOG.info("Abilities for match: Table type=" + tableType + ",accesstype is RW");
                        accessType = 8;
                        return accessType;
                    }
                    String txnal = (String)params.get("transactional");
                    if (txnal == null || txnal.equalsIgnoreCase("FALSE")) {
                        LOG.info("Table is non ACID, accesstype is RO");
                        accessType = 2;
                        return accessType;
                    }
                    if (txnal == null || !txnal.equalsIgnoreCase("TRUE")) break;
                    String txntype = (String)params.get("transactional_properties");
                    ArrayList hintList = new ArrayList();
                    if (txntype != null && txntype.equalsIgnoreCase("insert_only")) {
                        LOG.info("Table is INSERTONLY ACID");
                        if (processorCapabilities.containsAll(MetastoreShim.getWrites(requiredCapabilities)) || processorCapabilities.contains("HIVEFULLACIDWRITE")) {
                            LOG.info("Processor has all writes or full acid write, access is RW");
                            accessType = 8;
                            return accessType;
                        }
                        if (processorCapabilities.contains(CONNECTORWRITE)) {
                            LOG.debug("Managed acid table with CONNECTORWRITE capability:RW");
                            accessType = 8;
                            return accessType;
                        }
                        if (processorCapabilities.containsAll(MetastoreShim.getReads(requiredCapabilities)) || processorCapabilities.contains("HIVEMANAGEDINSERTREAD")) {
                            LOG.debug("Managed acid table with MANAGEDREAD capability:RO");
                            accessType = 2;
                            return accessType;
                        }
                        if (processorCapabilities.contains(CONNECTORREAD)) {
                            LOG.debug("Managed acid table with CONNECTORREAD capability:RO");
                            accessType = 2;
                            return accessType;
                        }
                        LOG.debug("Managed acid table without any READ capability:NONE");
                        accessType = 1;
                        return accessType;
                    }
                    LOG.info("Table is FULLACID");
                    if (processorCapabilities.containsAll(MetastoreShim.getWrites(requiredCapabilities)) || processorCapabilities.contains("HIVEFULLACIDWRITE")) {
                        LOG.info("Processor has all writes or atleast HIVEFULLACIDWRITE, access is RW");
                        accessType = 8;
                        return accessType;
                    }
                    if (processorCapabilities.contains(CONNECTORWRITE)) {
                        LOG.debug("Full acid table with CONNECTORWRITE capability:RW");
                        accessType = 8;
                        return accessType;
                    }
                    if (processorCapabilities.contains("HIVEFULLACIDREAD") || processorCapabilities.contains(CONNECTORREAD)) {
                        LOG.debug("Full acid table with CONNECTORREAD/ACIDREAD capability:RO");
                        accessType = 2;
                        return accessType;
                    }
                    LOG.debug("Full acid table without READ capability:RO");
                    accessType = 1;
                    return accessType;
                }
                case "VIRTUAL_VIEW": 
                case "MATERIALIZED_VIEW": {
                    if (processorCapabilities.containsAll(requiredCapabilities)) {
                        accessType = 2;
                        break;
                    }
                    accessType = 1;
                    break;
                }
                default: {
                    accessType = 1;
                }
            }
        }
        return accessType;
    }

    private static List<String> getWrites(List<String> capabilities) {
        ArrayList<String> writes = new ArrayList<String>();
        for (String capability : capabilities) {
            if (!capability.toUpperCase().endsWith("WRITE") && !capability.toUpperCase().endsWith("STATS") && !capability.toUpperCase().endsWith("INVALIDATE")) continue;
            writes.add(capability);
        }
        return writes;
    }

    private static List<String> getReads(List<String> capabilities) {
        ArrayList<String> reads = new ArrayList<String>();
        for (String capability : capabilities) {
            if (!capability.toUpperCase().endsWith("READ") && !capability.toUpperCase().endsWith("SQL")) continue;
            reads.add(capability);
        }
        return reads;
    }

    public static void getMaterializedViewInfo(StringBuilder tableInfo, Table tbl, boolean isOutputPadded) {
        HiveMetadataFormatUtils.formatOutput("View Original Text:", tbl.getViewOriginalText(), tableInfo);
        HiveMetadataFormatUtils.formatOutput("View Expanded Text:", tbl.getViewExpandedText(), tableInfo);
        HiveMetadataFormatUtils.formatOutput("Rewrite Enabled:", tbl.isRewriteEnabled() ? "Yes" : "No", tableInfo);
        HiveMetadataFormatUtils.formatOutput("Outdated for Rewriting:", "Unknown", tableInfo);
    }

    public static void createDataSource(IMetaStoreClient client, DataSource dataSource) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
    }

    public static void dropDataSource(IMetaStoreClient client, String name, boolean ifExists) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
    }

    public static Map<String, DataSource> loadAllDataSources(IMetaStoreClient client) throws MetaException, TException {
        return null;
    }

    public static void setNotificationEventRequestWithFilter(NotificationEventRequest eventRequest, MetastoreEventsProcessor.MetaDataFilter metaDataFilter) {
    }

    public static class CommitTxnEvent
    extends MetastoreEvents.MetastoreEvent {
        public CommitTxnEvent(CatalogOpExecutor catalogOpExecutor, Metrics metrics, NotificationEvent event) {
            super(catalogOpExecutor, metrics, event);
            throw new UnsupportedOperationException("CommitTxnEvent is not supported.");
        }

        @Override
        protected void process() throws MetastoreNotificationException {
        }

        @Override
        protected boolean onFailure(Exception e) {
            return false;
        }

        @Override
        protected boolean isEventProcessingDisabled() {
            return false;
        }

        @Override
        protected SelfEventContext getSelfEventContext() {
            return null;
        }

        @Override
        protected boolean shouldSkipWhenSyncingToLatestEventId() {
            return false;
        }
    }
}

