/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.common;

import org.apache.impala.analysis.SlotId;
import org.apache.impala.analysis.TupleId;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.planner.TupleCacheInfo;

public class ThriftSerializationCtx {
    private TupleCacheInfo tupleCacheInfo_;

    public ThriftSerializationCtx(TupleCacheInfo tupleCacheInfo) {
        this.tupleCacheInfo_ = tupleCacheInfo;
    }

    public ThriftSerializationCtx() {
        this.tupleCacheInfo_ = null;
    }

    public boolean isTupleCache() {
        return this.tupleCacheInfo_ != null;
    }

    public void registerTuple(TupleId id) {
        if (this.isTupleCache()) {
            this.tupleCacheInfo_.registerTuple(id);
        }
    }

    public void registerTable(FeTable table) {
        if (this.isTupleCache()) {
            this.tupleCacheInfo_.registerTable(table);
        }
    }

    public TupleId translateTupleId(TupleId globalId) {
        if (this.isTupleCache()) {
            return this.tupleCacheInfo_.getLocalTupleId(globalId);
        }
        return globalId;
    }

    public SlotId translateSlotId(SlotId globalId) {
        if (this.isTupleCache()) {
            return this.tupleCacheInfo_.getLocalSlotId(globalId);
        }
        return globalId;
    }
}

