/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.common;

import com.google.common.base.Joiner;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;

public class PrintUtils {
    public static final long KILO = 1000L;
    public static final long MEGA = 1000000L;
    public static final long GIGA = 1000000000L;
    public static final long TERA = 1000000000000L;
    public static final String METRIC_REGEX = "(\\d+(?:.\\d+)?)([TGMK]?)";
    public static final Pattern METRIC_PATTERN = Pattern.compile("(\\d+(?:.\\d+)?)([TGMK]?)", 2);

    public static String printBytes(long bytes) {
        double result = bytes;
        if (bytes >= 0x4000000000000L) {
            return new DecimalFormat(".00PB").format(result / 1.125899906842624E15);
        }
        if (bytes >= 0x10000000000L) {
            return new DecimalFormat(".00TB").format(result / 1.099511627776E12);
        }
        if (bytes >= 0x40000000L) {
            return new DecimalFormat(".00GB").format(result / 1.073741824E9);
        }
        if (bytes >= 0x100000L) {
            return new DecimalFormat(".00MB").format(result / 1048576.0);
        }
        if (bytes >= 1024L) {
            return new DecimalFormat(".00KB").format(result / 1024.0);
        }
        return bytes + "B";
    }

    public static String printMetric(long value) {
        double result = value;
        if (value >= 1000000000000L) {
            return new DecimalFormat(".00T").format(result / 1.0E12);
        }
        if (value >= 1000000000L) {
            return new DecimalFormat(".00G").format(result / 1.0E9);
        }
        if (value >= 1000000L) {
            return new DecimalFormat(".00M").format(result / 1000000.0);
        }
        if (value >= 1000L) {
            return new DecimalFormat(".00K").format(result / 1000.0);
        }
        return Long.toString(value);
    }

    public static double decodeMetric(String value) {
        Matcher m = METRIC_PATTERN.matcher(value);
        if (!m.matches()) {
            return -1.0;
        }
        return PrintUtils.decodeMetric(m.group(1), m.group(2));
    }

    public static double decodeMetric(String valueStr, String units) {
        double value = Double.parseDouble(valueStr);
        switch (units.toUpperCase()) {
            case "": {
                return value;
            }
            case "K": {
                return value * 1000.0;
            }
            case "M": {
                return value * 1000000.0;
            }
            case "G": {
                return value * 1.0E9;
            }
            case "T": {
                return value * 1.0E12;
            }
        }
        return -1.0;
    }

    public static String printBytesRoundedToMb(long bytes) {
        double result = bytes;
        if (bytes >= 0x4000000000000L) {
            return new DecimalFormat(".00PB").format(result / 1.125899906842624E15);
        }
        if (bytes >= 0x10000000000L) {
            return new DecimalFormat(".00TB").format(result / 1.099511627776E12);
        }
        if (bytes >= 0x40000000L) {
            return new DecimalFormat(".00GB").format(result / 1.073741824E9);
        }
        if (bytes >= 0x100000L) {
            return new DecimalFormat("0MB").format(result / 1048576.0);
        }
        if (bytes >= 1024L) {
            return new DecimalFormat("0KB").format(result / 1024.0);
        }
        return bytes + "B";
    }

    public static String printEstCardinality(long cardinality) {
        return cardinality != -1L ? PrintUtils.printMetric(cardinality) : "unavailable";
    }

    public static String printExactCardinality(long value) {
        if (value == -1L) {
            return "unavailable";
        }
        String result = PrintUtils.printMetric(value);
        if (value < 1000L) {
            return result;
        }
        return String.format("%s (%,d)", result, value);
    }

    public static String printNumHosts(String prefix, long numHosts) {
        return prefix + "hosts=" + (numHosts != -1L ? Long.valueOf(numHosts) : "unavailable");
    }

    public static String printNumInstances(String prefix, long numInstances) {
        return prefix + "instances=" + (numInstances != -1L ? Long.valueOf(numInstances) : "unavailable");
    }

    public static void printMatrix(boolean[][] matrix, int cellSpacing, StringBuilder matrixStr) {
        int i;
        matrixStr.append(StringUtils.repeat((char)' ', (int)cellSpacing));
        String formatStr = "%Xd".replace("X", String.valueOf(cellSpacing));
        for (i = 0; i < matrix.length; ++i) {
            matrixStr.append(String.format(formatStr, i));
        }
        matrixStr.append("\n");
        for (i = 0; i < matrix.length; ++i) {
            matrixStr.append(String.format(formatStr, i));
            for (int j = 0; j < matrix.length; ++j) {
                int cell = matrix[i][j] ? 1 : 0;
                matrixStr.append(String.format(formatStr, cell));
            }
            matrixStr.append("\n");
        }
    }

    public static String wrapString(String s, int wrapLength) {
        String wrapped = WordUtils.wrap((String)s, (int)wrapLength, null, (boolean)true);
        wrapped = wrapped.replaceAll(" +$", "");
        return wrapped;
    }

    public static String joinQuoted(Iterable<?> objs) {
        Iterator<?> it = objs.iterator();
        if (!it.hasNext()) {
            return "";
        }
        return "'" + Joiner.on((String)"', '").join(it) + "'";
    }

    public static String printTimeNs(long value) {
        if (value < 0L) {
            return "";
        }
        if (value >= 1000000000L) {
            return PrintUtils.printTimeMs(value / 1000000L);
        }
        if (value >= 1000000L) {
            return String.format("%.3fms", (double)value / 1000000.0);
        }
        if (value >= 1000L) {
            return String.format("%.3fus", (double)value / 1000.0);
        }
        return value + "ns";
    }

    public static String printTimeMs(long value) {
        if (value < 0L) {
            return "";
        }
        boolean hour = false;
        boolean minute = false;
        boolean second = false;
        StringBuilder sb = new StringBuilder();
        if (value >= 3600000L) {
            sb.append(value / 3600000L).append("h");
            value %= 3600000L;
            hour = true;
        }
        if (value >= 60000L) {
            sb.append(value / 60000L).append("m");
            value %= 60000L;
            minute = true;
        }
        if (!hour && value >= 1000L) {
            sb.append(value / 1000L).append("s");
            value %= 1000L;
            second = true;
        }
        if (!hour && !minute && value != 0L) {
            String remainTime = String.valueOf(value);
            if (second) {
                while (remainTime.length() < 3) {
                    remainTime = "0" + remainTime;
                }
            }
            sb.append(remainTime).append("ms");
        }
        return sb.toString();
    }
}

