/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.common;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.text.DecimalFormat;
import java.util.Map;

public final class Metrics {
    private static final DecimalFormat decimalFormatter_ = new DecimalFormat("#.####");
    private final MetricRegistry registry_ = new MetricRegistry();

    public void addCounter(String name) {
        this.registry_.counter(name);
    }

    public void addMeter(String name) {
        this.registry_.meter(name);
    }

    public void addHistogram(String name) {
        this.registry_.histogram(name);
    }

    public void addTimer(String name) {
        this.registry_.timer(name);
    }

    public <T extends Gauge> void addGauge(String name, T gauge) {
        this.registry_.register(name, gauge);
    }

    public Counter getCounter(String name) {
        Counter counter = (Counter)this.registry_.getCounters().get(name);
        if (counter == null) {
            counter = this.registry_.counter(name);
        }
        return counter;
    }

    public Meter getMeter(String name) {
        Meter meter = (Meter)this.registry_.getMeters().get(name);
        if (meter == null) {
            meter = this.registry_.meter(name);
        }
        return meter;
    }

    public Histogram getHistogram(String name) {
        Histogram histogram = (Histogram)this.registry_.getHistograms().get(name);
        if (histogram == null) {
            histogram = this.registry_.histogram(name);
        }
        return histogram;
    }

    public Timer getTimer(String name) {
        Timer timer = (Timer)this.registry_.getTimers().get(name);
        if (timer == null) {
            timer = this.registry_.timer(name);
        }
        return timer;
    }

    public Gauge getGauge(String name) {
        return (Gauge)this.registry_.getGauges().get(name);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (Map.Entry entry : this.registry_.getCounters().entrySet()) {
            result.append((String)entry.getKey() + ": " + String.valueOf(((Counter)entry.getValue()).getCount()));
            result.append("\n");
        }
        for (Map.Entry entry : this.registry_.getTimers().entrySet()) {
            result.append((String)entry.getKey() + ": " + this.timerToString((Timer)entry.getValue()));
            result.append("\n");
        }
        for (Map.Entry entry : this.registry_.getGauges().entrySet()) {
            result.append((String)entry.getKey() + ": " + String.valueOf(((Gauge)entry.getValue()).getValue()));
            result.append("\n");
        }
        for (Map.Entry entry : this.registry_.getHistograms().entrySet()) {
            result.append((String)entry.getKey() + ": " + this.snapshotToString(((Histogram)entry.getValue()).getSnapshot()));
            result.append("\n");
        }
        for (Map.Entry entry : this.registry_.getMeters().entrySet()) {
            result.append((String)entry.getKey()).append(":").append(this.meterToString((Meter)entry.getValue()));
            result.append("\n");
        }
        return result.toString();
    }

    private String timerToString(Timer timer) {
        StringBuilder builder = new StringBuilder();
        return builder.append("\n   Count: " + timer.getCount()).append("\n   Mean rate: ").append(decimalFormatter_.format(timer.getMeanRate())).append("\n   1 min. rate: ").append(decimalFormatter_.format(timer.getOneMinuteRate())).append("\n   5 min. rate: ").append(decimalFormatter_.format(timer.getFiveMinuteRate())).append("\n   15 min. rate: ").append(decimalFormatter_.format(timer.getFifteenMinuteRate())).append(this.snapshotToString(timer.getSnapshot())).toString();
    }

    private String meterToString(Meter meter) {
        StringBuilder builder = new StringBuilder();
        return builder.append("\n   Count: ").append(meter.getCount()).append("\n   Mean rate: ").append(decimalFormatter_.format(meter.getMeanRate())).append("\n   1 min. rate: ").append(decimalFormatter_.format(meter.getOneMinuteRate())).append("\n   5 min. rate: ").append(decimalFormatter_.format(meter.getFiveMinuteRate())).append("\n   15 min. rate: ").append(decimalFormatter_.format(meter.getFifteenMinuteRate())).toString();
    }

    private String snapshotToString(Snapshot snapshot) {
        StringBuilder builder = new StringBuilder();
        return builder.append("\n   Min (msec): ").append(decimalFormatter_.format(snapshot.getMin() / 1000000L)).append("\n   Max (msec): ").append(decimalFormatter_.format(snapshot.getMax() / 1000000L)).append("\n   Mean (msec): ").append(decimalFormatter_.format(snapshot.getMean() / 1000000.0)).append("\n   Median (msec): ").append(decimalFormatter_.format(snapshot.getMedian() / 1000000.0)).append("\n   75th-% (msec): ").append(decimalFormatter_.format(snapshot.get75thPercentile() / 1000000.0)).append("\n   95th-% (msec): ").append(decimalFormatter_.format(snapshot.get95thPercentile() / 1000000.0)).append("\n   99th-% (msec): ").append(decimalFormatter_.format(snapshot.get99thPercentile() / 1000000.0)).append("\n").toString();
    }
}

