/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.common;

import org.apache.iceberg.Schema;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.UnboundTerm;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.Transforms;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.IcebergPartitionExpr;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.IcebergColumn;
import org.apache.impala.common.IcebergPredicateConverter;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.thrift.TIcebergPartitionTransformType;

public class IcebergPartitionPredicateConverter
extends IcebergPredicateConverter {
    public IcebergPartitionPredicateConverter(Schema schema, Analyzer analyzer) {
        super(schema, analyzer);
    }

    @Override
    protected IcebergPredicateConverter.Term getTerm(Expr expr) throws ImpalaRuntimeException {
        if (!(expr instanceof IcebergPartitionExpr)) {
            throw new ImpalaRuntimeException("Unsupported expression type: " + expr);
        }
        IcebergPartitionExpr partitionExpr = (IcebergPartitionExpr)expr;
        Column column = this.getColumnFromSlotRef(partitionExpr.getSlotRef());
        if (!(column instanceof IcebergColumn)) {
            throw new ImpalaRuntimeException(String.format("Invalid column type %s for column: %s", column.getType(), column));
        }
        IcebergColumn icebergColumn = (IcebergColumn)column;
        if (partitionExpr.getTransform().getTransformType().equals((Object)TIcebergPartitionTransformType.IDENTITY)) {
            return new IcebergPredicateConverter.Term((UnboundTerm<Object>)Expressions.ref((String)column.getName()), icebergColumn);
        }
        return new IcebergPredicateConverter.Term((UnboundTerm<Object>)Expressions.transform((String)column.getName(), (Transform)Transforms.fromString((String)partitionExpr.getTransform().toSql())), icebergColumn);
    }
}

