/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.monitor;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.lang3.StringUtils;
import org.apache.impala.catalog.monitor.CatalogDdlCounter;
import org.apache.impala.catalog.monitor.CatalogFinalizeDmlCounter;
import org.apache.impala.catalog.monitor.CatalogResetMetadataCounter;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.thrift.TCatalogOpRecord;
import org.apache.impala.thrift.TCatalogServiceRequestHeader;
import org.apache.impala.thrift.TDdlExecRequest;
import org.apache.impala.thrift.TDdlQueryOptions;
import org.apache.impala.thrift.TDdlType;
import org.apache.impala.thrift.TGetOperationUsageResponse;
import org.apache.impala.thrift.TOperationUsageCounter;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.thrift.TResetMetadataRequest;
import org.apache.impala.thrift.TTableName;
import org.apache.impala.thrift.TUniqueId;
import org.apache.impala.thrift.TUpdateCatalogRequest;
import org.apache.impala.util.TUniqueIdUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CatalogOperationTracker {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogOperationTracker.class);
    public static final CatalogOperationTracker INSTANCE = new CatalogOperationTracker();
    private static final TQueryOptions DEFAULT_QUERY_OPTIONS = new TQueryOptions();
    CatalogDdlCounter catalogDdlCounter_;
    CatalogResetMetadataCounter catalogResetMetadataCounter_;
    CatalogFinalizeDmlCounter catalogFinalizeDmlCounter_;
    private final Map<RpcKey, TCatalogOpRecord> inFlightOperations_ = new ConcurrentHashMap<RpcKey, TCatalogOpRecord>();
    private final Queue<TCatalogOpRecord> finishedOperations_ = new ConcurrentLinkedQueue<TCatalogOpRecord>();
    private final int catalogOperationLogSize_;

    private CatalogOperationTracker() {
        this.catalogDdlCounter_ = new CatalogDdlCounter();
        this.catalogResetMetadataCounter_ = new CatalogResetMetadataCounter();
        this.catalogFinalizeDmlCounter_ = new CatalogFinalizeDmlCounter();
        this.catalogOperationLogSize_ = BackendConfig.INSTANCE.catalogOperationLogSize();
        Preconditions.checkState((this.catalogOperationLogSize_ >= 0 ? 1 : 0) != 0);
    }

    private void addRecord(TCatalogServiceRequestHeader header, String catalogOpName, Optional<TTableName> tTableName, String details) {
        String user = "unknown";
        String clientIp = "unknown";
        String coordinator = "unknown";
        TUniqueId queryId = header.getQuery_id();
        if (header.isSetRequesting_user()) {
            user = header.getRequesting_user();
        }
        if (header.isSetClient_ip()) {
            clientIp = header.getClient_ip();
        }
        if (header.isSetCoordinator_hostname()) {
            coordinator = header.getCoordinator_hostname();
        }
        if (queryId != null) {
            TCatalogOpRecord record = new TCatalogOpRecord(Thread.currentThread().getId(), queryId, clientIp, coordinator, catalogOpName, this.catalogDdlCounter_.getTableName(tTableName), user, System.currentTimeMillis(), -1L, "STARTED", details);
            this.inFlightOperations_.put(new RpcKey(queryId), record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void archiveRecord(TUniqueId queryId, String errorMsg) {
        if (queryId == null) {
            return;
        }
        RpcKey key = new RpcKey(queryId);
        TCatalogOpRecord record = this.inFlightOperations_.remove(key);
        if (record == null) {
            LOG.error("Null record for query {}", (Object)TUniqueIdUtil.PrintId(queryId));
            return;
        }
        if (this.catalogOperationLogSize_ == 0) {
            return;
        }
        record.setFinish_time_ms(System.currentTimeMillis());
        if (errorMsg != null) {
            record.setStatus("FAILED");
            record.setDetails(record.getDetails() + ", error=" + errorMsg);
        } else {
            record.setStatus("FINISHED");
        }
        Queue<TCatalogOpRecord> queue = this.finishedOperations_;
        synchronized (queue) {
            if (this.finishedOperations_.size() >= this.catalogOperationLogSize_) {
                this.finishedOperations_.poll();
            }
            this.finishedOperations_.add(record);
        }
    }

    private String getDdlType(TDdlExecRequest ddlRequest) {
        if (ddlRequest.ddl_type == TDdlType.ALTER_TABLE) {
            return "ALTER_TABLE_" + (Object)((Object)ddlRequest.getAlter_table_params().getAlter_type());
        }
        return ddlRequest.ddl_type.name();
    }

    public void increment(TDdlExecRequest ddlRequest, Optional<TTableName> tTableName) {
        if (ddlRequest.isSetHeader()) {
            TDdlQueryOptions options = ddlRequest.query_options;
            ArrayList<String> nonDefaultOptions = new ArrayList<String>();
            if (options.sync_ddl) {
                nonDefaultOptions.add("sync_ddl=true");
            }
            if (StringUtils.isNotEmpty((CharSequence)options.debug_action)) {
                nonDefaultOptions.add("debug_action=" + options.debug_action);
            }
            if (options.lock_max_wait_time_s != CatalogOperationTracker.DEFAULT_QUERY_OPTIONS.lock_max_wait_time_s) {
                nonDefaultOptions.add("lock_max_wait_time_s=" + options.lock_max_wait_time_s);
            }
            if (options.kudu_table_reserve_seconds != CatalogOperationTracker.DEFAULT_QUERY_OPTIONS.kudu_table_reserve_seconds) {
                nonDefaultOptions.add("kudu_table_reserve_seconds=" + options.kudu_table_reserve_seconds);
            }
            this.addRecord(ddlRequest.getHeader(), this.getDdlType(ddlRequest), tTableName, StringUtils.join(nonDefaultOptions, (String)", "));
        }
        this.catalogDdlCounter_.incrementOperation(ddlRequest.ddl_type, tTableName);
    }

    public void decrement(TDdlType tDdlType, TUniqueId queryId, Optional<TTableName> tTableName, String errorMsg) {
        this.archiveRecord(queryId, errorMsg);
        this.catalogDdlCounter_.decrementOperation(tDdlType, tTableName);
    }

    public void increment(TResetMetadataRequest req) {
        Optional<TTableName> tTableName;
        Optional<TTableName> optional = tTableName = req.table_name != null ? Optional.of(req.table_name) : Optional.empty();
        if (req.isSetHeader()) {
            ArrayList<String> details = new ArrayList<String>();
            if (req.sync_ddl) {
                details.add("sync_ddl=true");
            }
            if (req.header.want_minimal_response) {
                details.add("want_minimal_response=true");
            }
            if (req.refresh_updated_hms_partitions) {
                details.add("refresh_updated_hms_partitions=true");
            }
            if (StringUtils.isNotEmpty((CharSequence)req.debug_action)) {
                details.add("debug_action=" + req.debug_action);
            }
            this.addRecord(req.getHeader(), CatalogResetMetadataCounter.getResetMetadataType(req, tTableName).name(), tTableName, StringUtils.join(details, (String)", "));
        }
        this.catalogResetMetadataCounter_.incrementOperation(req);
    }

    public void decrement(TResetMetadataRequest req, String errorMsg) {
        if (req.isSetHeader()) {
            this.archiveRecord(req.getHeader().getQuery_id(), errorMsg);
        }
        this.catalogResetMetadataCounter_.decrementOperation(req);
    }

    public void increment(TUpdateCatalogRequest req) {
        Optional<TTableName> tTableName = Optional.of(new TTableName(req.db_name, req.target_table));
        if (req.isSetHeader()) {
            ArrayList<String> details = new ArrayList<String>();
            details.add("#partitions=" + req.getUpdated_partitionsSize());
            if (req.sync_ddl) {
                details.add("sync_ddl=true");
            }
            if (req.is_overwrite) {
                details.add("is_overwrite=true");
            }
            if (req.transaction_id > 0L) {
                details.add("transaction_id=" + req.transaction_id);
            }
            if (req.write_id > 0L) {
                details.add("write_id=" + req.write_id);
            }
            if (req.isSetIceberg_operation()) {
                details.add("iceberg_operation=" + (Object)((Object)req.iceberg_operation.operation));
            }
            if (StringUtils.isNotEmpty((CharSequence)req.debug_action)) {
                details.add("debug_action=" + req.debug_action);
            }
            this.addRecord(req.getHeader(), CatalogFinalizeDmlCounter.getDmlType(req.getHeader().redacted_sql_stmt).name(), tTableName, StringUtils.join(details, (String)", "));
        }
        this.catalogFinalizeDmlCounter_.incrementOperation(req);
    }

    public void decrement(TUpdateCatalogRequest req, String errorMsg) {
        if (req.isSetHeader()) {
            this.archiveRecord(req.getHeader().getQuery_id(), errorMsg);
        }
        this.catalogFinalizeDmlCounter_.decrementOperation(req);
    }

    public TGetOperationUsageResponse getOperationMetrics() {
        ArrayList<TOperationUsageCounter> merged = new ArrayList<TOperationUsageCounter>();
        merged.addAll(this.catalogDdlCounter_.getOperationUsage());
        merged.addAll(this.catalogResetMetadataCounter_.getOperationUsage());
        merged.addAll(this.catalogFinalizeDmlCounter_.getOperationUsage());
        TGetOperationUsageResponse res = new TGetOperationUsageResponse(merged);
        for (TCatalogOpRecord record : this.inFlightOperations_.values()) {
            res.addToIn_flight_catalog_operations(record);
        }
        ArrayList<TCatalogOpRecord> records = new ArrayList<TCatalogOpRecord>(this.finishedOperations_);
        Collections.reverse(records);
        res.setFinished_catalog_operations(records);
        return res;
    }

    private static class RpcKey {
        private final TUniqueId queryId_;
        private final long threadId_;

        public RpcKey(TUniqueId queryId) {
            this.queryId_ = queryId;
            this.threadId_ = Thread.currentThread().getId();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RpcKey)) {
                return false;
            }
            RpcKey key = (RpcKey)o;
            return this.queryId_.equals(key.queryId_) && this.threadId_ == key.threadId_;
        }

        public int hashCode() {
            return this.queryId_.hashCode() * 31 + Long.hashCode(this.threadId_);
        }
    }
}

