/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.monitor;

import java.util.HashMap;
import java.util.Optional;
import org.apache.impala.catalog.monitor.CatalogOperationCounter;
import org.apache.impala.thrift.TTableName;
import org.apache.impala.thrift.TUpdateCatalogRequest;

public class CatalogFinalizeDmlCounter
extends CatalogOperationCounter {
    public CatalogFinalizeDmlCounter() {
        this.counters_ = new HashMap();
        for (FinalizeDmlType dmlType : FinalizeDmlType.values()) {
            this.counters_.put(dmlType.toString(), new HashMap());
        }
    }

    public void incrementOperation(TUpdateCatalogRequest req) {
        Optional<TTableName> tTableName = Optional.of(new TTableName(req.db_name, req.target_table));
        FinalizeDmlType dmlType = CatalogFinalizeDmlCounter.getDmlType(req.getHeader().redacted_sql_stmt);
        this.incrementCounter(dmlType.toString(), this.getTableName(tTableName));
    }

    public void decrementOperation(TUpdateCatalogRequest req) {
        Optional<TTableName> tTableName = Optional.of(new TTableName(req.db_name, req.target_table));
        FinalizeDmlType dmlType = CatalogFinalizeDmlCounter.getDmlType(req.getHeader().redacted_sql_stmt);
        this.decrementCounter(dmlType.toString(), this.getTableName(tTableName));
    }

    public static FinalizeDmlType getDmlType(String sql_stmt) {
        if ((sql_stmt = sql_stmt.toUpperCase()).contains("INSERT INTO")) {
            return FinalizeDmlType.FINALIZE_INSERT_INTO;
        }
        if (sql_stmt.contains("CREATE TABLE")) {
            return FinalizeDmlType.FINALIZE_CREATE_TABLE_AS_SELECT;
        }
        if (sql_stmt.contains("UPDATE")) {
            return FinalizeDmlType.FINALIZE_UPDATE;
        }
        return FinalizeDmlType.FINALIZE_DML;
    }

    static enum FinalizeDmlType {
        FINALIZE_INSERT_INTO,
        FINALIZE_UPDATE,
        FINALIZE_CREATE_TABLE_AS_SELECT,
        FINALIZE_DML;

    }
}

