/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.local;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.iceberg.Table;
import org.apache.impala.authorization.AuthorizationPolicy;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.DataSource;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.HdfsCachePool;
import org.apache.impala.catalog.HdfsPartition;
import org.apache.impala.catalog.HdfsPartitionLocationCompressor;
import org.apache.impala.catalog.HdfsStorageDescriptor;
import org.apache.impala.catalog.SqlConstraints;
import org.apache.impala.catalog.VirtualColumn;
import org.apache.impala.catalog.local.LocalIcebergTable;
import org.apache.impala.common.Pair;
import org.apache.impala.thrift.TBriefTableMeta;
import org.apache.impala.thrift.TNetworkAddress;
import org.apache.impala.thrift.TPartialTableInfo;
import org.apache.impala.thrift.TValidWriteIdList;
import org.apache.impala.util.ListMap;
import org.apache.thrift.TException;

public interface MetaProvider {
    public AuthorizationPolicy getAuthPolicy();

    public boolean isReady();

    public void waitForIsReady(long var1);

    public ImmutableList<String> loadDbList() throws TException;

    public Database loadDb(String var1) throws TException;

    public ImmutableCollection<TBriefTableMeta> loadTableList(String var1) throws MetaException, UnknownDBException, TException;

    public Pair<org.apache.hadoop.hive.metastore.api.Table, TableMetaRef> loadTable(String var1, String var2) throws NoSuchObjectException, MetaException, TException;

    public Pair<org.apache.hadoop.hive.metastore.api.Table, TableMetaRef> getTableIfPresent(String var1, String var2);

    public String loadNullPartitionKeyValue() throws MetaException, TException;

    public List<PartitionRef> loadPartitionList(TableMetaRef var1) throws MetaException, TException;

    public SqlConstraints loadConstraints(TableMetaRef var1, org.apache.hadoop.hive.metastore.api.Table var2) throws MetaException, TException;

    public List<String> loadFunctionNames(String var1) throws TException;

    public ImmutableList<Function> loadFunction(String var1, String var2) throws TException;

    public ImmutableList<DataSource> loadDataSources() throws TException;

    public DataSource loadDataSource(String var1) throws TException;

    public Map<String, PartitionMetadata> loadPartitionsByRefs(TableMetaRef var1, List<String> var2, ListMap<TNetworkAddress> var3, List<PartitionRef> var4) throws MetaException, TException, CatalogException;

    public List<ColumnStatisticsObj> loadTableColumnStatistics(TableMetaRef var1, List<String> var2) throws TException;

    public TPartialTableInfo loadIcebergTable(TableMetaRef var1) throws TException;

    public Table loadIcebergApiTable(TableMetaRef var1, LocalIcebergTable.TableParams var2, org.apache.hadoop.hive.metastore.api.Table var3) throws TException;

    public TValidWriteIdList getValidWriteIdList(TableMetaRef var1);

    public Iterable<HdfsCachePool> getHdfsCachePools();

    public static interface PartitionMetadata {
        public Map<String, String> getHmsParameters();

        public long getWriteId();

        public HdfsStorageDescriptor getInputFormatDescriptor();

        public HdfsPartitionLocationCompressor.Location getLocation();

        public ImmutableList<HdfsPartition.FileDescriptor> getFileDescriptors();

        public ImmutableList<HdfsPartition.FileDescriptor> getInsertFileDescriptors();

        public ImmutableList<HdfsPartition.FileDescriptor> getDeleteFileDescriptors();

        public byte[] getPartitionStats();

        public boolean hasIncrementalStats();

        public boolean isMarkedCached();

        public long getLastCompactionId();
    }

    @Immutable
    public static interface PartitionRef {
        public String getName();
    }

    public static interface TableMetaRef {
        public boolean isMarkedCached();

        public List<String> getPartitionPrefixes();

        public boolean isPartitioned();

        public boolean isTransactional();

        public List<VirtualColumn> getVirtualColumns();
    }
}

