/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.local;

import com.google.common.base.Preconditions;
import java.util.Set;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.impala.catalog.FeCatalogUtils;
import org.apache.impala.catalog.FeSystemTable;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.local.LocalDb;
import org.apache.impala.catalog.local.LocalTable;
import org.apache.impala.catalog.local.MetaProvider;
import org.apache.impala.common.InternalException;
import org.apache.impala.service.FeSupport;
import org.apache.impala.thrift.TColumn;
import org.apache.impala.thrift.TResultSet;
import org.apache.impala.thrift.TResultSetMetadata;
import org.apache.impala.thrift.TSystemTable;
import org.apache.impala.thrift.TSystemTableName;
import org.apache.impala.thrift.TTableDescriptor;
import org.apache.impala.thrift.TTableType;
import org.apache.impala.util.TResultRowBuilder;

public class LocalSystemTable
extends LocalTable
implements FeSystemTable {
    public static LocalSystemTable load(LocalDb db, Table msTbl, MetaProvider.TableMetaRef ref) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)msTbl);
        return new LocalSystemTable(db, msTbl, ref);
    }

    private LocalSystemTable(LocalDb db, Table msTbl, MetaProvider.TableMetaRef ref) {
        super(db, msTbl, ref);
    }

    @Override
    public TSystemTableName getSystemTableName() {
        return TSystemTableName.valueOf(this.getName().toUpperCase());
    }

    @Override
    public long getNumRows() {
        try {
            return FeSupport.NumLiveQueries() * (long)FeSupport.GetCoordinators().getAddressesSize();
        }
        catch (InternalException e) {
            return super.getNumRows();
        }
    }

    @Override
    public TResultSet getTableStats() {
        TResultSet result = new TResultSet();
        TResultSetMetadata resultSchema = new TResultSetMetadata();
        resultSchema.addToColumns(new TColumn("#Rows", Type.BIGINT.toThrift()));
        result.setSchema(resultSchema);
        TResultRowBuilder rowBuilder = new TResultRowBuilder();
        rowBuilder.add(this.getNumRows());
        result.addToRows(rowBuilder.get());
        return result;
    }

    @Override
    public TTableDescriptor toThriftDescriptor(int tableId, Set<Long> referencedPartitions) {
        TTableDescriptor tableDescriptor = new TTableDescriptor(tableId, TTableType.SYSTEM_TABLE, FeCatalogUtils.getTColumnDescriptors(this), this.getNumClusteringCols(), this.getName(), this.getDb().getName());
        tableDescriptor.setSystemTable(this.getTSystemTable());
        return tableDescriptor;
    }

    private TSystemTable getTSystemTable() {
        return new TSystemTable(this.getSystemTableName());
    }
}

