/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.local;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.iceberg.Table;
import org.apache.impala.analysis.IcebergPartitionSpec;
import org.apache.impala.catalog.CatalogObject;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.FeCatalogUtils;
import org.apache.impala.catalog.FeFsPartition;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.IcebergContentFileStore;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.catalog.local.InconsistentMetadataFetchException;
import org.apache.impala.catalog.local.LocalCatalogException;
import org.apache.impala.catalog.local.LocalDb;
import org.apache.impala.catalog.local.LocalFsTable;
import org.apache.impala.catalog.local.LocalTable;
import org.apache.impala.catalog.local.MetaProvider;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.thrift.TCompressionCodec;
import org.apache.impala.thrift.THdfsPartition;
import org.apache.impala.thrift.THdfsTable;
import org.apache.impala.thrift.TIcebergCatalog;
import org.apache.impala.thrift.TIcebergFileFormat;
import org.apache.impala.thrift.TIcebergPartitionStats;
import org.apache.impala.thrift.TPartialTableInfo;
import org.apache.impala.thrift.TTableDescriptor;
import org.apache.impala.thrift.TTableType;
import org.apache.impala.util.IcebergSchemaConverter;
import org.apache.impala.util.IcebergUtil;
import org.apache.log4j.Logger;

public class LocalIcebergTable
extends LocalTable
implements FeIcebergTable {
    private static final Logger LOG = Logger.getLogger(LocalIcebergTable.class);
    private TableParams tableParams_;
    private TIcebergFileFormat icebergFileFormat_;
    private TCompressionCodec icebergParquetCompressionCodec_;
    private long icebergParquetRowGroupSize_;
    private long icebergParquetPlainPageSize_;
    private long icebergParquetDictPageSize_;
    private List<IcebergPartitionSpec> partitionSpecs_;
    private int defaultPartitionSpecId_;
    private IcebergContentFileStore fileStore_;
    private LocalFsTable localFsTable_;
    long catalogSnapshotId_;
    private Table icebergApiTable_;
    private Map<String, TIcebergPartitionStats> partitionStats_;

    static LocalTable loadIcebergTableViaMetaProvider(LocalDb db, org.apache.hadoop.hive.metastore.api.Table msTable, MetaProvider.TableMetaRef ref) throws TableLoadingException {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)msTable);
        try {
            FeIcebergTable.setIcebergStorageDescriptor(msTable);
            TableParams tableParams = new TableParams(msTable);
            TPartialTableInfo tableInfo = db.getCatalog().getMetaProvider().loadIcebergTable(ref);
            LocalFsTable fsTable = LocalFsTable.load(db, msTable, ref);
            LocalIcebergTable.warmupMetaProviderCache(db, msTable, ref, fsTable);
            Table icebergApiTable = db.getCatalog().getMetaProvider().loadIcebergApiTable(ref, tableParams, msTable);
            List<Column> iceColumns = IcebergSchemaConverter.convertToImpalaSchema(icebergApiTable.schema());
            LocalIcebergTable.validateColumns(iceColumns, msTable.getSd().getCols());
            LocalTable.ColumnMap colMap = new LocalTable.ColumnMap(iceColumns, 0, db.getName() + "." + msTable.getTableName(), false);
            return new LocalIcebergTable(db, msTable, ref, fsTable, colMap, tableInfo, tableParams, icebergApiTable);
        }
        catch (InconsistentMetadataFetchException e) {
            throw e;
        }
        catch (Exception e) {
            String fullTableName = msTable.getDbName() + "." + msTable.getTableName();
            throw new TableLoadingException(String.format("Error opening Iceberg table '%s'", fullTableName), e);
        }
    }

    private static void warmupMetaProviderCache(LocalDb db, org.apache.hadoop.hive.metastore.api.Table msTable, MetaProvider.TableMetaRef ref, LocalFsTable fsTable) throws Exception {
        db.getCatalog().getMetaProvider().loadTableColumnStatistics(ref, LocalIcebergTable.getHmsColumnNames(msTable));
        FeCatalogUtils.loadAllPartitions(fsTable);
    }

    private static List<String> getHmsColumnNames(org.apache.hadoop.hive.metastore.api.Table msTable) {
        ArrayList<String> ret = new ArrayList<String>();
        for (FieldSchema fs : msTable.getSd().getCols()) {
            ret.add(fs.getName());
        }
        return ret;
    }

    private LocalIcebergTable(LocalDb db, org.apache.hadoop.hive.metastore.api.Table msTable, MetaProvider.TableMetaRef ref, LocalFsTable fsTable, LocalTable.ColumnMap cmap, TPartialTableInfo tableInfo, TableParams tableParams, Table icebergApiTable) throws ImpalaRuntimeException {
        super(db, msTable, ref, cmap);
        Preconditions.checkNotNull((Object)tableInfo);
        this.localFsTable_ = fsTable;
        this.tableParams_ = tableParams;
        this.fileStore_ = IcebergContentFileStore.fromThrift(tableInfo.getIceberg_table().getContent_files(), tableInfo.getNetwork_addresses(), this.getHostIndex());
        if (this.fileStore_.hasAvro()) {
            this.localFsTable_.setAvroSchema(msTable);
        }
        this.icebergApiTable_ = icebergApiTable;
        this.catalogSnapshotId_ = tableInfo.getIceberg_table().getCatalog_snapshot_id();
        this.partitionSpecs_ = FeIcebergTable.Utils.loadPartitionSpecByIceberg(this);
        this.defaultPartitionSpecId_ = tableInfo.getIceberg_table().getDefault_partition_spec_id();
        this.icebergFileFormat_ = IcebergUtil.getIcebergFileFormat(msTable);
        this.icebergParquetCompressionCodec_ = FeIcebergTable.Utils.getIcebergParquetCompressionCodec(msTable);
        this.icebergParquetRowGroupSize_ = FeIcebergTable.Utils.getIcebergParquetRowGroupSize(msTable);
        this.icebergParquetPlainPageSize_ = FeIcebergTable.Utils.getIcebergParquetPlainPageSize(msTable);
        this.icebergParquetDictPageSize_ = FeIcebergTable.Utils.getIcebergParquetDictPageSize(msTable);
        this.partitionStats_ = tableInfo.getIceberg_table().getPartition_stats();
        this.setIcebergTableStats();
        this.addVirtualColumns(ref.getVirtualColumns());
    }

    static void validateColumns(List<Column> impalaCols, List<FieldSchema> hmsCols) {
        Preconditions.checkState((impalaCols.size() == hmsCols.size() ? 1 : 0) != 0);
        for (int i = 0; i < impalaCols.size(); ++i) {
            Preconditions.checkState((boolean)impalaCols.get(i).getName().equalsIgnoreCase(hmsCols.get(i).getName()));
        }
    }

    @Override
    public TIcebergFileFormat getIcebergFileFormat() {
        return this.icebergFileFormat_;
    }

    @Override
    public TCompressionCodec getIcebergParquetCompressionCodec() {
        return this.icebergParquetCompressionCodec_;
    }

    @Override
    public long getIcebergParquetRowGroupSize() {
        return this.icebergParquetRowGroupSize_;
    }

    @Override
    public long getIcebergParquetPlainPageSize() {
        return this.icebergParquetPlainPageSize_;
    }

    @Override
    public long getIcebergParquetDictPageSize() {
        return this.icebergParquetDictPageSize_;
    }

    @Override
    public String getIcebergTableLocation() {
        return this.tableParams_.icebergTableLocation_;
    }

    @Override
    public TIcebergCatalog getIcebergCatalog() {
        return this.tableParams_.icebergCatalog_;
    }

    @Override
    public String getIcebergCatalogLocation() {
        return this.tableParams_.icebergCatalogLocation_;
    }

    @Override
    public FeFsTable getFeFsTable() {
        return this.localFsTable_;
    }

    @Override
    public List<IcebergPartitionSpec> getPartitionSpecs() {
        return this.partitionSpecs_;
    }

    @Override
    public int getDefaultPartitionSpecId() {
        return this.defaultPartitionSpecId_;
    }

    @Override
    public IcebergPartitionSpec getDefaultPartitionSpec() {
        return FeIcebergTable.Utils.getDefaultPartitionSpec(this);
    }

    @Override
    public Table getIcebergApiTable() {
        return this.icebergApiTable_;
    }

    @Override
    public long snapshotId() {
        return this.catalogSnapshotId_;
    }

    @Override
    public Map<String, TIcebergPartitionStats> getIcebergPartitionStats() {
        return this.partitionStats_;
    }

    @Override
    public TTableDescriptor toThriftDescriptor(int tableId, Set<Long> referencedPartitions) {
        TTableDescriptor desc = new TTableDescriptor(tableId, TTableType.ICEBERG_TABLE, FeCatalogUtils.getTColumnDescriptors(this), this.getNumClusteringCols(), this.name_, this.db_.getName());
        desc.setIcebergTable(FeIcebergTable.Utils.getTIcebergTable(this, CatalogObject.ThriftObjectType.DESCRIPTOR_ONLY));
        desc.setHdfsTable(this.transformToTHdfsTable(false, CatalogObject.ThriftObjectType.DESCRIPTOR_ONLY));
        return desc;
    }

    @Override
    public THdfsTable transformToTHdfsTable(boolean updatePartitionFlag, CatalogObject.ThriftObjectType type) {
        HashMap<Long, THdfsPartition> idToPartition = new HashMap<Long, THdfsPartition>();
        Collection<? extends FeFsPartition> partitions = FeCatalogUtils.loadAllPartitions(this.localFsTable_);
        Preconditions.checkState((partitions.size() == 1 ? 1 : 0) != 0);
        FeFsPartition partition = (FeFsPartition)partitions.toArray()[0];
        idToPartition.put(partition.getId(), FeCatalogUtils.fsPartitionToThrift(partition, CatalogObject.ThriftObjectType.DESCRIPTOR_ONLY));
        THdfsPartition tPrototypePartition = FeCatalogUtils.fsPartitionToThrift(this.localFsTable_.createPrototypePartition(), CatalogObject.ThriftObjectType.DESCRIPTOR_ONLY);
        THdfsTable hdfsTable = new THdfsTable(this.localFsTable_.getHdfsBaseDir(), this.getColumnNames(), this.localFsTable_.getNullPartitionKeyValue(), "\\N", idToPartition, tPrototypePartition);
        hdfsTable.setAvroSchema(this.localFsTable_.getAvroSchema());
        FeIcebergTable.Utils.updateIcebergPartitionFileFormat(this, hdfsTable);
        hdfsTable.setPartition_prefixes(this.localFsTable_.getPartitionPrefixes());
        return hdfsTable;
    }

    @Override
    public IcebergContentFileStore getContentFileStore() {
        return this.fileStore_;
    }

    @Immutable
    public static class TableParams {
        private final String icebergTableLocation_;
        private final TIcebergCatalog icebergCatalog_;
        private final String icebergCatalogLocation_;

        TableParams(org.apache.hadoop.hive.metastore.api.Table msTable) {
            String fullTableName = msTable.getDbName() + "." + msTable.getTableName();
            if (!msTable.getSd().isSetLocation()) {
                throw new LocalCatalogException("Cannot find iceberg table location for table " + fullTableName);
            }
            this.icebergTableLocation_ = msTable.getSd().getLocation();
            this.icebergCatalog_ = IcebergUtil.getTIcebergCatalog(msTable);
            this.icebergCatalogLocation_ = this.icebergCatalog_ == TIcebergCatalog.HADOOP_CATALOG ? FeIcebergTable.Utils.getIcebergCatalogLocation(msTable) : this.icebergTableLocation_;
        }

        public String getIcebergTableLocation() {
            return this.icebergTableLocation_;
        }

        public TIcebergCatalog getIcebergCatalog() {
            return this.icebergCatalog_;
        }

        public String getIcebergCatalogLocation() {
            return this.icebergCatalogLocation_;
        }
    }
}

