/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.local;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.fs.Path;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.catalog.FeCatalogUtils;
import org.apache.impala.catalog.FeFsPartition;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.HdfsFileFormat;
import org.apache.impala.catalog.HdfsPartition;
import org.apache.impala.catalog.HdfsPartitionLocationCompressor;
import org.apache.impala.catalog.HdfsStorageDescriptor;
import org.apache.impala.catalog.PartitionStatsUtil;
import org.apache.impala.catalog.local.LocalFsTable;
import org.apache.impala.catalog.local.LocalPartitionSpec;
import org.apache.impala.common.FileSystemUtil;
import org.apache.impala.thrift.TAccessLevel;
import org.apache.impala.thrift.THdfsPartitionLocation;
import org.apache.impala.thrift.TNetworkAddress;
import org.apache.impala.thrift.TPartitionStats;
import org.apache.impala.util.IcebergUtil;
import org.apache.impala.util.ListMap;

public class LocalFsPartition
implements FeFsPartition {
    private final LocalFsTable table_;
    private final LocalPartitionSpec spec_;
    private final Map<String, String> hmsParameters_;
    private final long writeId_;
    private final HdfsStorageDescriptor hdfsStorageDescriptor_;
    private final HdfsPartitionLocationCompressor.Location location_;
    @Nullable
    private ImmutableList<HdfsPartition.FileDescriptor> fileDescriptors_;
    @Nullable
    private ImmutableList<HdfsPartition.FileDescriptor> insertFileDescriptors_;
    @Nullable
    private ImmutableList<HdfsPartition.FileDescriptor> deleteFileDescriptors_;
    @Nullable
    private final byte[] partitionStats_;
    private final boolean hasIncrementalStats_;
    private final boolean isMarkedCached_;

    public LocalFsPartition(LocalFsTable table, LocalPartitionSpec spec, Map<String, String> hmsParameters, long writeId, HdfsStorageDescriptor hdfsStorageDescriptor, ImmutableList<HdfsPartition.FileDescriptor> fileDescriptors, ImmutableList<HdfsPartition.FileDescriptor> insertFileDescriptors, ImmutableList<HdfsPartition.FileDescriptor> deleteFileDescriptors, byte[] partitionStats, boolean hasIncrementalStats, boolean isMarkedCached, HdfsPartitionLocationCompressor.Location location) {
        this.table_ = (LocalFsTable)Preconditions.checkNotNull((Object)table);
        this.spec_ = (LocalPartitionSpec)Preconditions.checkNotNull((Object)spec);
        this.hmsParameters_ = hmsParameters;
        this.writeId_ = writeId;
        this.hdfsStorageDescriptor_ = hdfsStorageDescriptor;
        this.location_ = location;
        this.fileDescriptors_ = fileDescriptors;
        this.insertFileDescriptors_ = insertFileDescriptors;
        this.deleteFileDescriptors_ = deleteFileDescriptors;
        this.partitionStats_ = partitionStats;
        this.hasIncrementalStats_ = hasIncrementalStats;
        this.isMarkedCached_ = isMarkedCached;
    }

    @Override
    public String getPartitionName() {
        return FeCatalogUtils.getPartitionName(this);
    }

    @Override
    public long getId() {
        return this.spec_.getId();
    }

    @Override
    public FeFsTable getTable() {
        return this.table_;
    }

    @Override
    public ListMap<TNetworkAddress> getHostIndex() {
        return this.table_.getHostIndex();
    }

    @Override
    public FileSystemUtil.FsType getFsType() {
        Path location = this.getLocationPath();
        Preconditions.checkNotNull((Object)location.toUri().getScheme(), (Object)("Cannot get scheme from path " + location));
        return FileSystemUtil.FsType.getFsType(location.toUri().getScheme());
    }

    @Override
    public List<HdfsPartition.FileDescriptor> getFileDescriptors() {
        if (!this.fileDescriptors_.isEmpty()) {
            return this.fileDescriptors_;
        }
        ArrayList<HdfsPartition.FileDescriptor> ret = new ArrayList<HdfsPartition.FileDescriptor>();
        ret.addAll((Collection<HdfsPartition.FileDescriptor>)this.insertFileDescriptors_);
        ret.addAll((Collection<HdfsPartition.FileDescriptor>)this.deleteFileDescriptors_);
        return ret;
    }

    @Override
    public List<HdfsPartition.FileDescriptor> getInsertFileDescriptors() {
        return this.insertFileDescriptors_;
    }

    @Override
    public List<HdfsPartition.FileDescriptor> getDeleteFileDescriptors() {
        return this.deleteFileDescriptors_;
    }

    @Override
    public boolean hasFileDescriptors() {
        return !this.fileDescriptors_.isEmpty() || !this.insertFileDescriptors_.isEmpty() || !this.deleteFileDescriptors_.isEmpty();
    }

    @Override
    public int getNumFileDescriptors() {
        return this.fileDescriptors_.size() + this.insertFileDescriptors_.size() + this.deleteFileDescriptors_.size();
    }

    @Override
    public String getLocation() {
        return this.location_ != null ? this.location_.toString() : null;
    }

    @Override
    public THdfsPartitionLocation getLocationAsThrift() {
        return this.location_ != null ? this.location_.toThrift() : null;
    }

    @Override
    public Path getLocationPath() {
        Preconditions.checkNotNull((Object)this.location_, (Object)"LocalFsPartition location is null");
        return new Path(this.getLocation());
    }

    @Override
    public TAccessLevel getAccessLevel() {
        return TAccessLevel.READ_WRITE;
    }

    @Override
    public boolean isCacheable() {
        return FileSystemUtil.isPathCacheable(this.getLocationPath());
    }

    @Override
    public boolean isMarkedCached() {
        return this.isMarkedCached_;
    }

    @Override
    public HdfsStorageDescriptor getInputFormatDescriptor() {
        return this.hdfsStorageDescriptor_;
    }

    @Override
    public HdfsFileFormat getFileFormat() {
        HdfsFileFormat format = this.getInputFormatDescriptor().getFileFormat();
        if (format == HdfsFileFormat.ICEBERG) {
            return IcebergUtil.toHdfsFileFormat(IcebergUtil.getIcebergFileFormat(this.table_.getMetaStoreTable()));
        }
        return format;
    }

    @Override
    public TPartitionStats getPartitionStats() {
        return PartitionStatsUtil.getPartStatsOrWarn(this);
    }

    @Override
    public boolean hasIncrementalStats() {
        return this.hasIncrementalStats_;
    }

    @Override
    public byte[] getPartitionStatsCompressed() {
        return this.partitionStats_;
    }

    @Override
    public long getSize() {
        long size = 0L;
        for (HdfsPartition.FileDescriptor fd : this.getFileDescriptors()) {
            size += fd.getFileLength();
        }
        return size;
    }

    @Override
    public long getNumRows() {
        long rowCount = FeCatalogUtils.getRowCount(this.hmsParameters_);
        if (this.table_.getDebugMetadataScale() > 1.0 && rowCount > 0L) {
            rowCount = (long)((double)rowCount * this.table_.getDebugMetadataScale());
        }
        return rowCount;
    }

    @Override
    public String getConjunctSql() {
        return FeCatalogUtils.getConjunctSqlForPartition(this);
    }

    @Override
    public List<String> getPartitionValuesAsStrings(boolean mapNullsToHiveKey) {
        return FeCatalogUtils.getPartitionValuesAsStrings(this, mapNullsToHiveKey);
    }

    @Override
    public List<LiteralExpr> getPartitionValues() {
        return this.spec_.getPartitionValues();
    }

    @Override
    public LiteralExpr getPartitionValue(int pos) {
        return this.spec_.getPartitionValues().get(pos);
    }

    @Override
    public Map<String, String> getParameters() {
        return this.hmsParameters_;
    }

    @Override
    public long getWriteId() {
        return this.writeId_;
    }

    @Override
    public LocalFsPartition genInsertDeltaPartition() {
        ImmutableList<HdfsPartition.FileDescriptor> fds = this.insertFileDescriptors_.isEmpty() ? this.fileDescriptors_ : this.insertFileDescriptors_;
        return new LocalFsPartition(this.table_, this.spec_, this.hmsParameters_, this.writeId_, this.hdfsStorageDescriptor_, fds, (ImmutableList<HdfsPartition.FileDescriptor>)ImmutableList.of(), (ImmutableList<HdfsPartition.FileDescriptor>)ImmutableList.of(), this.partitionStats_, this.hasIncrementalStats_, this.isMarkedCached_, this.location_);
    }

    @Override
    public LocalFsPartition genDeleteDeltaPartition() {
        if (this.deleteFileDescriptors_.isEmpty()) {
            return null;
        }
        return new LocalFsPartition(this.table_, this.spec_, this.hmsParameters_, this.writeId_, this.hdfsStorageDescriptor_, this.deleteFileDescriptors_, (ImmutableList<HdfsPartition.FileDescriptor>)ImmutableList.of(), (ImmutableList<HdfsPartition.FileDescriptor>)ImmutableList.of(), this.partitionStats_, this.hasIncrementalStats_, this.isMarkedCached_, this.location_);
    }
}

