/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.local;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Set;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.impala.catalog.FeCatalogUtils;
import org.apache.impala.catalog.FeDataSourceTable;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.local.LocalDb;
import org.apache.impala.catalog.local.LocalTable;
import org.apache.impala.catalog.local.MetaProvider;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.extdatasource.ApiVersion;
import org.apache.impala.extdatasource.jdbc.conf.JdbcStorageConfig;
import org.apache.impala.thrift.TColumn;
import org.apache.impala.thrift.TDataSource;
import org.apache.impala.thrift.TDataSourceTable;
import org.apache.impala.thrift.TResultSet;
import org.apache.impala.thrift.TResultSetMetadata;
import org.apache.impala.thrift.TTableDescriptor;
import org.apache.impala.thrift.TTableType;
import org.apache.impala.util.JsonUtil;
import org.apache.impala.util.TResultRowBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDataSourceTable
extends LocalTable
implements FeDataSourceTable {
    private static final Logger LOG = LoggerFactory.getLogger(LocalDataSourceTable.class);
    private String initString_;
    private TDataSource dataSource_;

    public static LocalDataSourceTable load(LocalDb db, Table msTbl, MetaProvider.TableMetaRef ref) throws TableLoadingException {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)msTbl);
        if (LOG.isTraceEnabled()) {
            LOG.trace("load table: " + msTbl.getDbName() + "." + msTbl.getTableName());
        }
        if (msTbl.getPartitionKeysSize() > 0) {
            throw new TableLoadingException("Data source table cannot contain clustering columns: " + msTbl.getTableName());
        }
        return new LocalDataSourceTable(db, msTbl, ref);
    }

    private LocalDataSourceTable(LocalDb db, Table msTbl, MetaProvider.TableMetaRef ref) throws TableLoadingException {
        super(db, msTbl, ref);
        String dataSourceName = this.getTableProperty(msTbl, "__IMPALA_DATA_SOURCE_NAME", null, true);
        if (dataSourceName.equals("impalajdbcdatasource")) {
            this.dataSource_ = new TDataSource(dataSourceName, "", "org.apache.impala.extdatasource.jdbc.JdbcDataSource", ApiVersion.V1.name());
            HashMap<String, String> tblProperties = new HashMap<String, String>();
            for (JdbcStorageConfig config : JdbcStorageConfig.values()) {
                String propertyValue = this.getTableProperty(msTbl, config.getPropertyName(), "impalajdbcdatasource", false);
                if (propertyValue == null) continue;
                tblProperties.put(config.getPropertyName(), propertyValue);
            }
            try {
                this.initString_ = JsonUtil.convertPropertyMapToJSON(tblProperties);
            }
            catch (ImpalaRuntimeException e) {
                throw new TableLoadingException(e.getMessage());
            }
        } else {
            String location = this.getTableProperty(msTbl, "__IMPALA_DATA_SOURCE_LOCATION", dataSourceName, true);
            String className = this.getTableProperty(msTbl, "__IMPALA_DATA_SOURCE_CLASS", dataSourceName, true);
            String apiVersionString = this.getTableProperty(msTbl, "__IMPALA_DATA_SOURCE_API_VERSION", dataSourceName, true);
            this.dataSource_ = new TDataSource(dataSourceName, location, className, apiVersionString);
            this.initString_ = this.getTableProperty(msTbl, "__IMPALA_DATA_SOURCE_INIT_STRING", dataSourceName, true);
        }
    }

    private String getTableProperty(Table msTbl, String key, String dataSourceName, boolean required) throws TableLoadingException {
        String val = (String)msTbl.getParameters().get(key);
        if (val == null && required) {
            if (key.equals("__IMPALA_DATA_SOURCE_NAME")) {
                throw new TableLoadingException(String.format("Failed to load table %s. Missing required metadata: %s", msTbl.getTableName(), key));
            }
            if (dataSourceName.equals("impalajdbcdatasource")) {
                throw new TableLoadingException(String.format("Failed to load table %s stored by JDBC. Missing required metadata: %s", msTbl.getTableName(), key));
            }
            throw new TableLoadingException(String.format("Failed to load table %s produced by external data source %s. Missing required metadata: %s", msTbl.getTableName(), dataSourceName, key));
        }
        return val;
    }

    @Override
    public TDataSource getDataSource() {
        return this.dataSource_;
    }

    @Override
    public String getInitString() {
        return this.initString_;
    }

    @Override
    public int getNumNodes() {
        return 1;
    }

    @Override
    public boolean isJdbcDataSourceTable() {
        return this.dataSource_ != null && this.dataSource_.name != null && this.dataSource_.name.equals("impalajdbcdatasource");
    }

    @Override
    public TResultSet getTableStats() {
        TResultSet result = new TResultSet();
        TResultSetMetadata resultSchema = new TResultSetMetadata();
        resultSchema.addToColumns(new TColumn("#Rows", Type.BIGINT.toThrift()));
        result.setSchema(resultSchema);
        TResultRowBuilder rowBuilder = new TResultRowBuilder();
        rowBuilder.add(this.getNumRows());
        result.addToRows(rowBuilder.get());
        return result;
    }

    @Override
    public TTableDescriptor toThriftDescriptor(int tableId, Set<Long> referencedPartitions) {
        TTableDescriptor tableDesc = new TTableDescriptor(tableId, TTableType.DATA_SOURCE_TABLE, FeCatalogUtils.getTColumnDescriptors(this), this.getNumClusteringCols(), this.getName(), this.getDb().getName());
        tableDesc.setDataSourceTable(this.getDataSourceTable());
        return tableDesc;
    }

    private TDataSourceTable getDataSourceTable() {
        return new TDataSourceTable(this.dataSource_, this.initString_);
    }
}

