/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.local;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.errorprone.annotations.Immutable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.NotImplementedException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.ForeignKeysRequest;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PrimaryKeysRequest;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.iceberg.Table;
import org.apache.impala.authorization.AuthorizationPolicy;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.DataSource;
import org.apache.impala.catalog.FileMetadataLoader;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.HdfsCachePool;
import org.apache.impala.catalog.HdfsPartition;
import org.apache.impala.catalog.HdfsPartitionLocationCompressor;
import org.apache.impala.catalog.HdfsStorageDescriptor;
import org.apache.impala.catalog.MetaStoreClientPool;
import org.apache.impala.catalog.SqlConstraints;
import org.apache.impala.catalog.VirtualColumn;
import org.apache.impala.catalog.local.LocalCatalogException;
import org.apache.impala.catalog.local.LocalIcebergTable;
import org.apache.impala.catalog.local.MetaProvider;
import org.apache.impala.common.Pair;
import org.apache.impala.compat.MetastoreShim;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.thrift.TBackendGflags;
import org.apache.impala.thrift.TBriefTableMeta;
import org.apache.impala.thrift.TNetworkAddress;
import org.apache.impala.thrift.TPartialTableInfo;
import org.apache.impala.thrift.TValidWriteIdList;
import org.apache.impala.util.AcidUtils;
import org.apache.impala.util.ListMap;
import org.apache.impala.util.MetaStoreUtil;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DirectMetaProvider
implements MetaProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DirectMetaProvider.class);
    private static MetaStoreClientPool msClientPool_;

    DirectMetaProvider() {
        DirectMetaProvider.initMsClientPool();
    }

    private static synchronized void initMsClientPool() {
        if (msClientPool_ == null) {
            TBackendGflags cfg = BackendConfig.INSTANCE.getBackendCfg();
            if (MetastoreShim.getMajorVersion() > 2L) {
                MetastoreShim.setHiveClientCapabilities();
            }
            msClientPool_ = new MetaStoreClientPool(cfg.num_metadata_loading_threads, cfg.initial_hms_cnxn_timeout_s);
        }
    }

    @Override
    public Iterable<HdfsCachePool> getHdfsCachePools() {
        throw new UnsupportedOperationException("HDFSCachePools are not supported in DirectMetaProvider");
    }

    @Override
    public AuthorizationPolicy getAuthPolicy() {
        throw new UnsupportedOperationException("Authorization is not supported in DirectMetaProvider");
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public void waitForIsReady(long timeoutMs) {
    }

    @Override
    public ImmutableList<String> loadDbList() throws TException {
        try (MetaStoreClientPool.MetaStoreClient c = msClientPool_.getClient();){
            ImmutableList immutableList = ImmutableList.copyOf((Collection)c.getHiveClient().getAllDatabases());
            return immutableList;
        }
    }

    @Override
    public Database loadDb(String dbName) throws TException {
        try (MetaStoreClientPool.MetaStoreClient c = msClientPool_.getClient();){
            Database database = c.getHiveClient().getDatabase(dbName);
            return database;
        }
    }

    @Override
    public ImmutableCollection<TBriefTableMeta> loadTableList(String dbName) throws TException {
        try (MetaStoreClientPool.MetaStoreClient c = msClientPool_.getClient();){
            List tableMetaList = c.getHiveClient().getTableMeta(dbName, null, null);
            ImmutableList.Builder ret = ImmutableList.builder();
            for (TableMeta meta : tableMetaList) {
                TBriefTableMeta briefMeta = new TBriefTableMeta(meta.getTableName());
                briefMeta.setMsType(meta.getTableType());
                briefMeta.setComment(meta.getComments());
                ret.add((Object)briefMeta);
            }
            ImmutableList immutableList = ret.build();
            return immutableList;
        }
    }

    @Override
    public Pair<org.apache.hadoop.hive.metastore.api.Table, MetaProvider.TableMetaRef> getTableIfPresent(String dbName, String tblName) {
        try {
            return this.loadTable(dbName, tblName);
        }
        catch (TException e) {
            LOG.error("Failed to load table", (Throwable)e);
            return null;
        }
    }

    @Override
    public Pair<org.apache.hadoop.hive.metastore.api.Table, MetaProvider.TableMetaRef> loadTable(String dbName, String tableName) throws MetaException, NoSuchObjectException, TException {
        org.apache.hadoop.hive.metastore.api.Table msTable;
        try (MetaStoreClientPool.MetaStoreClient c = msClientPool_.getClient();){
            msTable = c.getHiveClient().getTable(dbName, tableName);
        }
        TableMetaRefImpl ref = new TableMetaRefImpl(dbName, tableName, msTable);
        return Pair.create(msTable, ref);
    }

    @Override
    public String loadNullPartitionKeyValue() throws MetaException, TException {
        try (MetaStoreClientPool.MetaStoreClient c = msClientPool_.getClient();){
            String string = MetaStoreUtil.getNullPartitionKeyValue(c.getHiveClient());
            return string;
        }
    }

    @Override
    public List<MetaProvider.PartitionRef> loadPartitionList(MetaProvider.TableMetaRef table) throws MetaException, TException {
        List partNames;
        Preconditions.checkArgument((boolean)(table instanceof TableMetaRefImpl));
        TableMetaRefImpl ref = (TableMetaRefImpl)table;
        if (!ref.isPartitioned()) {
            return ImmutableList.of((Object)new PartitionRefImpl(""));
        }
        MetaStoreClientPool.MetaStoreClient c = msClientPool_.getClient();
        Object object = null;
        try {
            partNames = c.getHiveClient().listPartitionNames(ref.dbName_, ref.tableName_, (short)-1);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (c != null) {
                if (object != null) {
                    try {
                        c.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    c.close();
                }
            }
        }
        ArrayList partRefs = Lists.newArrayListWithCapacity((int)partNames.size());
        for (String name : partNames) {
            partRefs.add(new PartitionRefImpl(name));
        }
        return partRefs;
    }

    @Override
    public SqlConstraints loadConstraints(MetaProvider.TableMetaRef table, org.apache.hadoop.hive.metastore.api.Table msTbl) throws TException {
        SqlConstraints sqlConstraints;
        try (MetaStoreClientPool.MetaStoreClient c = msClientPool_.getClient();){
            sqlConstraints = new SqlConstraints(c.getHiveClient().getPrimaryKeys(new PrimaryKeysRequest(msTbl.getDbName(), msTbl.getTableName())), c.getHiveClient().getForeignKeys(new ForeignKeysRequest(null, null, msTbl.getDbName(), msTbl.getTableName())));
        }
        return sqlConstraints;
    }

    @Override
    public Map<String, MetaProvider.PartitionMetadata> loadPartitionsByRefs(MetaProvider.TableMetaRef table, List<String> partitionColumnNames, ListMap<TNetworkAddress> hostIndex, List<MetaProvider.PartitionRef> partitionRefs) throws CatalogException, TException {
        List<Partition> parts;
        Preconditions.checkNotNull((Object)table);
        Preconditions.checkArgument((boolean)(table instanceof TableMetaRefImpl));
        Preconditions.checkArgument((!partitionColumnNames.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkNotNull(partitionRefs);
        TableMetaRefImpl tableImpl = (TableMetaRefImpl)table;
        String fullTableName = tableImpl.dbName_ + "." + tableImpl.tableName_;
        if (!((TableMetaRefImpl)table).isPartitioned()) {
            return this.loadUnpartitionedPartition((TableMetaRefImpl)table, partitionRefs, hostIndex);
        }
        HashMap ret = Maps.newHashMapWithExpectedSize((int)partitionRefs.size());
        if (partitionRefs.isEmpty()) {
            return ret;
        }
        ArrayList partNames = Lists.newArrayListWithCapacity((int)partitionRefs.size());
        for (MetaProvider.PartitionRef ref : partitionRefs) {
            partNames.add(ref.getName());
        }
        MetaStoreClientPool.MetaStoreClient c = msClientPool_.getClient();
        Object object = null;
        try {
            parts = MetaStoreUtil.fetchPartitionsByName(c.getHiveClient(), partNames, tableImpl.msTable_);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (c != null) {
                if (object != null) {
                    try {
                        c.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    c.close();
                }
            }
        }
        ImmutableSet namesSet = ImmutableSet.copyOf((Collection)partNames);
        for (Partition p : parts) {
            List vals = p.getValues();
            if (vals.size() != partitionColumnNames.size()) {
                throw new MetaException("Unexpected number of partition values for partition " + vals + " (expected " + partitionColumnNames.size() + ")");
            }
            String partName = MetastoreShim.makePartName(partitionColumnNames, p.getValues());
            if (!namesSet.contains(partName)) {
                throw new MetaException("HMS returned unexpected partition " + partName + " which was not requested. Requested: " + namesSet);
            }
            FileMetadataLoader loader = this.loadFileMetadata(fullTableName, partName, p, hostIndex);
            MetaProvider.PartitionMetadata existing = ret.put(partName, this.createPartMetadataImpl(p, loader));
            if (existing == null) continue;
            throw new MetaException("HMS returned multiple partitions with name " + partName);
        }
        return ret;
    }

    private PartitionMetadataImpl createPartMetadataImpl(Partition p, FileMetadataLoader loader) {
        ImmutableList deleteFds;
        ImmutableList insertFds;
        ImmutableList fds;
        List<HdfsPartition.FileDescriptor> deleteDescriptors = loader.getLoadedDeleteDeltaFds();
        if (deleteDescriptors != null && !deleteDescriptors.isEmpty()) {
            fds = ImmutableList.copyOf(Collections.emptyList());
            insertFds = ImmutableList.copyOf(loader.getLoadedInsertDeltaFds());
            deleteFds = ImmutableList.copyOf(loader.getLoadedDeleteDeltaFds());
        } else {
            fds = ImmutableList.copyOf(loader.getLoadedFds());
            insertFds = ImmutableList.copyOf(Collections.emptyList());
            deleteFds = ImmutableList.copyOf(Collections.emptyList());
        }
        return new PartitionMetadataImpl(p, (ImmutableList<HdfsPartition.FileDescriptor>)fds, (ImmutableList<HdfsPartition.FileDescriptor>)insertFds, (ImmutableList<HdfsPartition.FileDescriptor>)deleteFds);
    }

    private Map<String, MetaProvider.PartitionMetadata> loadUnpartitionedPartition(TableMetaRefImpl table, List<MetaProvider.PartitionRef> partitionRefs, ListMap<TNetworkAddress> hostIndex) throws CatalogException {
        Preconditions.checkArgument((partitionRefs.size() == 1 ? 1 : 0) != 0, (Object)"Expected exactly one partition to load for unpartitioned table");
        MetaProvider.PartitionRef ref = partitionRefs.get(0);
        Preconditions.checkArgument((boolean)ref.getName().isEmpty(), (Object)"Expected empty partition name for unpartitioned table");
        Partition msPartition = DirectMetaProvider.msTableToPartition(table.msTable_);
        String fullName = table.dbName_ + "." + table.tableName_;
        FileMetadataLoader loader = this.loadFileMetadata(fullName, "default", msPartition, hostIndex);
        return ImmutableMap.of((Object)"", (Object)this.createPartMetadataImpl(msPartition, loader));
    }

    static Partition msTableToPartition(org.apache.hadoop.hive.metastore.api.Table msTable) {
        Partition msp = new Partition();
        msp.setSd(msTable.getSd());
        msp.setParameters(msTable.getParameters());
        msp.setValues(Collections.emptyList());
        return msp;
    }

    @Override
    public List<String> loadFunctionNames(String dbName) throws TException {
        throw new UnsupportedOperationException("Functions not supported by DirectMetaProvider");
    }

    @Override
    public ImmutableList<Function> loadFunction(String dbName, String functionName) throws TException {
        throw new UnsupportedOperationException("Functions not supported by DirectMetaProvider");
    }

    @Override
    public ImmutableList<DataSource> loadDataSources() throws TException {
        throw new UnsupportedOperationException("DataSource not supported by DirectMetaProvider");
    }

    @Override
    public DataSource loadDataSource(String dsName) throws TException {
        throw new UnsupportedOperationException("DataSource not supported by DirectMetaProvider");
    }

    @Override
    public List<ColumnStatisticsObj> loadTableColumnStatistics(MetaProvider.TableMetaRef table, List<String> colNames) throws TException {
        Preconditions.checkArgument((boolean)(table instanceof TableMetaRefImpl));
        try (MetaStoreClientPool.MetaStoreClient c = msClientPool_.getClient();){
            List<ColumnStatisticsObj> list = MetastoreShim.getTableColumnStatistics(c.getHiveClient(), ((TableMetaRefImpl)table).dbName_, ((TableMetaRefImpl)table).tableName_, colNames);
            return list;
        }
    }

    private FileMetadataLoader loadFileMetadata(String fullTableName, String partName, Partition msPartition, ListMap<TNetworkAddress> hostIndex) throws CatalogException {
        Path partDir = new Path(msPartition.getSd().getLocation());
        FileMetadataLoader fml = new FileMetadataLoader(partDir, BackendConfig.INSTANCE.recursivelyListPartitions(), Collections.emptyList(), hostIndex, null, null);
        try {
            fml.load();
        }
        catch (FileNotFoundException fnf) {
            return fml;
        }
        catch (IOException ioe) {
            throw new LocalCatalogException(String.format("Could not load files for partition %s of table %s", partName, fullTableName), ioe);
        }
        return fml;
    }

    @Override
    public TValidWriteIdList getValidWriteIdList(MetaProvider.TableMetaRef ref) {
        throw new NotImplementedException("getValidWriteIdList() is not implemented for DirectMetaProvider");
    }

    public List<MetaProvider.PartitionRef> checkLatestCompaction(String dbName, String tableName, MetaProvider.TableMetaRef table, Map<MetaProvider.PartitionRef, MetaProvider.PartitionMetadata> metas) throws TException {
        Preconditions.checkNotNull((Object)table, (Object)"TableMetaRef must be non-null");
        Preconditions.checkNotNull(metas, (Object)"Partition map must be non-null");
        List<MetaProvider.PartitionRef> stalePartitions = MetastoreShim.checkLatestCompaction(msClientPool_, dbName, tableName, table, metas, "");
        return stalePartitions;
    }

    @Override
    public TPartialTableInfo loadIcebergTable(MetaProvider.TableMetaRef table) throws TException {
        throw new NotImplementedException("loadIcebergTable() is not implemented for DirectMetaProvider");
    }

    @Override
    public Table loadIcebergApiTable(MetaProvider.TableMetaRef table, LocalIcebergTable.TableParams param, org.apache.hadoop.hive.metastore.api.Table msTable) throws TException {
        throw new NotImplementedException("loadIcebergApiTable() is not implemented for DirectMetaProvider");
    }

    private class TableMetaRefImpl
    implements MetaProvider.TableMetaRef {
        private final String dbName_;
        private final String tableName_;
        private final org.apache.hadoop.hive.metastore.api.Table msTable_;

        public TableMetaRefImpl(String dbName, String tableName, org.apache.hadoop.hive.metastore.api.Table msTable) {
            this.dbName_ = dbName;
            this.tableName_ = tableName;
            this.msTable_ = msTable;
        }

        @Override
        public boolean isPartitioned() {
            return this.msTable_.getPartitionKeysSize() != 0;
        }

        @Override
        public boolean isMarkedCached() {
            throw new UnsupportedOperationException("Hdfs caching not supported with DirectMetaProvider implementation");
        }

        @Override
        public List<String> getPartitionPrefixes() {
            return Collections.emptyList();
        }

        @Override
        public boolean isTransactional() {
            return AcidUtils.isTransactionalTable(this.msTable_.getParameters());
        }

        @Override
        public List<VirtualColumn> getVirtualColumns() {
            throw new UnsupportedOperationException("Virtual columns are not supported with DirectMetaProvider implementation");
        }
    }

    private static class PartitionMetadataImpl
    implements MetaProvider.PartitionMetadata {
        private final Partition msPartition_;
        private final ImmutableList<HdfsPartition.FileDescriptor> fds_;
        private final ImmutableList<HdfsPartition.FileDescriptor> insertFds_;
        private final ImmutableList<HdfsPartition.FileDescriptor> deleteFds_;

        public PartitionMetadataImpl(Partition msPartition, ImmutableList<HdfsPartition.FileDescriptor> fds, ImmutableList<HdfsPartition.FileDescriptor> insertFds, ImmutableList<HdfsPartition.FileDescriptor> deleteFds) {
            this.msPartition_ = msPartition;
            this.fds_ = fds;
            this.insertFds_ = insertFds;
            this.deleteFds_ = deleteFds;
        }

        @Override
        public Map<String, String> getHmsParameters() {
            return this.msPartition_.getParameters();
        }

        @Override
        public long getWriteId() {
            return MetastoreShim.getWriteIdFromMSPartition(this.msPartition_);
        }

        @Override
        public HdfsStorageDescriptor getInputFormatDescriptor() {
            String tblName = this.msPartition_.getDbName() + "." + this.msPartition_.getTableName();
            try {
                return HdfsStorageDescriptor.fromStorageDescriptor(tblName, this.msPartition_.getSd());
            }
            catch (HdfsStorageDescriptor.InvalidStorageDescriptorException e) {
                throw new LocalCatalogException(String.format("Invalid input format descriptor for partition (values=%s) of table %s", this.msPartition_.getValues(), tblName), e);
            }
        }

        @Override
        public HdfsPartitionLocationCompressor.Location getLocation() {
            HdfsPartitionLocationCompressor hdfsPartitionLocationCompressor = new HdfsPartitionLocationCompressor(0);
            hdfsPartitionLocationCompressor.getClass();
            return hdfsPartitionLocationCompressor.new HdfsPartitionLocationCompressor.Location(this.msPartition_.getSd().getLocation());
        }

        @Override
        public ImmutableList<HdfsPartition.FileDescriptor> getFileDescriptors() {
            if (this.insertFds_.isEmpty()) {
                return this.fds_;
            }
            ArrayList ret = Lists.newArrayListWithCapacity((int)(this.insertFds_.size() + this.deleteFds_.size()));
            ret.addAll(this.insertFds_);
            ret.addAll(this.deleteFds_);
            return ImmutableList.copyOf((Collection)ret);
        }

        @Override
        public ImmutableList<HdfsPartition.FileDescriptor> getInsertFileDescriptors() {
            return this.insertFds_;
        }

        @Override
        public ImmutableList<HdfsPartition.FileDescriptor> getDeleteFileDescriptors() {
            return this.deleteFds_;
        }

        @Override
        public boolean hasIncrementalStats() {
            return false;
        }

        @Override
        public byte[] getPartitionStats() {
            throw new UnsupportedOperationException("Incremental stats not supported with DirectMetaProvider implementation.");
        }

        @Override
        public boolean isMarkedCached() {
            throw new UnsupportedOperationException("Hdfs caching not supported with DirectMetaProvider implementation");
        }

        @Override
        public long getLastCompactionId() {
            throw new UnsupportedOperationException("Compaction id is not provided with DirectMetaProvider implementation");
        }
    }

    @Immutable
    private static class PartitionRefImpl
    implements MetaProvider.PartitionRef {
        private static final String UNPARTITIONED_NAME = "";
        private final String name_;

        public PartitionRefImpl(String name) {
            this.name_ = name;
        }

        @Override
        public String getName() {
            return this.name_;
        }
    }
}

