/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.iceberg;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.hive.HiveCatalog;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.IcebergTableLoadingException;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.catalog.iceberg.IcebergCatalog;
import org.apache.impala.thrift.TIcebergCatalog;
import org.apache.impala.util.IcebergUtil;

public class IcebergHiveCatalog
implements IcebergCatalog {
    private static IcebergHiveCatalog instance_;
    private final HiveCatalog hiveCatalog_;

    public static synchronized IcebergHiveCatalog getInstance() {
        if (instance_ == null) {
            instance_ = new IcebergHiveCatalog();
        }
        return instance_;
    }

    private IcebergHiveCatalog() {
        this.setContextClassLoader();
        HiveConf conf = new HiveConf(IcebergHiveCatalog.class);
        conf.setBoolean("iceberg.engine.hive.enabled", true);
        this.hiveCatalog_ = new HiveCatalog();
        this.hiveCatalog_.setConf((Configuration)conf);
        Map<String, String> properties = IcebergUtil.composeCatalogProperties();
        this.hiveCatalog_.initialize("ImpalaHiveCatalog", properties);
    }

    @Override
    public Table createTable(TableIdentifier identifier, Schema schema, PartitionSpec spec, String location, Map<String, String> properties) {
        properties.put("external.table.purge", properties.getOrDefault("external.table.purge", "TRUE"));
        return this.hiveCatalog_.createTable(identifier, schema, spec, location, properties);
    }

    @Override
    public Table loadTable(FeIcebergTable feTable) throws TableLoadingException {
        Preconditions.checkState((feTable.getIcebergCatalog() == TIcebergCatalog.HIVE_CATALOG ? 1 : 0) != 0);
        TableIdentifier tableId = IcebergUtil.getIcebergTableIdentifier(feTable);
        return this.loadTable(tableId, null, null);
    }

    @Override
    public Table loadTable(TableIdentifier tableId, String tableLocation, Map<String, String> properties) throws IcebergTableLoadingException {
        Preconditions.checkState((tableId != null ? 1 : 0) != 0);
        try {
            return this.hiveCatalog_.loadTable(tableId);
        }
        catch (Exception e) {
            throw new IcebergTableLoadingException(String.format("Failed to load Iceberg table with id: %s", tableId), e);
        }
    }

    @Override
    public boolean dropTable(FeIcebergTable feTable, boolean purge) {
        Preconditions.checkState((feTable.getIcebergCatalog() == TIcebergCatalog.HIVE_CATALOG ? 1 : 0) != 0);
        TableIdentifier tableId = IcebergUtil.getIcebergTableIdentifier(feTable);
        return this.hiveCatalog_.dropTable(tableId, purge);
    }

    @Override
    public boolean dropTable(String dbName, String tblName, boolean purge) {
        return this.hiveCatalog_.dropTable(TableIdentifier.of((String[])new String[]{dbName, tblName}), purge);
    }

    @Override
    public void renameTable(FeIcebergTable feTable, TableIdentifier newTableId) {
        TableIdentifier oldTableId = IcebergUtil.getIcebergTableIdentifier(feTable);
        this.hiveCatalog_.renameTable(oldTableId, newTableId);
    }
}

