/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.iceberg;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.types.TypeUtil;
import org.apache.impala.analysis.ColumnDef;
import org.apache.impala.analysis.IcebergPartitionSpec;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.CatalogObject;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.CtasTargetTable;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.FeCatalogUtils;
import org.apache.impala.catalog.FeDb;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.HdfsStorageDescriptor;
import org.apache.impala.catalog.HdfsTable;
import org.apache.impala.catalog.IcebergColumn;
import org.apache.impala.catalog.IcebergContentFileStore;
import org.apache.impala.catalog.IcebergStructField;
import org.apache.impala.catalog.StructType;
import org.apache.impala.catalog.iceberg.IcebergCatalogs;
import org.apache.impala.catalog.local.LocalDb;
import org.apache.impala.catalog.local.LocalFsTable;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.service.MetadataOp;
import org.apache.impala.thrift.TCatalogObjectType;
import org.apache.impala.thrift.TColumn;
import org.apache.impala.thrift.TCompressionCodec;
import org.apache.impala.thrift.THdfsPartition;
import org.apache.impala.thrift.THdfsStorageDescriptor;
import org.apache.impala.thrift.THdfsTable;
import org.apache.impala.thrift.TIcebergCatalog;
import org.apache.impala.thrift.TIcebergFileFormat;
import org.apache.impala.thrift.TIcebergPartitionStats;
import org.apache.impala.thrift.TImpalaTableType;
import org.apache.impala.thrift.TTableDescriptor;
import org.apache.impala.thrift.TTableType;
import org.apache.impala.util.IcebergSchemaConverter;
import org.apache.impala.util.IcebergUtil;

public class IcebergCtasTarget
extends CtasTargetTable
implements FeIcebergTable {
    private FeFsTable fsTable_;
    private Schema iceSchema_;
    private List<IcebergPartitionSpec> partitionSpecs_ = new ArrayList<IcebergPartitionSpec>();
    private TIcebergFileFormat icebergFileFormat_;
    private TCompressionCodec icebergParquetCompressionCodec_;
    private long icebergParquetRowGroupSize_;
    private long icebergParquetPlainPageSize_;
    private long icebergParquetDictPageSize_;
    private TIcebergCatalog icebergCatalog_;
    private String icebergTableLocation_;
    private String icebergCatalogLocation_;
    private HdfsStorageDescriptor hdfsSd_;

    public IcebergCtasTarget(FeDb db, org.apache.hadoop.hive.metastore.api.Table msTbl, List<ColumnDef> columnDefs, List<String> primaryKeyNames, IcebergPartitionSpec partSpec) throws CatalogException, ImpalaRuntimeException {
        super(msTbl, db, msTbl.getTableName(), msTbl.getOwner());
        this.createFsTable(db, msTbl);
        this.createIcebergSchema(columnDefs, primaryKeyNames);
        this.createPartitionSpec(partSpec);
        this.icebergCatalog_ = IcebergUtil.getTIcebergCatalog(msTbl);
        this.setLocations();
        this.icebergFileFormat_ = IcebergUtil.getIcebergFileFormat(msTbl);
        this.icebergParquetCompressionCodec_ = FeIcebergTable.Utils.getIcebergParquetCompressionCodec(msTbl);
        this.icebergParquetRowGroupSize_ = FeIcebergTable.Utils.getIcebergParquetRowGroupSize(msTbl);
        this.icebergParquetPlainPageSize_ = FeIcebergTable.Utils.getIcebergParquetPlainPageSize(msTbl);
        this.icebergParquetDictPageSize_ = FeIcebergTable.Utils.getIcebergParquetDictPageSize(msTbl);
        this.hdfsSd_ = HdfsStorageDescriptor.fromStorageDescriptor(this.name_, this.msTable_.getSd());
    }

    private void createIcebergSchema(List<ColumnDef> columnDefs, List<String> primaryKeyNames) throws CatalogException {
        ArrayList<TColumn> tcols = new ArrayList<TColumn>();
        for (ColumnDef columnDef : columnDefs) {
            tcols.add(columnDef.toThrift());
        }
        try {
            this.iceSchema_ = IcebergSchemaConverter.genIcebergSchema(tcols, primaryKeyNames);
            this.iceSchema_ = TypeUtil.assignIncreasingFreshIds((Schema)this.iceSchema_);
            for (Column column : IcebergSchemaConverter.convertToImpalaSchema(this.iceSchema_)) {
                this.addColumn((IcebergColumn)column);
            }
        }
        catch (ImpalaRuntimeException ex) {
            throw new CatalogException("Exception caught during generating Iceberg schema:", ex);
        }
    }

    private void createPartitionSpec(IcebergPartitionSpec partSpec) throws CatalogException, ImpalaRuntimeException {
        Preconditions.checkState((this.iceSchema_ != null ? 1 : 0) != 0);
        PartitionSpec iceSpec = null;
        try {
            iceSpec = partSpec == null ? PartitionSpec.unpartitioned() : IcebergUtil.createIcebergPartition(this.iceSchema_, partSpec.toThrift());
        }
        catch (ImpalaRuntimeException ex) {
            throw new CatalogException("Exception caught during generating Iceberg schema:", ex);
        }
        IcebergPartitionSpec resolvedIcebergSpec = FeIcebergTable.Utils.convertPartitionSpec(this.iceSchema_, iceSpec);
        this.partitionSpecs_.add(resolvedIcebergSpec);
    }

    private void setLocations() {
        Preconditions.checkState((this.msTable_ != null ? 1 : 0) != 0);
        Preconditions.checkState((this.icebergCatalog_ != null ? 1 : 0) != 0);
        TIcebergCatalog underlyingCatalog = IcebergUtil.getUnderlyingCatalog(this.msTable_);
        if (underlyingCatalog == TIcebergCatalog.HADOOP_CATALOG) {
            if (this.icebergCatalog_ == TIcebergCatalog.CATALOGS) {
                String catName = (String)this.msTable_.getParameters().get("iceberg.catalog");
                this.icebergCatalogLocation_ = IcebergCatalogs.getInstance().getCatalogProperty(catName, "warehouse");
            } else {
                this.icebergCatalogLocation_ = IcebergUtil.getIcebergCatalogLocation(this.msTable_);
            }
            TableIdentifier tId = IcebergUtil.getIcebergTableIdentifier(this.msTable_);
            Namespace ns = tId.namespace();
            ArrayList<String> components = new ArrayList<String>();
            Collections.addAll(components, ns.levels());
            components.add(tId.name());
            this.icebergTableLocation_ = this.icebergCatalogLocation_ + "/" + String.join((CharSequence)"/", components);
            return;
        }
        Preconditions.checkState((this.icebergCatalog_ == TIcebergCatalog.HADOOP_TABLES || this.icebergCatalog_ == TIcebergCatalog.HIVE_CATALOG || this.icebergCatalog_ == TIcebergCatalog.CATALOGS ? 1 : 0) != 0);
        this.icebergCatalogLocation_ = this.icebergTableLocation_ = this.msTable_.getSd().getLocation();
    }

    private void createFsTable(FeDb db, org.apache.hadoop.hive.metastore.api.Table msTbl) throws CatalogException {
        this.fsTable_ = db instanceof Db ? HdfsTable.createCtasTarget((Db)db, msTbl) : LocalFsTable.createCtasTarget((LocalDb)db, msTbl);
    }

    @Override
    public IcebergContentFileStore getContentFileStore() {
        return new IcebergContentFileStore();
    }

    @Override
    public FeFsTable getFeFsTable() {
        return this.fsTable_;
    }

    @Override
    public TIcebergCatalog getIcebergCatalog() {
        return this.icebergCatalog_;
    }

    @Override
    public String getIcebergCatalogLocation() {
        return this.icebergCatalogLocation_;
    }

    @Override
    public TIcebergFileFormat getIcebergFileFormat() {
        return this.icebergFileFormat_;
    }

    @Override
    public TCompressionCodec getIcebergParquetCompressionCodec() {
        return this.icebergParquetCompressionCodec_;
    }

    @Override
    public long getIcebergParquetRowGroupSize() {
        return this.icebergParquetRowGroupSize_;
    }

    @Override
    public long getIcebergParquetPlainPageSize() {
        return this.icebergParquetPlainPageSize_;
    }

    @Override
    public long getIcebergParquetDictPageSize() {
        return this.icebergParquetDictPageSize_;
    }

    @Override
    public String getIcebergTableLocation() {
        return this.icebergTableLocation_;
    }

    @Override
    public List<IcebergPartitionSpec> getPartitionSpecs() {
        return this.partitionSpecs_;
    }

    @Override
    public IcebergPartitionSpec getDefaultPartitionSpec() {
        return this.partitionSpecs_.get(0);
    }

    @Override
    public int getDefaultPartitionSpecId() {
        return 0;
    }

    @Override
    public Schema getIcebergSchema() {
        return this.iceSchema_;
    }

    @Override
    public THdfsTable transformToTHdfsTable(boolean updatePartitionFlag, CatalogObject.ThriftObjectType type) {
        throw new IllegalStateException("not implemented here");
    }

    @Override
    public long snapshotId() {
        return -1L;
    }

    @Override
    public Map<String, TIcebergPartitionStats> getIcebergPartitionStats() {
        return null;
    }

    @Override
    public Table getIcebergApiTable() {
        return null;
    }

    public void addColumn(IcebergColumn col) {
        this.colsByPos_.add(col);
        this.colsByName_.put(col.getName().toLowerCase(), col);
        ((StructType)this.type_.getItemType()).addField(new IcebergStructField(col.getName(), col.getType(), col.getComment(), col.getFieldId()));
    }

    @Override
    public TTableDescriptor toThriftDescriptor(int tableId, Set<Long> referencedPartitions) {
        TTableDescriptor desc = new TTableDescriptor(tableId, TTableType.ICEBERG_TABLE, FeCatalogUtils.getTColumnDescriptors(this), this.getNumClusteringCols(), this.getName(), this.db_.getName());
        desc.setIcebergTable(FeIcebergTable.Utils.getTIcebergTable(this, CatalogObject.ThriftObjectType.DESCRIPTOR_ONLY));
        desc.setHdfsTable(this.transformToTHdfsTable());
        return desc;
    }

    private THdfsTable transformToTHdfsTable() {
        if (this.fsTable_ instanceof HdfsTable) {
            return this.transformOldToTHdfsTable();
        }
        return this.transformLocalToTHdfsTable();
    }

    private THdfsTable transformOldToTHdfsTable() {
        THdfsTable hdfsTable = ((HdfsTable)this.fsTable_).getTHdfsTable(CatalogObject.ThriftObjectType.FULL, null);
        hdfsTable.setPrototype_partition(this.createPrototypePartition());
        return hdfsTable;
    }

    private THdfsTable transformLocalToTHdfsTable() {
        LocalFsTable localFsTable = (LocalFsTable)this.fsTable_;
        HashMap<Long, THdfsPartition> idToPartition = new HashMap<Long, THdfsPartition>();
        THdfsPartition tPrototypePartition = this.createPrototypePartition();
        return new THdfsTable(localFsTable.getHdfsBaseDir(), this.getColumnNames(), localFsTable.getNullPartitionKeyValue(), "\\N", idToPartition, tPrototypePartition);
    }

    private THdfsPartition createPrototypePartition() {
        THdfsPartition prototypePart = new THdfsPartition();
        THdfsStorageDescriptor sd = new THdfsStorageDescriptor();
        sd.setFileFormat(IcebergUtil.toTHdfsFileFormat(this.icebergFileFormat_));
        sd.setBlockSize(this.hdfsSd_.getBlockSize());
        prototypePart.setHdfs_storage_descriptor(sd);
        prototypePart.setId(-1L);
        return prototypePart;
    }

    @Override
    public TCatalogObjectType getCatalogObjectType() {
        return TCatalogObjectType.TABLE;
    }

    @Override
    public TImpalaTableType getTableType() {
        return TImpalaTableType.TABLE;
    }

    @Override
    public String getTableComment() {
        return MetadataOp.getTableComment(this.msTable_);
    }
}

