/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.iceberg;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.mr.Catalogs;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.IcebergTableLoadingException;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.catalog.iceberg.IcebergCatalog;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.thrift.TIcebergCatalog;
import org.apache.impala.util.IcebergUtil;

public class IcebergCatalogs
implements IcebergCatalog {
    private static IcebergCatalogs instance_;
    private final Configuration configuration_ = new HiveConf(IcebergCatalogs.class);

    public static synchronized IcebergCatalogs getInstance() {
        if (instance_ == null) {
            instance_ = new IcebergCatalogs();
        }
        return instance_;
    }

    private IcebergCatalogs() {
        this.configuration_.setBoolean("iceberg.engine.hive.enabled", true);
    }

    public TIcebergCatalog getUnderlyingCatalogType(String catalogName) {
        String catalogType = this.getCatalogProperty(catalogName, "type");
        if (catalogType == null || "hive".equalsIgnoreCase(catalogType)) {
            return TIcebergCatalog.HIVE_CATALOG;
        }
        if ("hadoop".equalsIgnoreCase(catalogType)) {
            return TIcebergCatalog.HADOOP_CATALOG;
        }
        if ("location".equalsIgnoreCase(catalogType)) {
            return TIcebergCatalog.HADOOP_TABLES;
        }
        return TIcebergCatalog.CATALOGS;
    }

    @Override
    public Table createTable(TableIdentifier identifier, Schema schema, PartitionSpec spec, String location, Map<String, String> tableProps) throws ImpalaRuntimeException {
        this.setContextClassLoader();
        String catName = tableProps.get("iceberg.catalog");
        Preconditions.checkState((catName != null ? 1 : 0) != 0);
        String catalogType = this.getCatalogProperty(catName, "type");
        if (catalogType == null) {
            throw new ImpalaRuntimeException(String.format("Unknown catalog name: %s", catName));
        }
        Properties properties = IcebergCatalogs.createPropsForCatalogs(identifier, location, tableProps);
        properties.setProperty("iceberg.mr.table.schema", SchemaParser.toJson((Schema)schema));
        properties.setProperty("iceberg.mr.table.partition.spec", PartitionSpecParser.toJson((PartitionSpec)spec));
        properties.setProperty("external.table.purge", tableProps.getOrDefault("external.table.purge", "TRUE"));
        return Catalogs.createTable((Configuration)this.configuration_, (Properties)properties);
    }

    @Override
    public Table loadTable(FeIcebergTable feTable) throws TableLoadingException {
        this.setContextClassLoader();
        TableIdentifier tableId = IcebergUtil.getIcebergTableIdentifier(feTable);
        return this.loadTable(tableId, feTable.getLocation(), feTable.getMetaStoreTable().getParameters());
    }

    @Override
    public Table loadTable(TableIdentifier tableId, String tableLocation, Map<String, String> tableProps) throws IcebergTableLoadingException {
        this.setContextClassLoader();
        Properties properties = IcebergCatalogs.createPropsForCatalogs(tableId, tableLocation, tableProps);
        return Catalogs.loadTable((Configuration)this.configuration_, (Properties)properties);
    }

    @Override
    public boolean dropTable(FeIcebergTable feTable, boolean purge) {
        this.setContextClassLoader();
        if (!purge) {
            return true;
        }
        TableIdentifier tableId = IcebergUtil.getIcebergTableIdentifier(feTable);
        String tableLocation = feTable.getLocation();
        Properties properties = IcebergCatalogs.createPropsForCatalogs(tableId, tableLocation, feTable.getMetaStoreTable().getParameters());
        return Catalogs.dropTable((Configuration)this.configuration_, (Properties)properties);
    }

    @Override
    public boolean dropTable(String dbName, String tblName, boolean purge) {
        throw new UnsupportedOperationException("'Catalogs' doesn't support dropping table by name");
    }

    @Override
    public void renameTable(FeIcebergTable feTable, TableIdentifier newTableId) {
        throw new UnsupportedOperationException("Cannot rename Iceberg tables that use 'Catalogs'.");
    }

    public String getCatalogProperty(String catalogName, String catalogPropertyKey) {
        String propKey = String.format("%s%s.%s", "iceberg.catalog.", catalogName, catalogPropertyKey);
        return this.configuration_.get(propKey);
    }

    public static Properties createPropsForCatalogs(TableIdentifier tableId, String location, Map<String, String> tableProps) {
        Properties properties = new Properties();
        properties.putAll(tableProps);
        if (tableId != null) {
            properties.setProperty("name", tableId.toString());
        } else if (location != null) {
            properties.setProperty("location", location);
        }
        properties.setProperty("iceberg.catalog", tableProps.get("iceberg.catalog"));
        return properties;
    }
}

