/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.events;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.impala.catalog.events.MetastoreEvents;
import org.apache.impala.thrift.TPartitionKeyValue;

public class SelfEventContext {
    private final String dbName_;
    private final String tblName_;
    private final List<Long> insertEventIds_;
    private final List<List<TPartitionKeyValue>> partitionKeyValues_;
    private final long versionNumberFromEvent_;
    private final String serviceidFromEvent_;

    SelfEventContext(String dbName, String tblName, Map<String, String> parameters) {
        this(dbName, tblName, null, parameters, null);
    }

    SelfEventContext(String dbName, String tblName, List<List<TPartitionKeyValue>> partitionKeyValues, Map<String, String> parameters) {
        this(dbName, tblName, partitionKeyValues, parameters, null);
    }

    SelfEventContext(String dbName, @Nullable String tblName, @Nullable List<List<TPartitionKeyValue>> partitionKeyValues, Map<String, String> parameters, List<Long> insertEventIds) {
        Preconditions.checkNotNull(parameters);
        Preconditions.checkArgument((partitionKeyValues == null || insertEventIds == null || partitionKeyValues.size() == insertEventIds.size() ? 1 : 0) != 0);
        this.dbName_ = (String)Preconditions.checkNotNull((Object)dbName);
        this.tblName_ = tblName;
        this.partitionKeyValues_ = partitionKeyValues;
        this.insertEventIds_ = insertEventIds;
        this.versionNumberFromEvent_ = Long.parseLong(MetastoreEvents.getStringProperty(parameters, MetastoreEvents.MetastoreEventPropertyKey.CATALOG_VERSION.getKey(), "-1"));
        this.serviceidFromEvent_ = MetastoreEvents.getStringProperty(parameters, MetastoreEvents.MetastoreEventPropertyKey.CATALOG_SERVICE_ID.getKey(), "");
    }

    public String getDbName() {
        return this.dbName_;
    }

    public String getTblName() {
        return this.tblName_;
    }

    public long getInsertEventId(int idx) {
        return this.insertEventIds_.get(idx);
    }

    public long getVersionNumberFromEvent() {
        return this.versionNumberFromEvent_;
    }

    public String getServiceIdFromEvent() {
        return this.serviceidFromEvent_;
    }

    public List<List<TPartitionKeyValue>> getPartitionKeyValues() {
        return this.partitionKeyValues_ == null ? null : Collections.unmodifiableList(this.partitionKeyValues_);
    }

    public boolean isInsertEventContext() {
        return this.insertEventIds_ != null;
    }
}

