/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.events;

import com.codahale.metrics.Timer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.TxnToWriteId;
import org.apache.hadoop.hive.metastore.messaging.AbortTxnMessage;
import org.apache.hadoop.hive.metastore.messaging.AddPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.AllocWriteIdMessage;
import org.apache.hadoop.hive.metastore.messaging.AlterPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.CreateTableMessage;
import org.apache.hadoop.hive.metastore.messaging.DropPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.InsertMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONAlterDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONAlterTableMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONCreateDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONDropDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONDropTableMessage;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.impala.analysis.TableName;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.CatalogServiceCatalog;
import org.apache.impala.catalog.DatabaseNotFoundException;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.FileMetadataLoadOpts;
import org.apache.impala.catalog.HdfsTable;
import org.apache.impala.catalog.IncompleteTable;
import org.apache.impala.catalog.MetastoreClientInstantiationException;
import org.apache.impala.catalog.Table;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.catalog.TableNotFoundException;
import org.apache.impala.catalog.TableNotLoadedException;
import org.apache.impala.catalog.TableWriteId;
import org.apache.impala.catalog.events.EventFactory;
import org.apache.impala.catalog.events.MetastoreEventsProcessor;
import org.apache.impala.catalog.events.MetastoreNotificationException;
import org.apache.impala.catalog.events.MetastoreNotificationNeedsInvalidateException;
import org.apache.impala.catalog.events.SelfEventContext;
import org.apache.impala.common.Metrics;
import org.apache.impala.common.PrintUtils;
import org.apache.impala.common.Reference;
import org.apache.impala.compat.MetastoreShim;
import org.apache.impala.hive.common.MutableValidWriteIdList;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.service.CatalogOpExecutor;
import org.apache.impala.thrift.TPartitionKeyValue;
import org.apache.impala.thrift.TTableName;
import org.apache.impala.util.AcidUtils;
import org.apache.impala.util.DebugUtils;
import org.apache.impala.util.MetaStoreUtil;
import org.apache.impala.util.NoOpEventSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetastoreEvents {
    @VisibleForTesting
    static final List<String> parametersToIgnore = new ImmutableList.Builder().add((Object)"transient_lastDdlTime").add((Object)"totalSize").add((Object)"numFilesErasureCoded").add((Object)"numFiles").build();

    public static String getStringProperty(Map<String, String> params, String key, String defaultVal) {
        if (params == null) {
            return defaultVal;
        }
        return params.getOrDefault(key, defaultVal);
    }

    private static void setTrivialParameters(Map<String, String> parametersBefore, Map<String, String> parametersAfter) {
        for (String parameter : parametersToIgnore) {
            String val = parametersBefore.get(parameter);
            if (val == null) {
                parametersAfter.remove(parameter);
                continue;
            }
            parametersAfter.put(parameter, val);
        }
    }

    public static class IgnoredEvent
    extends MetastoreEvent {
        private IgnoredEvent(CatalogOpExecutor catalogOpExecutor, Metrics metrics, NotificationEvent event) {
            super(catalogOpExecutor, metrics, event);
        }

        @Override
        public void process() {
            this.debugLog("Ignoring unknown event type " + this.metastoreNotificationEvent_.getEventType(), new Object[0]);
        }

        @Override
        protected boolean isEventProcessingDisabled() {
            return false;
        }

        @Override
        protected boolean shouldSkipWhenSyncingToLatestEventId() {
            return false;
        }

        @Override
        protected SelfEventContext getSelfEventContext() {
            throw new UnsupportedOperationException("Self-event evaluation is not needed for this event type");
        }

        @Override
        protected boolean onFailure(Exception e) {
            return false;
        }
    }

    public static class CommitCompactionEvent
    extends MetastoreTableEvent {
        private String partitionName_;

        CommitCompactionEvent(CatalogOpExecutor catalogOpExecutor, Metrics metrics, NotificationEvent event) throws MetastoreNotificationException {
            super(catalogOpExecutor, metrics, event);
            Preconditions.checkState((boolean)this.getEventType().equals((Object)MetastoreEventType.COMMIT_COMPACTION));
            Preconditions.checkNotNull((Object)event.getMessage());
            try {
                this.partitionName_ = MetastoreShim.getPartitionNameFromCommitCompactionEvent(event);
            }
            catch (Exception ex) {
                this.warnLog("Unable to parse commit compaction message: {}", ex.getMessage());
            }
        }

        @Override
        protected void processTableEvent() throws MetastoreNotificationException {
            try {
                if (this.partitionName_ == null) {
                    boolean notSkipped = this.reloadTableFromCatalog("Commit Compaction event", true);
                    if (!notSkipped) {
                        this.metrics_.getCounter("events-skipped").inc();
                    }
                } else {
                    this.reloadPartitionsFromNames(Arrays.asList(this.partitionName_), "Commit compaction event", FileMetadataLoadOpts.FORCE_LOAD);
                }
            }
            catch (CatalogException e) {
                throw new MetastoreNotificationNeedsInvalidateException(this.debugString("Failed to commit compaction for the table {}. Event processing cannot continue. Issue an invalidate metadata command to reset event processor.", this.tblName_), e);
            }
        }

        @Override
        protected SelfEventContext getSelfEventContext() {
            throw new UnsupportedOperationException("Self-event evaluation is not needed for this event type");
        }

        @Override
        protected boolean isEventProcessingDisabled() {
            Table tbl = this.catalog_.getTableNoThrow(this.dbName_, this.tblName_);
            if (tbl != null && tbl.getCreateEventId() < this.getEventId()) {
                this.msTbl_ = tbl.getMetaStoreTable();
            }
            if (this.msTbl_ == null) {
                return false;
            }
            return super.isEventProcessingDisabled();
        }
    }

    public static class AbortTxnEvent
    extends MetastoreEvent {
        private final long txnId_;
        private Set<TableWriteId> tableWriteIds_ = Collections.emptySet();

        AbortTxnEvent(CatalogOpExecutor catalogOpExecutor, Metrics metrics, NotificationEvent event) {
            super(catalogOpExecutor, metrics, event);
            Preconditions.checkState((boolean)this.getEventType().equals((Object)MetastoreEventType.ABORT_TXN));
            Preconditions.checkNotNull((Object)event.getMessage());
            AbortTxnMessage abortTxnMessage = MetastoreEventsProcessor.getMessageDeserializer().getAbortTxnMessage(event.getMessage());
            this.txnId_ = abortTxnMessage.getTxnId();
            this.infoLog("Received AbortTxnEvent for transaction " + this.txnId_, new Object[0]);
        }

        @Override
        protected void process() throws MetastoreNotificationException {
            try {
                this.tableWriteIds_ = this.catalog_.getWriteIds(this.txnId_);
                this.infoLog("Adding {} aborted write ids", this.tableWriteIds_.size());
                this.addAbortedWriteIdsToTables(this.tableWriteIds_);
            }
            catch (CatalogException e) {
                throw new MetastoreNotificationNeedsInvalidateException(this.debugString("Failed to mark aborted write ids to table for txn {}. Event processing cannot continue. Issue an invalidate metadata command to reset event processor.", this.txnId_), e);
            }
            finally {
                this.catalog_.removeWriteIds(this.txnId_);
            }
        }

        @Override
        protected boolean onFailure(Exception e) {
            if (!BackendConfig.INSTANCE.isInvalidateMetadataOnEventProcessFailureEnabled() || !this.canInvalidateTable(e)) {
                return false;
            }
            this.errorLog("Invalidating tables in transaction due to exception during event processing", e);
            Set tableNames = this.tableWriteIds_.stream().map(writeId -> new TableName(writeId.getDbName(), writeId.getTblName())).collect(Collectors.toSet());
            for (TableName tableName : tableNames) {
                this.errorLog("Invalidate table {}.{}", tableName.getDb(), tableName.getTbl());
                this.catalog_.invalidateTableIfExists(tableName.getDb(), tableName.getTbl());
            }
            return true;
        }

        private void addAbortedWriteIdsToTables(Set<TableWriteId> tableWriteIds) throws CatalogException {
            for (TableWriteId tableWriteId : tableWriteIds) {
                this.catalog_.addWriteIdsToTable(tableWriteId.getDbName(), tableWriteId.getTblName(), this.getEventId(), Collections.singletonList(tableWriteId.getWriteId()), MutableValidWriteIdList.WriteIdStatus.ABORTED);
            }
        }

        @Override
        protected boolean isEventProcessingDisabled() {
            return false;
        }

        @Override
        protected SelfEventContext getSelfEventContext() {
            throw new UnsupportedOperationException("Self-event evaluation is not needed for this event type");
        }

        @Override
        protected boolean shouldSkipWhenSyncingToLatestEventId() {
            return false;
        }
    }

    public static class ReloadEvent
    extends MetastoreTableEvent {
        private Partition reloadPartition_;
        private boolean isRefresh_;

        @VisibleForTesting
        ReloadEvent(CatalogOpExecutor catalogOpExecutor, Metrics metrics, NotificationEvent event) throws MetastoreNotificationException {
            super(catalogOpExecutor, metrics, event);
            Preconditions.checkArgument((boolean)MetastoreEventType.RELOAD.equals((Object)this.getEventType()));
            try {
                Map<String, Object> updatedFields = MetastoreShim.getFieldsFromReloadEvent(event);
                this.msTbl_ = (org.apache.hadoop.hive.metastore.api.Table)Preconditions.checkNotNull((Object)updatedFields.get("table"));
                this.reloadPartition_ = (Partition)updatedFields.get("partition");
                this.isRefresh_ = (Boolean)updatedFields.get("isRefresh");
            }
            catch (Exception e) {
                throw new MetastoreNotificationException(this.debugString("Unable to parse reload message", new Object[0]), e);
            }
        }

        @Override
        public SelfEventContext getSelfEventContext() {
            throw new UnsupportedOperationException("Self-event evaluation is unnecessary for this event type");
        }

        @Override
        public void processTableEvent() throws MetastoreNotificationException {
            if (this.isOlderEvent()) {
                this.metrics_.getCounter("events-skipped").inc((long)this.getNumberOfEvents());
                this.infoLog("Incremented events skipped counter to {}", this.metrics_.getCounter("events-skipped").getCount());
                return;
            }
            if (this.isRefresh_) {
                if (this.reloadPartition_ != null) {
                    this.processPartitionReload();
                } else {
                    this.processTableReload();
                }
            } else {
                this.processTableInvalidate();
            }
        }

        private boolean isOlderEvent() {
            Table tbl = this.catalog_.getTableNoThrow(this.dbName_, this.tblName_);
            if (tbl == null || tbl instanceof IncompleteTable) {
                return false;
            }
            return tbl.getLastRefreshEventId() >= this.getEventId() || this.reloadPartition_ != null && this.catalog_.isPartitionLoadedAfterEvent(this.dbName_, this.tblName_, this.reloadPartition_, this.getEventId());
        }

        private void processPartitionReload() throws MetastoreNotificationException {
            Preconditions.checkNotNull((Object)this.reloadPartition_);
            try {
                this.reloadPartitions(Arrays.asList(this.reloadPartition_), FileMetadataLoadOpts.FORCE_LOAD, "RELOAD event", false);
            }
            catch (CatalogException e) {
                throw new MetastoreNotificationNeedsInvalidateException(this.debugString("Refresh partition on table {} partition {} failed. Event processing cannot continue. Issue an invalidate metadata command to reset the event processor state.", this.getFullyQualifiedTblName(), Joiner.on((char)',').join((Iterable)this.reloadPartition_.getValues())), e);
            }
        }

        private void processTableReload() throws MetastoreNotificationException {
            Preconditions.checkState((this.reloadPartition_ == null ? 1 : 0) != 0);
            try {
                boolean notSkipped = this.reloadTableFromCatalog("RELOAD event", false);
                if (!notSkipped) {
                    this.metrics_.getCounter("events-skipped").inc();
                }
            }
            catch (CatalogException e) {
                throw new MetastoreNotificationNeedsInvalidateException(this.debugString("Refresh table {} failed. Event processing cannot continue. Issue an invalidate metadata command to reset the event processor state.", this.getFullyQualifiedTblName()), e);
            }
        }

        private void processTableInvalidate() throws MetastoreNotificationException {
            Reference<Boolean> tblWasRemoved = new Reference<Boolean>();
            Reference<Boolean> dbWasAdded = new Reference<Boolean>();
            Table tbl = null;
            try {
                tbl = this.catalog_.getTable(this.dbName_, this.tblName_);
                if (tbl == null) {
                    this.infoLog("Skipping on table {}.{} since it does not exist in cache", this.dbName_, this.tblName_);
                    this.metrics_.getCounter("events-skipped").inc();
                    return;
                }
                if (tbl instanceof IncompleteTable) {
                    this.infoLog("Skipping on an incomplete table {}", tbl.getFullName());
                    this.metrics_.getCounter("events-skipped").inc();
                    return;
                }
            }
            catch (DatabaseNotFoundException e) {
                this.infoLog("Skipping on table {} because db {} not found in cache", this.tblName_, this.dbName_);
                this.metrics_.getCounter("events-skipped").inc();
                return;
            }
            this.catalog_.invalidateTable(tbl.getTableName().toThrift(), tblWasRemoved, dbWasAdded, NoOpEventSequence.INSTANCE, this.getEventId());
            this.LOG.info("Table " + tbl.getFullName() + " is invalidated from catalog cache");
        }
    }

    public static class AllocWriteIdEvent
    extends MetastoreTableEvent {
        private final List<TxnToWriteId> txnToWriteIdList_;

        private AllocWriteIdEvent(CatalogOpExecutor catalogOpExecutor, Metrics metrics, NotificationEvent event) throws MetastoreNotificationException {
            super(catalogOpExecutor, metrics, event);
            Preconditions.checkState((boolean)this.getEventType().equals((Object)MetastoreEventType.ALLOC_WRITE_ID_EVENT));
            Preconditions.checkNotNull((Object)event.getMessage());
            AllocWriteIdMessage allocWriteIdMessage = MetastoreEventsProcessor.getMessageDeserializer().getAllocWriteIdMessage(event.getMessage());
            this.txnToWriteIdList_ = allocWriteIdMessage.getTxnToWriteIdList();
        }

        @Override
        protected void processTableEvent() throws MetastoreNotificationException {
            Table tbl = this.catalog_.getTableNoThrow(this.dbName_, this.tblName_);
            if (tbl == null) {
                this.debugLog("Ignoring the event since table {} does not exist", this.getFullyQualifiedTblName());
                return;
            }
            try {
                List<Long> writeIds = this.txnToWriteIdList_.stream().map(TxnToWriteId::getWriteId).collect(Collectors.toList());
                this.catalog_.addWriteIdsToTable(this.dbName_, this.tblName_, this.getEventId(), writeIds, MutableValidWriteIdList.WriteIdStatus.OPEN);
                for (TxnToWriteId txnToWriteId : this.txnToWriteIdList_) {
                    TableWriteId tableWriteId = new TableWriteId(this.dbName_, this.tblName_, tbl.getCreateEventId(), txnToWriteId.getWriteId());
                    this.catalog_.addWriteId(txnToWriteId.getTxnId(), tableWriteId);
                    this.infoLog("Added write id {} on table {}.{} for txn {}", txnToWriteId.getWriteId(), this.dbName_, this.tblName_, txnToWriteId.getTxnId());
                }
            }
            catch (CatalogException e) {
                throw new MetastoreNotificationNeedsInvalidateException("Failed to mark open write ids to table. Event processing cannot continue. Issue an invalidate metadata command to reset event processor.", e);
            }
        }

        @Override
        protected SelfEventContext getSelfEventContext() {
            throw new UnsupportedOperationException("self-event evaluation is not needed for this event type");
        }

        @Override
        protected boolean isEventProcessingDisabled() {
            Table tbl = this.catalog_.getTableNoThrow(this.dbName_, this.tblName_);
            if (tbl != null && tbl.getCreateEventId() < this.getEventId()) {
                this.msTbl_ = tbl.getMetaStoreTable();
            }
            if (this.msTbl_ == null) {
                return false;
            }
            return super.isEventProcessingDisabled();
        }
    }

    public static class DropPartitionEvent
    extends MetastoreTableEvent {
        private final List<Map<String, String>> droppedPartitions_;
        public static final String EVENT_TYPE = "DROP_PARTITION";

        private DropPartitionEvent(CatalogOpExecutor catalogOpExecutor, Metrics metrics, NotificationEvent event) throws MetastoreNotificationException {
            super(catalogOpExecutor, metrics, event);
            Preconditions.checkState((boolean)this.getEventType().equals((Object)MetastoreEventType.DROP_PARTITION));
            Preconditions.checkNotNull((Object)event.getMessage());
            DropPartitionMessage dropPartitionMessage = MetastoreEventsProcessor.getMessageDeserializer().getDropPartitionMessage(event.getMessage());
            try {
                this.msTbl_ = (org.apache.hadoop.hive.metastore.api.Table)Preconditions.checkNotNull((Object)dropPartitionMessage.getTableObj());
                this.droppedPartitions_ = dropPartitionMessage.getPartitions();
                Preconditions.checkNotNull(this.droppedPartitions_);
            }
            catch (Exception ex) {
                throw new MetastoreNotificationException(this.debugString("Could not parse event message. Check if %s is set to true in metastore configuration", "hive.metastore.notifications.add.thrift.objects"), ex);
            }
        }

        public List<Map<String, String>> getDroppedPartitions() {
            return this.droppedPartitions_;
        }

        @Override
        public void processTableEvent() throws MetastoreNotificationException, CatalogException {
            if (this.droppedPartitions_.isEmpty()) {
                this.metrics_.getCounter("events-skipped").inc();
                this.infoLog("Partition list is empty. Ignoring this event.", new Object[0]);
                return;
            }
            try {
                boolean incrementalRefresh = BackendConfig.INSTANCE.getHMSEventIncrementalRefreshTransactionalTable();
                if (AcidUtils.isTransactionalTable(this.msTbl_.getParameters()) && !incrementalRefresh || MetaStoreUtils.isMaterializedViewTable((org.apache.hadoop.hive.metastore.api.Table)this.msTbl_)) {
                    boolean notSkipped = this.reloadTableFromCatalog(EVENT_TYPE, true);
                    if (!notSkipped) {
                        this.metrics_.getCounter("events-skipped").inc();
                    }
                } else {
                    int numPartsRemoved = this.catalogOpExecutor_.removePartitionsIfNotAddedLater(this.getEventId(), this.dbName_, this.tblName_, this.droppedPartitions_, EVENT_TYPE);
                    if (numPartsRemoved > 0) {
                        this.infoLog("{} partitions dropped from table {}", numPartsRemoved, this.getFullyQualifiedTblName());
                        this.metrics_.getCounter("partitions-removed").inc((long)numPartsRemoved);
                    } else {
                        this.metrics_.getCounter("events-skipped").inc();
                        this.debugLog("Incremented skipped metric to " + this.metrics_.getCounter("events-skipped").getCount(), new Object[0]);
                    }
                }
            }
            catch (CatalogException e) {
                throw new MetastoreNotificationNeedsInvalidateException(this.debugString("Failed to drop some partitions from table {} after a drop partitions event. Event processing cannot continue. Issue an invalidate metadata command to reset event processor state.", this.getFullyQualifiedTblName()), e);
            }
        }

        @Override
        protected SelfEventContext getSelfEventContext() {
            throw new UnsupportedOperationException("self-event evaluation is not needed for this event type");
        }
    }

    public static class BatchPartitionEvent<T extends MetastoreTableEvent>
    extends MetastoreTableEvent {
        private final T baseEvent_;
        private final List<T> batchedEvents_ = new ArrayList<T>();

        private BatchPartitionEvent(T baseEvent) {
            super(((MetastoreTableEvent)baseEvent).catalogOpExecutor_, ((MetastoreTableEvent)baseEvent).metrics_, ((MetastoreTableEvent)baseEvent).event_);
            this.msTbl_ = ((MetastoreTableEvent)baseEvent).msTbl_;
            this.baseEvent_ = baseEvent;
            this.batchedEvents_.add(baseEvent);
            this.setEventType(((MetastoreEvent)baseEvent).getBatchEventType());
        }

        @Override
        public MetastoreEvent addToBatchEvents(MetastoreEvent event) {
            Preconditions.checkState((boolean)this.canBeBatched(event));
            this.batchedEvents_.add((MetastoreTableEvent)event);
            return this;
        }

        @Override
        public int getNumberOfEvents() {
            return this.batchedEvents_.size();
        }

        @Override
        public long getEventId() {
            Preconditions.checkState((!this.batchedEvents_.isEmpty() ? 1 : 0) != 0);
            return ((MetastoreTableEvent)this.batchedEvents_.get(this.batchedEvents_.size() - 1)).getEventId();
        }

        @Override
        public long getEventTime() {
            Preconditions.checkState((!this.batchedEvents_.isEmpty() ? 1 : 0) != 0);
            return ((MetastoreTableEvent)this.batchedEvents_.get(this.batchedEvents_.size() - 1)).getEventTime();
        }

        @Override
        public boolean canBeBatched(MetastoreEvent event) {
            Preconditions.checkState((!this.batchedEvents_.isEmpty() ? 1 : 0) != 0);
            return ((MetastoreTableEvent)this.batchedEvents_.get(this.batchedEvents_.size() - 1)).canBeBatched(event);
        }

        @VisibleForTesting
        List<T> getBatchEvents() {
            return this.batchedEvents_;
        }

        @Override
        protected void processTableEvent() throws MetastoreNotificationException, CatalogException {
            if (this.isSelfEvent()) {
                this.infoLog("Not processing the event as it is a self-event", new Object[0]);
                return;
            }
            ArrayList<MetastoreTableEvent> eventsToProcess = new ArrayList<MetastoreTableEvent>();
            ArrayList<Partition> partitionEventsToForceReload = new ArrayList<Partition>();
            for (MetastoreTableEvent event : this.batchedEvents_) {
                boolean isTruncateOp;
                if (this.isOlderEvent(event.getPartitionForBatching())) {
                    this.infoLog("Not processing the current event id {} as it is an older event", event.getEventId());
                    continue;
                }
                boolean bl = isTruncateOp = event instanceof AlterPartitionEvent && ((AlterPartitionEvent)event).isTruncateOp_;
                if (isTruncateOp) {
                    partitionEventsToForceReload.add(event.getPartitionForBatching());
                    continue;
                }
                if (event.canBeSkipped()) continue;
                eventsToProcess.add(event);
            }
            int notSkippedNum = eventsToProcess.size() + partitionEventsToForceReload.size();
            int skippedNum = this.batchedEvents_.size() - notSkippedNum;
            if (skippedNum > 0) {
                this.metrics_.getCounter("events-skipped").inc((long)skippedNum);
            }
            if (eventsToProcess.isEmpty() && partitionEventsToForceReload.isEmpty()) {
                this.LOG.info("Ignoring {} events between event id {} and {} since they modify parameters which can be ignored", new Object[]{this.getNumberOfEvents(), this.getFirstEventId(), this.getLastEventId()});
                return;
            }
            if (AcidUtils.isTransactionalTable(this.msTbl_.getParameters())) {
                boolean notSkipped = this.reloadTableFromCatalog(this.getEventType().toString(), true);
                if (!notSkipped) {
                    this.metrics_.getCounter("events-skipped").inc((long)(eventsToProcess.size() + partitionEventsToForceReload.size()));
                }
            } else {
                ArrayList<Partition> partitions = new ArrayList<Partition>();
                for (MetastoreTableEvent event : eventsToProcess) {
                    partitions.add(event.getPartitionForBatching());
                }
                try {
                    if (this.baseEvent_ instanceof InsertEvent) {
                        this.reloadPartitions(partitions, FileMetadataLoadOpts.FORCE_LOAD, this.getEventType().toString() + " event", true);
                    } else {
                        if (!partitionEventsToForceReload.isEmpty()) {
                            this.reloadPartitions(partitionEventsToForceReload, FileMetadataLoadOpts.FORCE_LOAD, this.getEventType().toString() + " event", true);
                        }
                        if (!partitions.isEmpty()) {
                            this.reloadPartitions(partitions, FileMetadataLoadOpts.LOAD_IF_SD_CHANGED, this.getEventType().toString() + " event", true);
                        }
                    }
                }
                catch (CatalogException e) {
                    throw new MetastoreNotificationNeedsInvalidateException(String.format("Refresh partitions on table %s failed when processing a batch of %s events between event ids %s and %s. Issue an invalidate command to reset the event processor state.", this.getFullyQualifiedTblName(), this.getNumberOfEvents(), this.getFirstEventId(), this.getLastEventId()), e);
                }
            }
        }

        private long getFirstEventId() {
            return ((MetastoreTableEvent)this.batchedEvents_.get(0)).getEventId();
        }

        private long getLastEventId() {
            return ((MetastoreTableEvent)this.batchedEvents_.get(this.batchedEvents_.size() - 1)).getEventId();
        }

        @Override
        protected SelfEventContext getSelfEventContext() {
            ArrayList<List<TPartitionKeyValue>> partitionKeyValues = new ArrayList<List<TPartitionKeyValue>>();
            ArrayList<Long> eventIds = new ArrayList<Long>();
            boolean isInsertEvent = this.baseEvent_ instanceof InsertEvent;
            for (MetastoreTableEvent event : this.batchedEvents_) {
                partitionKeyValues.add(BatchPartitionEvent.getTPartitionSpecFromHmsPartition(event.msTbl_, event.getPartitionForBatching()));
                eventIds.add(event.getEventId());
            }
            return new SelfEventContext(this.dbName_, this.tblName_, partitionKeyValues, ((MetastoreTableEvent)this.baseEvent_).getPartitionForBatching().getParameters(), isInsertEvent ? eventIds : null);
        }

        /* synthetic */ BatchPartitionEvent(MetastoreTableEvent x0, 1 x1) {
            this(x0);
        }
    }

    public static class AlterPartitionEvent
    extends MetastoreTableEvent {
        public static final String EVENT_TYPE = "ALTER_PARTITION";
        private final Partition partitionBefore_;
        private final Partition partitionAfter_;
        private final long versionNumberFromEvent_;
        private final String serviceIdFromEvent_;
        private final boolean isTruncateOp_;

        private AlterPartitionEvent(CatalogOpExecutor catalogOpExecutor, Metrics metrics, NotificationEvent event) throws MetastoreNotificationException {
            super(catalogOpExecutor, metrics, event);
            Preconditions.checkState((boolean)this.getEventType().equals((Object)MetastoreEventType.ALTER_PARTITION));
            Preconditions.checkNotNull((Object)event.getMessage());
            AlterPartitionMessage alterPartitionMessage = MetastoreEventsProcessor.getMessageDeserializer().getAlterPartitionMessage(event.getMessage());
            try {
                this.partitionBefore_ = (Partition)Preconditions.checkNotNull((Object)alterPartitionMessage.getPtnObjBefore());
                this.partitionAfter_ = (Partition)Preconditions.checkNotNull((Object)alterPartitionMessage.getPtnObjAfter());
                this.isTruncateOp_ = alterPartitionMessage.getIsTruncateOp();
                this.msTbl_ = alterPartitionMessage.getTableObj();
                Map parameters = this.partitionAfter_.getParameters();
                this.versionNumberFromEvent_ = Long.parseLong(MetastoreEvents.getStringProperty(parameters, MetastoreEventPropertyKey.CATALOG_VERSION.getKey(), "-1"));
                this.serviceIdFromEvent_ = MetastoreEvents.getStringProperty(parameters, MetastoreEventPropertyKey.CATALOG_SERVICE_ID.getKey(), "");
            }
            catch (Exception e) {
                throw new MetastoreNotificationException(this.debugString("Unable to parse the alter partition message", new Object[0]), e);
            }
        }

        @Override
        protected MetastoreEventType getBatchEventType() {
            return MetastoreEventType.ALTER_PARTITIONS;
        }

        @Override
        protected Partition getPartitionForBatching() {
            return this.partitionAfter_;
        }

        @Override
        public boolean canBeBatched(MetastoreEvent event) {
            if (!(event instanceof AlterPartitionEvent)) {
                return false;
            }
            if (this.isOlderThanLastSyncEventId(event)) {
                return false;
            }
            AlterPartitionEvent alterPartitionEvent = (AlterPartitionEvent)event;
            if (!this.getFullyQualifiedTblName().equalsIgnoreCase(alterPartitionEvent.getFullyQualifiedTblName())) {
                return false;
            }
            Map parametersFromEvent = alterPartitionEvent.partitionAfter_.getParameters();
            long versionNumberOfEvent = Long.parseLong(MetastoreEvents.getStringProperty(parametersFromEvent, MetastoreEventPropertyKey.CATALOG_VERSION.getKey(), "-1"));
            String serviceIdOfEvent = MetastoreEvents.getStringProperty(parametersFromEvent, MetastoreEventPropertyKey.CATALOG_SERVICE_ID.getKey(), "");
            return this.versionNumberFromEvent_ == versionNumberOfEvent && this.serviceIdFromEvent_.equals(serviceIdOfEvent);
        }

        @Override
        public MetastoreEvent addToBatchEvents(MetastoreEvent event) {
            if (!(event instanceof AlterPartitionEvent)) {
                return null;
            }
            BatchPartitionEvent batchEvent = new BatchPartitionEvent(this, null);
            Preconditions.checkState((boolean)batchEvent.canBeBatched(event));
            batchEvent.addToBatchEvents(event);
            return batchEvent;
        }

        @Override
        public void processTableEvent() throws MetastoreNotificationException, CatalogException {
            if (this.isSelfEvent()) {
                this.infoLog("Not processing the event as it is a self-event", new Object[0]);
                return;
            }
            if (this.isOlderEvent(this.partitionBefore_)) {
                this.infoLog("Not processing the alter partition event {} as it is an older event", this.getEventId());
                return;
            }
            if (this.canBeSkipped()) {
                this.metrics_.getCounter("events-skipped").inc();
                this.infoLog("Not processing this event as it only modifies some partition parameters which can be ignored.", new Object[0]);
                return;
            }
            if (AcidUtils.isTransactionalTable(this.msTbl_.getParameters()) || MetaStoreUtils.isMaterializedViewTable((org.apache.hadoop.hive.metastore.api.Table)this.msTbl_)) {
                this.reloadTransactionalTable();
            } else {
                Preconditions.checkNotNull((Object)this.partitionAfter_);
                List<TPartitionKeyValue> tPartSpec = AlterPartitionEvent.getTPartitionSpecFromHmsPartition(this.msTbl_, this.partitionAfter_);
                try {
                    FileMetadataLoadOpts fileMetadataLoadOpts = this.isTruncateOp_ ? FileMetadataLoadOpts.FORCE_LOAD : FileMetadataLoadOpts.LOAD_IF_SD_CHANGED;
                    this.reloadPartitions(Arrays.asList(this.partitionAfter_), fileMetadataLoadOpts, "ALTER_PARTITION event", false);
                }
                catch (CatalogException e) {
                    throw new MetastoreNotificationNeedsInvalidateException(this.debugString("Refresh partition on table {} partition {} failed. Event processing cannot continue. Issue an invalidate command to reset the event processor state.", this.getFullyQualifiedTblName(), HdfsTable.constructPartitionName(tPartSpec)), e);
                }
            }
        }

        @Override
        protected boolean canBeSkipped() {
            if (this.isTruncateOp_) {
                return false;
            }
            Partition afterPartition = this.partitionAfter_.deepCopy();
            MetastoreEvents.setTrivialParameters(this.partitionBefore_.getParameters(), afterPartition.getParameters());
            return afterPartition.equals(this.partitionBefore_);
        }

        @Override
        public SelfEventContext getSelfEventContext() {
            return new SelfEventContext(this.dbName_, this.tblName_, Arrays.asList(AlterPartitionEvent.getTPartitionSpecFromHmsPartition(this.msTbl_, this.partitionAfter_)), this.partitionAfter_.getParameters());
        }

        private void reloadTransactionalTable() throws CatalogException {
            boolean incrementalRefresh = BackendConfig.INSTANCE.getHMSEventIncrementalRefreshTransactionalTable();
            if (incrementalRefresh) {
                this.reloadPartitionsFromEvent(Collections.singletonList(this.partitionAfter_), "ALTER_PARTITION EVENT FOR TRANSACTIONAL TABLE");
            } else {
                boolean notSkipped = this.reloadTableFromCatalog(EVENT_TYPE, true);
                if (!notSkipped) {
                    this.metrics_.getCounter("events-skipped").inc();
                }
            }
        }
    }

    public static class AddPartitionEvent
    extends MetastoreTableEvent {
        public static final String EVENT_TYPE = "ADD_PARTITION";
        private final List<Partition> addedPartitions_;
        private final List<List<TPartitionKeyValue>> partitionKeyVals_;

        private AddPartitionEvent(CatalogOpExecutor catalogOpExecutor, Metrics metrics, NotificationEvent event) throws MetastoreNotificationException {
            super(catalogOpExecutor, metrics, event);
            Preconditions.checkState((boolean)this.getEventType().equals((Object)MetastoreEventType.ADD_PARTITION));
            if (event.getMessage() == null) {
                throw new IllegalStateException(this.debugString("Event message is null", new Object[0]));
            }
            try {
                AddPartitionMessage addPartitionMessage_ = MetastoreEventsProcessor.getMessageDeserializer().getAddPartitionMessage(event.getMessage());
                this.addedPartitions_ = Lists.newArrayList((Iterable)addPartitionMessage_.getPartitionObjs());
                this.msTbl_ = addPartitionMessage_.getTableObj();
                MetaStoreUtil.replaceSchemaFromTable(this.addedPartitions_, this.msTbl_);
                this.partitionKeyVals_ = new ArrayList<List<TPartitionKeyValue>>(this.addedPartitions_.size());
                for (Partition part : this.addedPartitions_) {
                    this.partitionKeyVals_.add(AddPartitionEvent.getTPartitionSpecFromHmsPartition(this.msTbl_, part));
                }
            }
            catch (Exception ex) {
                throw new MetastoreNotificationException(ex);
            }
        }

        @Override
        public SelfEventContext getSelfEventContext() {
            if (AcidUtils.isTransactionalTable(this.msTbl_.getParameters())) {
                HashMap<String, String> params = new HashMap<String, String>();
                if (!this.addedPartitions_.isEmpty()) {
                    params.putAll(this.addedPartitions_.get(0).getParameters());
                }
                return new SelfEventContext(this.dbName_, this.tblName_, this.partitionKeyVals_, params);
            }
            throw new UnsupportedOperationException("Self-event evaluation is unnecessary for this event type");
        }

        @Override
        public void processTableEvent() throws MetastoreNotificationException, CatalogException {
            if (this.addedPartitions_.isEmpty()) {
                this.metrics_.getCounter("events-skipped").inc();
                this.infoLog("Partition list is empty. Ignoring this event.", new Object[0]);
                return;
            }
            try {
                boolean incrementalRefresh = BackendConfig.INSTANCE.getHMSEventIncrementalRefreshTransactionalTable();
                if (AcidUtils.isTransactionalTable(this.msTbl_.getParameters()) && !this.isSelfEvent() && !incrementalRefresh || MetaStoreUtils.isMaterializedViewTable((org.apache.hadoop.hive.metastore.api.Table)this.msTbl_)) {
                    boolean notSkipped = this.reloadTableFromCatalog(EVENT_TYPE, true);
                    if (!notSkipped) {
                        this.metrics_.getCounter("events-skipped").inc();
                    }
                } else {
                    int numPartsAdded = this.catalogOpExecutor_.addPartitionsIfNotRemovedLater(this.getEventId(), this.dbName_, this.tblName_, this.addedPartitions_, EVENT_TYPE);
                    if (numPartsAdded != 0) {
                        this.infoLog("Successfully added {} partitions to table {}", numPartsAdded, this.getFullyQualifiedTblName());
                        this.metrics_.getCounter("partitions-added").inc((long)numPartsAdded);
                    } else {
                        this.metrics_.getCounter("events-skipped").inc();
                        this.debugLog("Incremented skipped metric to {} since no partitions were added.", this.metrics_.getCounter("events-skipped").getCount());
                    }
                }
            }
            catch (CatalogException e) {
                throw new MetastoreNotificationNeedsInvalidateException(this.debugString("Failed to refresh newly added partitions of table '%s'. Event processing cannot continue. Issue an invalidate metadata command to reset event processor.", this.getFullyQualifiedTblName()), e);
            }
        }

        public List<Partition> getPartitions() {
            return this.addedPartitions_;
        }
    }

    public static class DropDatabaseEvent
    extends MetastoreDatabaseEvent {
        public static final String EVENT_TYPE = "DROP_DATABASE";
        private final Database droppedDatabase_;

        private DropDatabaseEvent(CatalogOpExecutor catalogOpExecutor, Metrics metrics, NotificationEvent event) throws MetastoreNotificationException {
            super(catalogOpExecutor, metrics, event);
            Preconditions.checkArgument((boolean)MetastoreEventType.DROP_DATABASE.equals((Object)this.getEventType()));
            JSONDropDatabaseMessage dropDatabaseMessage = (JSONDropDatabaseMessage)MetastoreEventsProcessor.getMessageDeserializer().getDropDatabaseMessage(event.getMessage());
            try {
                this.droppedDatabase_ = (Database)Preconditions.checkNotNull((Object)MetastoreShim.getDatabaseObject(dropDatabaseMessage));
            }
            catch (Exception e) {
                throw new MetastoreNotificationException(this.debugString("Database object is null in the event. This could be a metastore configuration problem. Check if %s is set to true in metastore configuration", "hive.metastore.notifications.add.thrift.objects"), e);
            }
        }

        @Override
        public SelfEventContext getSelfEventContext() {
            throw new UnsupportedOperationException("Self-event evaluation is not needed for this event");
        }

        @Override
        protected boolean shouldSkipWhenSyncingToLatestEventId() {
            return false;
        }

        @Override
        public void process() {
            boolean dbRemoved = this.catalogOpExecutor_.removeDbIfNotAddedLater(this.getEventId(), this.droppedDatabase_.getName());
            if (dbRemoved) {
                this.infoLog("Removed Database {} ", this.dbName_);
                this.metrics_.getCounter("databases-removed").inc();
            } else {
                this.metrics_.getCounter("events-skipped").inc();
                this.debugLog("Incremented skipped metric to " + this.metrics_.getCounter("events-skipped").getCount(), new Object[0]);
            }
        }
    }

    public static class AlterDatabaseEvent
    extends MetastoreDatabaseEvent {
        private final Database alteredDatabase_;

        private AlterDatabaseEvent(CatalogOpExecutor catalogOpExecutor, Metrics metrics, NotificationEvent event) throws MetastoreNotificationException {
            super(catalogOpExecutor, metrics, event);
            Preconditions.checkArgument((boolean)MetastoreEventType.ALTER_DATABASE.equals((Object)this.getEventType()));
            JSONAlterDatabaseMessage alterDatabaseMessage = (JSONAlterDatabaseMessage)MetastoreEventsProcessor.getMessageDeserializer().getAlterDatabaseMessage(event.getMessage());
            try {
                this.alteredDatabase_ = (Database)Preconditions.checkNotNull((Object)alterDatabaseMessage.getDbObjAfter());
            }
            catch (Exception e) {
                throw new MetastoreNotificationException(this.debugString("Unable to parse the alter database message", new Object[0]), e);
            }
        }

        @Override
        public void process() throws CatalogException {
            if (this.isSelfEvent()) {
                this.infoLog("Not processing the event as it is a self-event", new Object[0]);
                return;
            }
            Preconditions.checkNotNull((Object)this.alteredDatabase_);
            if (!this.catalogOpExecutor_.alterDbIfExists(this.getEventId(), this.alteredDatabase_)) {
                this.debugLog("Update database {} failed as the database is not present in the catalog.", this.alteredDatabase_.getName());
            } else {
                this.infoLog("Database {} updated after alter database event id {}", this.alteredDatabase_.getName(), this.getEventId());
            }
        }

        @Override
        protected SelfEventContext getSelfEventContext() {
            return new SelfEventContext(this.dbName_, null, this.alteredDatabase_.getParameters());
        }

        @Override
        protected boolean shouldSkipWhenSyncingToLatestEventId() throws CatalogException {
            Preconditions.checkState((boolean)BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls(), (Object)"sync to latest event id flag should be set");
            long eventId = this.getEventId();
            Db db = this.catalog_.getDb(this.getDbName());
            if (db == null) {
                this.infoLog("Skipping since db {} does not exist in cache", this.getDbName());
                return true;
            }
            if (!this.catalog_.tryLockDb(db)) {
                throw new CatalogException(String.format("Couldn't acquire lock on db %s", db.getName()));
            }
            this.catalog_.getLock().writeLock().unlock();
            boolean shouldSkip = false;
            if (db.getLastSyncedEventId() >= eventId) {
                this.infoLog("Skipping on db {} since db is already synced till event id {}", this.getDbName(), db.getLastSyncedEventId());
                shouldSkip = true;
            }
            db.getLock().unlock();
            return shouldSkip;
        }
    }

    public static class CreateDatabaseEvent
    extends MetastoreDatabaseEvent {
        public static final String EVENT_TYPE = "CREATE_DATABASE";
        private final Database createdDatabase_;

        private CreateDatabaseEvent(CatalogOpExecutor catalogOpExecutor, Metrics metrics, NotificationEvent event) throws MetastoreNotificationException {
            super(catalogOpExecutor, metrics, event);
            Preconditions.checkArgument((boolean)MetastoreEventType.CREATE_DATABASE.equals((Object)this.getEventType()));
            JSONCreateDatabaseMessage createDatabaseMessage = (JSONCreateDatabaseMessage)MetastoreEventsProcessor.getMessageDeserializer().getCreateDatabaseMessage(event.getMessage());
            try {
                this.createdDatabase_ = (Database)Preconditions.checkNotNull((Object)createDatabaseMessage.getDatabaseObject());
            }
            catch (Exception e) {
                throw new MetastoreNotificationException(this.debugString("Database object is null in the event. This could be a metastore configuration problem. Check if %s is set to true in metastore configuration", "hive.metastore.notifications.add.thrift.objects"), e);
            }
        }

        public Database getDatabase() {
            return this.createdDatabase_;
        }

        @Override
        public SelfEventContext getSelfEventContext() {
            throw new UnsupportedOperationException("Self-event evaluation is unnecessary for this event type");
        }

        @Override
        public void process() {
            boolean dbAdded = this.catalogOpExecutor_.addDbIfNotRemovedLater(this.getEventId(), this.createdDatabase_);
            if (!dbAdded) {
                this.debugLog("Database {} was not added since it either exists or was removed since the event was generated", this.dbName_);
                this.metrics_.getCounter("events-skipped").inc();
                this.debugLog("Incremented skipped metric to " + this.metrics_.getCounter("events-skipped").getCount(), new Object[0]);
            } else {
                this.infoLog("Successfully added database {}", this.dbName_);
                this.metrics_.getCounter("databases-added").inc();
            }
        }
    }

    public static class DropTableEvent
    extends MetastoreTableEvent {
        public static final String EVENT_TYPE = "DROP_TABLE";

        private DropTableEvent(CatalogOpExecutor catalogOpExecutor, Metrics metrics, NotificationEvent event) throws MetastoreNotificationException {
            super(catalogOpExecutor, metrics, event);
            Preconditions.checkArgument((boolean)MetastoreEventType.DROP_TABLE.equals((Object)this.getEventType()));
            JSONDropTableMessage dropTableMessage = (JSONDropTableMessage)MetastoreEventsProcessor.getMessageDeserializer().getDropTableMessage(event.getMessage());
            try {
                this.msTbl_ = (org.apache.hadoop.hive.metastore.api.Table)Preconditions.checkNotNull((Object)dropTableMessage.getTableObj());
            }
            catch (Exception e) {
                throw new MetastoreNotificationException(this.debugString("Could not parse event message. Check if %s is set to true in metastore configuration", "hive.metastore.notifications.add.thrift.objects"), e);
            }
        }

        @Override
        public SelfEventContext getSelfEventContext() {
            throw new UnsupportedOperationException("self-event evaluation is not needed for this event type");
        }

        @Override
        public void processTableEvent() throws MetastoreNotificationException {
            Reference<Boolean> tblRemovedLater = new Reference<Boolean>();
            boolean removedTable = this.catalogOpExecutor_.removeTableIfNotAddedLater(this.getEventId(), this.msTbl_.getDbName(), this.msTbl_.getTableName(), tblRemovedLater);
            if (removedTable) {
                this.infoLog("Successfully removed table {}", this.getFullyQualifiedTblName());
                this.metrics_.getCounter("tables-removed").inc();
            } else {
                this.metrics_.getCounter("events-skipped").inc();
                this.debugLog("Incremented skipped metric to " + this.metrics_.getCounter("events-skipped").getCount(), new Object[0]);
            }
        }

        @Override
        protected boolean onFailure(Exception e) {
            return false;
        }
    }

    public static class AlterTableEvent
    extends MetastoreTableEvent {
        public static final String EVENT_TYPE = "ALTER_TABLE";
        protected org.apache.hadoop.hive.metastore.api.Table tableBefore_;
        protected org.apache.hadoop.hive.metastore.api.Table tableAfter_;
        protected final boolean isRename_;
        private final Boolean eventSyncBeforeFlag_;
        private final Boolean eventSyncAfterFlag_;
        private final boolean dbFlagVal;
        private final boolean isTruncateOp_;

        @VisibleForTesting
        AlterTableEvent(CatalogOpExecutor catalogOpExecutor, Metrics metrics, NotificationEvent event) throws MetastoreNotificationException {
            super(catalogOpExecutor, metrics, event);
            Preconditions.checkArgument((boolean)MetastoreEventType.ALTER_TABLE.equals((Object)this.getEventType()));
            JSONAlterTableMessage alterTableMessage = (JSONAlterTableMessage)MetastoreEventsProcessor.getMessageDeserializer().getAlterTableMessage(event.getMessage());
            try {
                this.msTbl_ = (org.apache.hadoop.hive.metastore.api.Table)Preconditions.checkNotNull((Object)alterTableMessage.getTableObjBefore());
                this.tableAfter_ = (org.apache.hadoop.hive.metastore.api.Table)Preconditions.checkNotNull((Object)alterTableMessage.getTableObjAfter());
                this.tableBefore_ = (org.apache.hadoop.hive.metastore.api.Table)Preconditions.checkNotNull((Object)alterTableMessage.getTableObjBefore());
                this.isTruncateOp_ = alterTableMessage.getIsTruncateOp();
            }
            catch (Exception e) {
                throw new MetastoreNotificationException(this.debugString("Unable to parse the alter table message", new Object[0]), e);
            }
            this.isRename_ = !this.msTbl_.getDbName().equalsIgnoreCase(this.tableAfter_.getDbName()) || !this.msTbl_.getTableName().equalsIgnoreCase(this.tableAfter_.getTableName());
            this.eventSyncBeforeFlag_ = AlterTableEvent.getHmsSyncProperty(this.msTbl_);
            this.eventSyncAfterFlag_ = AlterTableEvent.getHmsSyncProperty(this.tableAfter_);
            this.dbFlagVal = Boolean.valueOf(this.catalog_.getDbProperty(this.dbName_, MetastoreEventPropertyKey.DISABLE_EVENT_HMS_SYNC.getKey()));
        }

        public boolean isRename() {
            return this.isRename_;
        }

        public org.apache.hadoop.hive.metastore.api.Table getBeforeTable() {
            return this.tableBefore_;
        }

        public org.apache.hadoop.hive.metastore.api.Table getAfterTable() {
            return this.tableAfter_;
        }

        @Override
        protected SelfEventContext getSelfEventContext() {
            return new SelfEventContext(this.tableAfter_.getDbName(), this.tableAfter_.getTableName(), this.tableAfter_.getParameters());
        }

        private void processRename() throws CatalogException {
            if (!this.isRename_) {
                return;
            }
            Reference<Boolean> oldTblRemoved = new Reference<Boolean>();
            Reference<Boolean> newTblAdded = new Reference<Boolean>();
            this.catalogOpExecutor_.renameTableFromEvent(this.getEventId(), this.tableBefore_, this.tableAfter_, oldTblRemoved, newTblAdded);
            if (!oldTblRemoved.getRef().booleanValue() && !newTblAdded.getRef().booleanValue()) {
                this.metrics_.getCounter("events-skipped").inc();
                this.debugLog("Incremented skipped metric to " + this.metrics_.getCounter("events-skipped").getCount(), new Object[0]);
            } else {
                if (oldTblRemoved.getRef().booleanValue()) {
                    this.metrics_.getCounter("tables-removed").inc();
                }
                if (newTblAdded.getRef().booleanValue()) {
                    this.metrics_.getCounter("tables-added").inc();
                }
            }
        }

        @Override
        protected boolean shouldSkipWhenSyncingToLatestEventId() throws CatalogException {
            if (this.isRename_) {
                return false;
            }
            return super.shouldSkipWhenSyncingToLatestEventId();
        }

        @Override
        public void processTableEvent() throws MetastoreNotificationException, CatalogException {
            if (this.isRename_) {
                this.processRename();
                return;
            }
            if (this.isOlderEvent(null)) {
                this.infoLog("Not processing the alter table event {} as it is an older event", this.getEventId());
                return;
            }
            if (this.isSelfEvent()) {
                this.infoLog("Not processing the event as it is a self-event", new Object[0]);
                return;
            }
            if (this.canBeSkipped()) {
                this.metrics_.getCounter("events-skipped").inc();
                this.infoLog("Not processing this event as it only modifies some table parameters which can be ignored.", new Object[0]);
                return;
            }
            this.skipFileMetadataReload_ = !this.isTruncateOp_ && this.canSkipFileMetadataReload(this.tableBefore_, this.tableAfter_);
            long startNs = System.nanoTime();
            if (this.wasEventSyncTurnedOn()) {
                this.handleEventSyncTurnedOn();
            } else {
                boolean notSkipped = this.reloadTableFromCatalog(EVENT_TYPE, false);
                if (!notSkipped) {
                    this.metrics_.getCounter("events-skipped").inc();
                }
            }
            long durationNs = System.nanoTime() - startNs;
            if (durationNs > 5000000000L) {
                this.warnLog("Slow event processing. Duration: {}. TableBefore: {}. TableAfter: {}", PrintUtils.printTimeNs(durationNs), this.tableBefore_.toString(), this.tableAfter_.toString());
            }
        }

        @Override
        protected boolean onFailure(Exception e) {
            if (!BackendConfig.INSTANCE.isInvalidateMetadataOnEventProcessFailureEnabled() || !this.canInvalidateTable(e)) {
                return false;
            }
            if (this.isRename()) {
                this.errorLog("Rename table {}.{} to {}.{} failed due to exception during event processing", this.tableBefore_.getDbName(), this.tableBefore_.getTableName(), this.dbName_, this.tblName_, e);
                return false;
            }
            return super.onFailure(e);
        }

        private void handleEventSyncTurnedOn() throws DatabaseNotFoundException, MetastoreNotificationNeedsInvalidateException {
            Table tbl = this.catalog_.getTableNoThrow(this.dbName_, this.tblName_);
            if (tbl == null) {
                if (this.catalogOpExecutor_.addTableIfNotRemovedLater(this.getEventId(), this.msTbl_)) {
                    this.infoLog("Successfully added table {}", this.getFullyQualifiedTblName());
                    this.metrics_.getCounter("tables-added").inc();
                } else {
                    this.metrics_.getCounter("events-skipped").inc();
                    this.debugLog("Incremented skipped metric to " + this.metrics_.getCounter("events-skipped").getCount(), new Object[0]);
                }
            } else if (!(tbl instanceof IncompleteTable)) {
                if (this.getEventId() > tbl.getCreateEventId()) {
                    this.catalog_.invalidateTable(tbl.getTableName().toThrift(), new Reference<Boolean>(), new Reference<Boolean>(), NoOpEventSequence.INSTANCE, this.getEventId());
                    this.LOG.info("Table " + tbl.getFullName() + " is invalidated from catalog cache since eventSync is turned on for this table.");
                } else {
                    throw new MetastoreNotificationNeedsInvalidateException(this.debugString("Detected that event sync was turned on for the table %s with createEventId %s. This event should have been skipped as stale event. Event processing cannot be continued further. Issue a invalidate metadata command to reset the event processing state", this.getFullyQualifiedTblName(), tbl.getCreateEventId()));
                }
            }
        }

        private boolean canSkipFileMetadataReload(org.apache.hadoop.hive.metastore.api.Table beforeTable, org.apache.hadoop.hive.metastore.api.Table afterTable) {
            boolean unpartitioned;
            Set<String> whitelistedTblProperties = this.catalog_.getWhitelistedTblProperties();
            if (whitelistedTblProperties.isEmpty()) {
                return false;
            }
            boolean incrementalAcidRefresh = BackendConfig.INSTANCE.getHMSEventIncrementalRefreshTransactionalTable();
            boolean bl = unpartitioned = afterTable.getPartitionKeysSize() == 0;
            if (!incrementalAcidRefresh && unpartitioned && AcidUtils.isTransactionalTable(afterTable.getParameters())) {
                return false;
            }
            boolean skipFileMetadata = false;
            if (this.isFieldSchemaChanged(beforeTable, afterTable) || this.isTableOwnerChanged(beforeTable.getOwner(), afterTable.getOwner())) {
                skipFileMetadata = true;
            } else if (!Objects.equals(beforeTable.getSd(), afterTable.getSd())) {
                if (this.isTrivialSdPropsChanged(beforeTable.getSd(), afterTable.getSd())) {
                    skipFileMetadata = true;
                }
            } else if (!this.isCustomTblPropsChanged(whitelistedTblProperties, beforeTable, afterTable)) {
                skipFileMetadata = true;
            }
            return skipFileMetadata;
        }

        private boolean isFieldSchemaChanged(org.apache.hadoop.hive.metastore.api.Table beforeTable, org.apache.hadoop.hive.metastore.api.Table afterTable) {
            List beforeCols = beforeTable.getSd().getCols();
            List afterCols = afterTable.getSd().getCols();
            if (beforeCols.size() != afterCols.size()) {
                this.infoLog("Change in number of columns detected for table {}.{} from {} to {}. So file metadata reload can be skipped.", this.dbName_, this.tblName_, beforeCols.size(), afterCols.size());
                return true;
            }
            for (int i = 0; i < beforeCols.size(); ++i) {
                if (((FieldSchema)beforeCols.get(i)).getName().equals(((FieldSchema)afterCols.get(i)).getName()) && ((FieldSchema)beforeCols.get(i)).getType().equals(((FieldSchema)afterCols.get(i)).getType())) continue;
                this.infoLog("Change in table schema detected for table {}.{} from {} ({}) to {} ({}). So file metadata reload can be skipped.", this.dbName_, this.tblName_, ((FieldSchema)beforeCols.get(i)).getName(), ((FieldSchema)beforeCols.get(i)).getType(), ((FieldSchema)afterCols.get(i)).getName(), ((FieldSchema)afterCols.get(i)).getType());
                return true;
            }
            return false;
        }

        private boolean isTableOwnerChanged(String ownerBefore, String ownerAfter) {
            if (!Objects.equals(ownerBefore, ownerAfter)) {
                this.infoLog("Change in Ownership detected for table {}.{}, oldOwner: {}, newOwner: {}. So file metadata reload can be skipped.", this.dbName_, this.tblName_, ownerBefore, ownerAfter);
                return true;
            }
            return false;
        }

        private boolean isCustomTblPropsChanged(Set<String> whitelistedTblProperties, org.apache.hadoop.hive.metastore.api.Table beforeTable, org.apache.hadoop.hive.metastore.api.Table afterTable) {
            for (String whitelistConfig : whitelistedTblProperties) {
                String configAfter;
                String configBefore = (String)beforeTable.getParameters().get(whitelistConfig);
                if (Objects.equals(configBefore, configAfter = (String)afterTable.getParameters().get(whitelistConfig))) continue;
                this.infoLog("Change in whitelisted table properties detected for table {}.{} whitelisted config: {}, value before: {}, value after: {}. So file metadata should be reloaded.", this.dbName_, this.tblName_, whitelistConfig, configBefore, configAfter);
                return true;
            }
            return false;
        }

        private boolean isTrivialSdPropsChanged(StorageDescriptor beforeSd, StorageDescriptor afterSd) {
            Preconditions.checkNotNull((Object)beforeSd, (Object)"beforeSd is null");
            Preconditions.checkNotNull((Object)afterSd, (Object)"afterSd is null");
            StorageDescriptor previousSD = this.normalizeStorageDescriptor(beforeSd.deepCopy());
            StorageDescriptor currentSD = this.normalizeStorageDescriptor(afterSd.deepCopy());
            if (!Objects.equals(previousSD, currentSD)) {
                this.infoLog("Non-trivial change in table storage descriptor (SD) detected for table {}.{}. So file metadata should be reloaded. SD before: {}, SD after: {}", this.dbName_, this.tblName_, beforeSd.toString(), afterSd.toString());
                return false;
            }
            this.infoLog("Trivial changes in table storage descriptor (SD) detected for table {}.{}. So file metadata reload can be skipped.", this.dbName_, this.tblName_);
            return true;
        }

        private StorageDescriptor normalizeStorageDescriptor(StorageDescriptor sd) {
            sd.unsetCols();
            sd.unsetCompressed();
            sd.unsetNumBuckets();
            sd.unsetBucketCols();
            sd.unsetSortCols();
            sd.unsetSkewedInfo();
            if (!sd.isSetStoredAsSubDirectories()) {
                sd.setStoredAsSubDirectories(false);
            }
            return sd;
        }

        private boolean wasEventSyncTurnedOn() {
            if (Objects.equals(this.eventSyncBeforeFlag_, this.eventSyncAfterFlag_)) {
                return false;
            }
            return this.eventSyncAfterFlag_ == null && !this.dbFlagVal || this.eventSyncAfterFlag_ == false;
        }

        @Override
        protected boolean canBeSkipped() {
            if (this.isTruncateOp_) {
                return false;
            }
            org.apache.hadoop.hive.metastore.api.Table tblAfter = this.tableAfter_.deepCopy();
            MetastoreEvents.setTrivialParameters(this.tableBefore_.getParameters(), tblAfter.getParameters());
            return tblAfter.equals(this.tableBefore_);
        }

        private String qualify(TTableName tTableName) {
            return new TableName(tTableName.db_name, tTableName.table_name).toString();
        }

        @Override
        protected boolean isEventProcessingDisabled() {
            if (!Objects.equals(this.eventSyncBeforeFlag_, this.eventSyncAfterFlag_)) {
                this.infoLog("Before flag value {} after flag value {} changed for table {}", this.eventSyncBeforeFlag_, this.eventSyncAfterFlag_, this.getFullyQualifiedTblName());
                return false;
            }
            return super.isEventProcessingDisabled();
        }
    }

    public static class InsertEvent
    extends MetastoreTableEvent {
        private Partition insertPartition_;

        @VisibleForTesting
        InsertEvent(CatalogOpExecutor catalogOpExecutor, Metrics metrics, NotificationEvent event) throws MetastoreNotificationException {
            super(catalogOpExecutor, metrics, event);
            Preconditions.checkArgument((boolean)MetastoreEventType.INSERT.equals((Object)this.getEventType()));
            InsertMessage insertMessage = MetastoreEventsProcessor.getMessageDeserializer().getInsertMessage(event.getMessage());
            try {
                this.msTbl_ = (org.apache.hadoop.hive.metastore.api.Table)Preconditions.checkNotNull((Object)insertMessage.getTableObj());
                this.insertPartition_ = insertMessage.getPtnObj();
            }
            catch (Exception e) {
                throw new MetastoreNotificationException(this.debugString("Unable to parse insert message", new Object[0]), e);
            }
        }

        @Override
        protected MetastoreEventType getBatchEventType() {
            return MetastoreEventType.INSERT_PARTITIONS;
        }

        @Override
        protected Partition getPartitionForBatching() {
            return this.insertPartition_;
        }

        @Override
        public boolean canBeBatched(MetastoreEvent event) {
            if (!(event instanceof InsertEvent)) {
                return false;
            }
            if (this.isOlderThanLastSyncEventId(event)) {
                return false;
            }
            InsertEvent insertEvent = (InsertEvent)event;
            if (!this.getFullyQualifiedTblName().equalsIgnoreCase(insertEvent.getFullyQualifiedTblName())) {
                return false;
            }
            return this.insertPartition_ != null && insertEvent.insertPartition_ != null;
        }

        @Override
        public MetastoreEvent addToBatchEvents(MetastoreEvent event) {
            if (!(event instanceof InsertEvent)) {
                return null;
            }
            BatchPartitionEvent batchEvent = new BatchPartitionEvent(this, null);
            Preconditions.checkState((boolean)batchEvent.canBeBatched(event));
            batchEvent.addToBatchEvents(event);
            return batchEvent;
        }

        @Override
        public SelfEventContext getSelfEventContext() {
            if (this.insertPartition_ != null) {
                List<TPartitionKeyValue> tPartSpec = InsertEvent.getTPartitionSpecFromHmsPartition(this.msTbl_, this.insertPartition_);
                return new SelfEventContext(this.dbName_, this.tblName_, Arrays.asList(tPartSpec), this.insertPartition_.getParameters(), Arrays.asList(this.getEventId()));
            }
            return new SelfEventContext(this.dbName_, this.tblName_, null, this.msTbl_.getParameters(), Arrays.asList(this.getEventId()));
        }

        @Override
        public void processTableEvent() throws MetastoreNotificationException {
            if (this.isSelfEvent()) {
                this.infoLog("Not processing the insert event as it is a self-event", new Object[0]);
                return;
            }
            if (this.isOlderEvent(this.insertPartition_)) {
                this.infoLog("Not processing the insert event {} as it is an older event", this.getEventId());
                return;
            }
            if (AcidUtils.isTransactionalTable(this.msTbl_.getParameters()) || MetaStoreUtils.isMaterializedViewTable((org.apache.hadoop.hive.metastore.api.Table)this.msTbl_)) {
                this.insertPartition_ = null;
            }
            if (this.insertPartition_ != null) {
                this.processPartitionInserts();
            } else {
                this.processTableInserts();
            }
        }

        private void processPartitionInserts() throws MetastoreNotificationException {
            Preconditions.checkNotNull((Object)this.insertPartition_);
            try {
                this.reloadPartitions(Arrays.asList(this.insertPartition_), FileMetadataLoadOpts.FORCE_LOAD, "INSERT event", false);
            }
            catch (CatalogException e) {
                throw new MetastoreNotificationNeedsInvalidateException(this.debugString("Refresh partition on table {} partition {} failed. Event processing cannot continue. Issue an invalidate metadata command to reset the event processor state.", this.getFullyQualifiedTblName(), Joiner.on((char)',').join((Iterable)this.insertPartition_.getValues())), e);
            }
        }

        private void processTableInserts() throws MetastoreNotificationException {
            Preconditions.checkState((this.insertPartition_ == null ? 1 : 0) != 0);
            try {
                boolean notSkipped = this.reloadTableFromCatalog("INSERT event", false);
                if (!notSkipped) {
                    this.metrics_.getCounter("events-skipped").inc();
                }
            }
            catch (CatalogException e) {
                throw new MetastoreNotificationNeedsInvalidateException(this.debugString("Refresh table {} failed. Event processing cannot continue. Issue an invalidate metadata command to reset the event processor state.", this.getFullyQualifiedTblName()), e);
            }
        }
    }

    public static class CreateTableEvent
    extends MetastoreTableEvent {
        public static final String EVENT_TYPE = "CREATE_TABLE";

        private CreateTableEvent(CatalogOpExecutor catalogOpExecutor, Metrics metrics, NotificationEvent event) throws MetastoreNotificationException {
            super(catalogOpExecutor, metrics, event);
            Preconditions.checkArgument((boolean)MetastoreEventType.CREATE_TABLE.equals((Object)this.getEventType()));
            Preconditions.checkNotNull((Object)event.getMessage(), (Object)this.debugString("Event message is null", new Object[0]));
            CreateTableMessage createTableMessage = MetastoreEventsProcessor.getMessageDeserializer().getCreateTableMessage(event.getMessage());
            try {
                this.msTbl_ = createTableMessage.getTableObj();
            }
            catch (Exception e) {
                throw new MetastoreNotificationException(this.debugString("Unable to deserialize the event message", new Object[0]), e);
            }
        }

        @Override
        public SelfEventContext getSelfEventContext() {
            throw new UnsupportedOperationException("Self-event evaluation is unnecessary for this event type");
        }

        @Override
        public void processTableEvent() throws MetastoreNotificationException {
            try {
                if (this.catalogOpExecutor_.addTableIfNotRemovedLater(this.getEventId(), this.msTbl_)) {
                    this.infoLog("Successfully added table {}", this.getFullyQualifiedTblName());
                    this.metrics_.getCounter("tables-added").inc();
                } else {
                    this.metrics_.getCounter("events-skipped").inc();
                    this.debugLog("Incremented skipped metric to " + this.metrics_.getCounter("events-skipped").getCount(), new Object[0]);
                }
            }
            catch (DatabaseNotFoundException ex) {
                this.errorLog("Create table {}.{} failed because the database does not exist cache. Ignoring the CREATE_TABLE event", this.dbName_, this.tblName_, ex);
            }
            catch (CatalogException e) {
                throw new MetastoreNotificationException(this.debugString("Unable to process event", new Object[0]), e);
            }
        }

        @Override
        protected boolean onFailure(Exception e) {
            return false;
        }

        @Override
        public boolean isRemovedAfter(List<MetastoreEvent> events) {
            Preconditions.checkNotNull(events);
            for (MetastoreEvent event : events) {
                if (event.eventType_.equals((Object)MetastoreEventType.DROP_TABLE)) {
                    DropTableEvent dropTableEvent = (DropTableEvent)event;
                    if (!this.dbName_.equalsIgnoreCase(dropTableEvent.dbName_) || !this.tblName_.equalsIgnoreCase(dropTableEvent.tblName_)) continue;
                    this.infoLog("Found table {} is removed later in event {} type {}", new Object[]{this.tblName_, dropTableEvent.getEventId(), dropTableEvent.getEventType()});
                    return true;
                }
                if (!event.eventType_.equals((Object)MetastoreEventType.ALTER_TABLE)) continue;
                AlterTableEvent alterTableEvent = (AlterTableEvent)event;
                if (!alterTableEvent.isRename_ || !this.dbName_.equalsIgnoreCase(alterTableEvent.msTbl_.getDbName()) || !this.tblName_.equalsIgnoreCase(alterTableEvent.msTbl_.getTableName())) continue;
                this.infoLog("Found table {} is renamed later in event {} type {}", new Object[]{this.tblName_, alterTableEvent.getEventId(), alterTableEvent.getEventType()});
                return true;
            }
            return false;
        }

        public org.apache.hadoop.hive.metastore.api.Table getTable() {
            return this.msTbl_;
        }

        @Override
        protected boolean shouldSkipWhenSyncingToLatestEventId() {
            return false;
        }
    }

    public static abstract class MetastoreDatabaseEvent
    extends MetastoreEvent {
        MetastoreDatabaseEvent(CatalogOpExecutor catalogOpExecutor, Metrics metrics, NotificationEvent event) {
            super(catalogOpExecutor, metrics, event);
            Preconditions.checkNotNull((Object)this.dbName_, (Object)this.debugString("Database name cannot be null", new Object[0]));
            this.debugLog("Creating event {} of type {} on database {}", new Object[]{this.getEventId(), this.getEventType(), this.dbName_});
        }

        @Override
        protected boolean isEventProcessingDisabled() {
            return false;
        }

        @Override
        protected boolean shouldSkipWhenSyncingToLatestEventId() throws CatalogException {
            return false;
        }

        @Override
        protected boolean isSelfEvent() {
            boolean isSelfEvent = super.isSelfEvent();
            if (!isSelfEvent || !BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
                return isSelfEvent;
            }
            Db db = null;
            try {
                db = this.catalog_.getDb(this.getDbName());
                if (db != null && this.catalog_.tryLockDb(db)) {
                    this.catalog_.getLock().writeLock().unlock();
                    if (db.getLastSyncedEventId() < this.getEventId()) {
                        this.infoLog("is a self event. last synced event id for db {} is {}. Setting it to {}", this.getDbName(), db.getLastSyncedEventId(), this.getEventId());
                        db.setLastSyncedEventId(this.getEventId());
                    }
                }
            }
            finally {
                this.catalogOpExecutor_.UnlockWriteLockIfErronouslyLocked();
                if (db != null && db.isLockHeldByCurrentThread()) {
                    db.getLock().unlock();
                }
            }
            return true;
        }

        @Override
        protected boolean onFailure(Exception e) {
            return false;
        }
    }

    public static abstract class MetastoreTableEvent
    extends MetastoreEvent {
        protected final String tblName_;
        protected org.apache.hadoop.hive.metastore.api.Table msTbl_;
        protected boolean skipFileMetadataReload_ = false;

        protected Partition getPartitionForBatching() {
            return null;
        }

        private MetastoreTableEvent(CatalogOpExecutor catalogOpExecutor, Metrics metrics, NotificationEvent event) {
            super(catalogOpExecutor, metrics, event);
            Preconditions.checkNotNull((Object)this.dbName_, (Object)"Database name cannot be null");
            this.tblName_ = (String)Preconditions.checkNotNull((Object)event.getTableName());
        }

        protected String getFullyQualifiedTblName() {
            return new TableName(this.dbName_, this.tblName_).toString();
        }

        @Override
        protected boolean isEventProcessingDisabled() {
            Preconditions.checkNotNull((Object)this.msTbl_);
            Boolean tblProperty = MetastoreTableEvent.getHmsSyncProperty(this.msTbl_);
            if (tblProperty != null) {
                this.infoLog("Found table level flag {} is set to {} for table {}", MetastoreEventPropertyKey.DISABLE_EVENT_HMS_SYNC.getKey(), tblProperty.toString(), this.getFullyQualifiedTblName());
                return tblProperty;
            }
            String dbFlagVal = this.catalog_.getDbProperty(this.dbName_, MetastoreEventPropertyKey.DISABLE_EVENT_HMS_SYNC.getKey());
            if (dbFlagVal != null) {
                this.debugLog("Table level flag is not set. Db level flag {} is {} for database {}", MetastoreEventPropertyKey.DISABLE_EVENT_HMS_SYNC.getKey(), dbFlagVal, this.dbName_);
            }
            return Boolean.valueOf(dbFlagVal);
        }

        public static Boolean getHmsSyncProperty(org.apache.hadoop.hive.metastore.api.Table tbl) {
            if (!tbl.isSetParameters()) {
                return null;
            }
            String val = (String)tbl.getParameters().get(MetastoreEventPropertyKey.DISABLE_EVENT_HMS_SYNC.getKey());
            if (val == null || val.isEmpty()) {
                return null;
            }
            return Boolean.valueOf(val);
        }

        protected static List<TPartitionKeyValue> getTPartitionSpecFromHmsPartition(org.apache.hadoop.hive.metastore.api.Table msTbl, Partition partition) {
            ArrayList<TPartitionKeyValue> tPartSpec = new ArrayList<TPartitionKeyValue>();
            List fsList = msTbl.getPartitionKeys();
            List partVals = partition.getValues();
            Preconditions.checkNotNull((Object)partVals);
            Preconditions.checkState((fsList.size() == partVals.size() ? 1 : 0) != 0);
            for (int i = 0; i < fsList.size(); ++i) {
                tPartSpec.add(new TPartitionKeyValue(((FieldSchema)fsList.get(i)).getName(), (String)partVals.get(i)));
            }
            return tPartSpec;
        }

        protected boolean reloadTableFromCatalog(String operation, boolean isTransactional) throws CatalogException {
            try {
                if (!this.catalog_.reloadTableIfExists(this.dbName_, this.tblName_, "Processing " + operation + " event from HMS", this.getEventId(), this.skipFileMetadataReload_)) {
                    this.debugLog("Automatic refresh on table {} failed as the table either does not exist anymore or is not in loaded state.", this.getFullyQualifiedTblName());
                    return false;
                }
            }
            catch (DatabaseNotFoundException | TableLoadingException e) {
                this.debugLog("Table {} was not refreshed due to error {}", this.getFullyQualifiedTblName(), e.getMessage());
                return false;
            }
            String tblStr = isTransactional ? "transactional table" : "table";
            this.infoLog("Refreshed {} {}", tblStr, this.getFullyQualifiedTblName());
            this.metrics_.getCounter("tables-refreshed").inc();
            return true;
        }

        protected void reloadPartitions(List<Partition> partitions, FileMetadataLoadOpts fileMetadataLoadOpts, String reason, boolean batch) throws CatalogException {
            int skippedEvent = batch ? partitions.size() : 1;
            try {
                int numPartsRefreshed = this.catalogOpExecutor_.reloadPartitionsIfExist(this.getEventId(), this.getEventType().toString(), this.dbName_, this.tblName_, partitions, reason, fileMetadataLoadOpts);
                if (numPartsRefreshed > 0) {
                    this.metrics_.getCounter("partitions-refreshed").inc((long)numPartsRefreshed);
                } else if (numPartsRefreshed == -1) {
                    this.debugLog("Ignoring the event since table {} is not loadded or table was removed latter in catalog or table is synced.", this.getFullyQualifiedTblName());
                    this.metrics_.getCounter("events-skipped").inc((long)skippedEvent);
                }
            }
            catch (TableNotLoadedException e) {
                this.debugLog("Ignoring the event since table {} is not loaded", this.getFullyQualifiedTblName());
                this.metrics_.getCounter("events-skipped").inc((long)skippedEvent);
            }
            catch (DatabaseNotFoundException | TableNotFoundException e) {
                this.debugLog("Ignoring the event since table {} is not found", this.getFullyQualifiedTblName());
                this.metrics_.getCounter("events-skipped").inc((long)skippedEvent);
            }
        }

        protected void reloadPartitionsFromEvent(List<Partition> partitions, String reason) throws CatalogException {
            try {
                int numPartsRefreshed = this.catalogOpExecutor_.reloadPartitionsFromEvent(this.getEventId(), this.dbName_, this.tblName_, partitions, reason);
                if (numPartsRefreshed > 0) {
                    this.metrics_.getCounter("partitions-refreshed").inc((long)numPartsRefreshed);
                } else if (numPartsRefreshed == -1) {
                    this.metrics_.getCounter("events-skipped").inc();
                }
            }
            catch (TableNotLoadedException e) {
                this.debugLog("Ignoring the event since table {} is not loaded", this.getFullyQualifiedTblName());
                this.metrics_.getCounter("events-skipped").inc();
            }
            catch (DatabaseNotFoundException | TableNotFoundException e) {
                this.debugLog("Ignoring the event since table {} is not found", this.getFullyQualifiedTblName());
                this.metrics_.getCounter("events-skipped").inc();
            }
        }

        protected void reloadPartitionsFromNames(List<String> partitionNames, String reason, FileMetadataLoadOpts fileMetadataLoadOpts) throws CatalogException {
            try {
                int numPartsRefreshed = this.catalogOpExecutor_.reloadPartitionsFromNamesIfExists(this.getEventId(), this.getEventType().toString(), this.dbName_, this.tblName_, partitionNames, reason, fileMetadataLoadOpts);
                if (numPartsRefreshed > 0) {
                    this.metrics_.getCounter("partitions-refreshed").inc((long)numPartsRefreshed);
                } else if (numPartsRefreshed == -1) {
                    this.metrics_.getCounter("events-skipped").inc();
                }
            }
            catch (TableNotLoadedException e) {
                this.debugLog("Ignoring the event since table {} is not loaded", this.getFullyQualifiedTblName());
                this.metrics_.getCounter("events-skipped").inc();
            }
            catch (DatabaseNotFoundException | TableNotFoundException e) {
                this.debugLog("Ignoring the event since table {} is not found", this.getFullyQualifiedTblName());
                this.metrics_.getCounter("events-skipped").inc();
            }
        }

        @Override
        protected boolean shouldSkipWhenSyncingToLatestEventId() throws CatalogException {
            Preconditions.checkState((boolean)BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls(), (Object)"sync to latest event flag is not set to true");
            long eventId = this.getEventId();
            Preconditions.checkState((eventId > 0L ? 1 : 0) != 0, (String)"Invalid event id %s. Should be greater than 0", (long)eventId);
            Table tbl = null;
            try {
                tbl = this.catalog_.getTable(this.dbName_, this.tblName_);
                if (tbl == null) {
                    this.infoLog("Skipping on table {}.{} since it does not exist in cache", this.dbName_, this.tblName_);
                    return true;
                }
                if (tbl instanceof IncompleteTable && tbl.getLastSyncedEventId() == -1L) {
                    this.infoLog("Skipping on an incomplete table {} since last synced event id is set to {}", tbl.getFullName(), tbl.getLastSyncedEventId());
                    return true;
                }
            }
            catch (DatabaseNotFoundException e) {
                this.infoLog("Skipping on table {} because db {} not found in cache", this.tblName_, this.dbName_);
                return true;
            }
            boolean shouldSkip = false;
            if (tbl.getLastSyncedEventId() >= eventId) {
                this.infoLog("Skipping on table {} since it is already synced till event id {}", tbl.getFullName(), tbl.getLastSyncedEventId());
                shouldSkip = true;
            }
            return shouldSkip;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean isSelfEvent() {
            boolean isSelfEvent = super.isSelfEvent();
            if (!isSelfEvent || !BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls()) {
                return isSelfEvent;
            }
            Table tbl = null;
            try {
                tbl = this.catalog_.getTable(this.getDbName(), this.getTableName());
                if (tbl != null && this.catalog_.tryWriteLock(tbl)) {
                    this.catalog_.getLock().writeLock().unlock();
                    if (tbl.getLastSyncedEventId() < this.getEventId()) {
                        this.infoLog("is a self event. last synced event id for table {} is {}. Setting it to {}", tbl.getFullName(), tbl.getLastSyncedEventId(), this.getEventId());
                        tbl.setLastSyncedEventId(this.getEventId());
                    }
                }
            }
            catch (CatalogException e) {
                this.debugLog("ignoring exception when trying to set latest event for a self event on table {}.{}", this.getDbName(), this.getTableName(), e);
            }
            finally {
                this.catalogOpExecutor_.UnlockWriteLockIfErronouslyLocked();
                if (tbl != null && tbl.isWriteLockedByCurrentThread()) {
                    tbl.releaseWriteLock();
                }
            }
            return true;
        }

        protected boolean isOlderEvent(Partition partitionEventObj) {
            if (!BackendConfig.INSTANCE.enableSkippingOlderEvents()) {
                return false;
            }
            Table tbl = null;
            try {
                tbl = this.catalog_.getTable(this.dbName_, this.tblName_);
                if (tbl == null || tbl instanceof IncompleteTable) {
                    return false;
                }
                if (this.getEventId() > 0L && this.getEventId() <= tbl.getCreateEventId()) {
                    this.metrics_.getCounter("events-skipped").inc();
                    this.infoLog("Table: {} createEventId: {} is >= to the current eventId: {}. Incremented skipped metric to {}", tbl.getFullName(), tbl.getCreateEventId(), this.getEventId(), this.metrics_.getCounter("events-skipped").getCount());
                    return true;
                }
                if (tbl.getLastRefreshEventId() > this.getEventId() || partitionEventObj != null && this.catalog_.isPartitionLoadedAfterEvent(this.dbName_, this.tblName_, partitionEventObj, this.getEventId())) {
                    this.metrics_.getCounter("events-skipped").inc((long)this.getNumberOfEvents());
                    String messageStr = partitionEventObj == null ? "Skipping the event since the table " + this.dbName_ + "." + this.tblName_ + " has last refresh id as " + tbl.getLastRefreshEventId() + ". Comparing it with current event " + this.getEventId() + ". " : "";
                    this.infoLog("{}Incremented events skipped counter to {}", messageStr, this.metrics_.getCounter("events-skipped").getCount());
                    return true;
                }
            }
            catch (CatalogException e) {
                this.debugLog("ignoring exception while checking if it is an older event on table {}.{}", this.dbName_, this.tblName_, e);
            }
            return false;
        }

        @Override
        protected void process() throws MetastoreNotificationException, CatalogException {
            Timer.Context context = null;
            Table tbl = this.catalog_.getTableNoThrow(this.dbName_, this.tblName_);
            if (tbl != null) {
                context = tbl.getMetrics().getTimer("events-process-duration").time();
            }
            try {
                this.processTableEvent();
            }
            finally {
                if (context != null) {
                    context.stop();
                }
            }
        }

        @Override
        protected boolean onFailure(Exception e) {
            if (!BackendConfig.INSTANCE.isInvalidateMetadataOnEventProcessFailureEnabled()) {
                return false;
            }
            boolean isInvalidate = this.canInvalidateTable(e);
            if (isInvalidate) {
                this.errorLog("Invalidate table {}.{} due to exception during event processing", this.dbName_, this.tblName_, e);
                this.catalog_.invalidateTableIfExists(this.dbName_, this.tblName_);
            }
            return isInvalidate;
        }

        protected abstract void processTableEvent() throws MetastoreNotificationException, CatalogException;
    }

    public static abstract class MetastoreEvent {
        private static final String STR_FORMAT_EVENT_ID_TYPE = "EventId: %d EventType: %s ";
        private static final String LOG_FORMAT_EVENT_ID_TYPE = "EventId: {} EventType: {} ";
        protected final CatalogServiceCatalog catalog_;
        protected final CatalogOpExecutor catalogOpExecutor_;
        protected final NotificationEvent event_;
        protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
        protected final String catalogName_;
        protected final String dbName_;
        protected final String tblName_;
        private long eventId_;
        private MetastoreEventType eventType_;
        protected final NotificationEvent metastoreNotificationEvent_;
        protected final Metrics metrics_;

        protected MetastoreEvent(CatalogOpExecutor catalogOpExecutor, Metrics metrics, NotificationEvent event) {
            this.catalogOpExecutor_ = catalogOpExecutor;
            this.catalog_ = this.catalogOpExecutor_.getCatalog();
            this.event_ = event;
            this.eventId_ = this.event_.getEventId();
            this.eventType_ = MetastoreEventType.from(event.getEventType());
            this.catalogName_ = event.getCatName();
            this.dbName_ = event.getDbName();
            this.tblName_ = event.getTableName();
            this.metastoreNotificationEvent_ = event;
            this.metrics_ = metrics;
        }

        public long getEventId() {
            return this.eventId_;
        }

        public long getEventTime() {
            return this.event_.getEventTime();
        }

        public MetastoreEventType getEventType() {
            return this.eventType_;
        }

        public void setEventType(MetastoreEventType type) {
            this.eventType_ = type;
        }

        public String getCatalogName() {
            return this.catalogName_;
        }

        public String getDbName() {
            return this.dbName_;
        }

        public String getTableName() {
            return this.tblName_;
        }

        public String getTargetName() {
            if (this.dbName_ == null && this.tblName_ == null) {
                return "CLUSTER_WIDE";
            }
            if (this.tblName_ == null) {
                return this.dbName_;
            }
            return this.dbName_ + "." + this.tblName_;
        }

        private void injectErrorIfNeeded() {
            double random;
            if (this.catalog_.getFailureEventsForTesting().contains(this.eventType_.toString()) && (random = Math.random()) < BackendConfig.INSTANCE.getProcessEventFailureRatio()) {
                throw new RuntimeException("Event processing failed due to error injection");
            }
        }

        public void processIfEnabled() throws CatalogException, MetastoreNotificationException {
            if (this.isEventProcessingDisabled()) {
                this.infoLog("Skipping this event because of flag evaluation", new Object[0]);
                this.metrics_.getCounter("events-skipped").inc();
                this.debugLog("Incremented skipped metric to " + this.metrics_.getCounter("events-skipped").getCount(), new Object[0]);
                return;
            }
            if (BackendConfig.INSTANCE.enableSyncToLatestEventOnDdls() && this.shouldSkipWhenSyncingToLatestEventId()) {
                this.metrics_.getCounter("events-skipped").inc();
                return;
            }
            DebugUtils.executeDebugAction(BackendConfig.INSTANCE.debugActions(), "catalogd_event_processing_delay");
            this.process();
            this.injectErrorIfNeeded();
        }

        protected boolean canBeBatched(MetastoreEvent event) {
            return false;
        }

        protected MetastoreEvent addToBatchEvents(MetastoreEvent event) {
            return null;
        }

        protected int getNumberOfEvents() {
            return 1;
        }

        protected boolean canBeSkipped() {
            return false;
        }

        protected MetastoreEventType getBatchEventType() {
            return null;
        }

        protected abstract boolean shouldSkipWhenSyncingToLatestEventId() throws CatalogException;

        protected abstract void process() throws MetastoreNotificationException, CatalogException;

        protected abstract boolean onFailure(Exception var1);

        protected boolean canInvalidateTable(Exception e) {
            if (e instanceof MetastoreClientInstantiationException) {
                return false;
            }
            return e instanceof RuntimeException || e instanceof CatalogException || e instanceof MetastoreNotificationNeedsInvalidateException;
        }

        protected String debugString(String msgFormatString, Object ... args) {
            String formatString = STR_FORMAT_EVENT_ID_TYPE + msgFormatString;
            Object[] formatArgs = this.getLogFormatArgs(args);
            return String.format(formatString, formatArgs);
        }

        private Object[] getLogFormatArgs(Object[] args) {
            Object[] formatArgs = new Object[args.length + 2];
            formatArgs[0] = this.getEventId();
            formatArgs[1] = this.getEventType();
            int i = 2;
            Object[] objectArray = args;
            int n = objectArray.length;
            for (int j = 0; j < n; ++j) {
                Object arg;
                formatArgs[i] = arg = objectArray[j];
                ++i;
            }
            return formatArgs;
        }

        protected void infoLog(String logFormattedStr, Object ... args) {
            if (!this.LOG.isInfoEnabled()) {
                return;
            }
            String formatString = LOG_FORMAT_EVENT_ID_TYPE + logFormattedStr;
            Object[] formatArgs = this.getLogFormatArgs(args);
            this.LOG.info(formatString, formatArgs);
        }

        protected void debugLog(String logFormattedStr, Object ... args) {
            if (!this.LOG.isDebugEnabled()) {
                return;
            }
            String formatString = LOG_FORMAT_EVENT_ID_TYPE + logFormattedStr;
            Object[] formatArgs = this.getLogFormatArgs(args);
            this.LOG.debug(formatString, formatArgs);
        }

        protected void traceLog(String logFormattedStr, Object ... args) {
            if (!this.LOG.isTraceEnabled()) {
                return;
            }
            String formatString = LOG_FORMAT_EVENT_ID_TYPE + logFormattedStr;
            Object[] formatArgs = this.getLogFormatArgs(args);
            this.LOG.trace(formatString, formatArgs);
        }

        protected void warnLog(String logFormattedStr, Object ... args) {
            if (!this.LOG.isWarnEnabled()) {
                return;
            }
            String formatString = LOG_FORMAT_EVENT_ID_TYPE + logFormattedStr;
            Object[] formatArgs = this.getLogFormatArgs(args);
            this.LOG.warn(formatString, formatArgs);
        }

        protected void errorLog(String logFormattedStr, Object ... args) {
            if (!this.LOG.isErrorEnabled()) {
                return;
            }
            String formatString = LOG_FORMAT_EVENT_ID_TYPE + logFormattedStr;
            Object[] formatArgs = this.getLogFormatArgs(args);
            this.LOG.error(formatString, formatArgs);
        }

        protected boolean isRemovedAfter(List<MetastoreEvent> events) {
            return false;
        }

        protected abstract boolean isEventProcessingDisabled();

        protected abstract SelfEventContext getSelfEventContext();

        protected boolean isSelfEvent() {
            try {
                if (this.catalog_.evaluateSelfEvent(this.getSelfEventContext())) {
                    this.metrics_.getCounter("events-skipped").inc((long)this.getNumberOfEvents());
                    this.infoLog("Incremented events skipped counter to {}", this.metrics_.getCounter("events-skipped").getCount());
                    return true;
                }
            }
            catch (CatalogException e) {
                this.debugLog("Received exception {}. Ignoring self-event evaluation", e.getMessage());
            }
            return false;
        }

        public final boolean isDropEvent() {
            return this instanceof DropTableEvent || this instanceof DropDatabaseEvent || this instanceof DropPartitionEvent;
        }

        public String toString() {
            return String.format(STR_FORMAT_EVENT_ID_TYPE, new Object[]{this.eventId_, this.eventType_});
        }

        protected boolean isOlderThanLastSyncEventId(MetastoreEvent event) {
            Table tbl = this.catalog_.getTableNoThrow(this.dbName_, this.tblName_);
            return tbl != null && tbl.getLastSyncedEventId() >= event.getEventId();
        }
    }

    public static class EventFactoryForSyncToLatestEvent
    extends MetastoreEventFactory {
        private static final Logger LOG = LoggerFactory.getLogger(MetastoreEventFactory.class);

        public EventFactoryForSyncToLatestEvent(CatalogOpExecutor catalogOpExecutor) {
            super(catalogOpExecutor);
        }

        @Override
        public MetastoreEvent get(NotificationEvent event, Metrics metrics) throws MetastoreNotificationException {
            Preconditions.checkNotNull((Object)event.getEventType());
            MetastoreEventType metastoreEventType = MetastoreEventType.from(event.getEventType());
            switch (metastoreEventType) {
                case ALTER_DATABASE: {
                    return new AlterDatabaseEvent(this.catalogOpExecutor_, metrics, event){

                        @Override
                        protected boolean isSelfEvent() {
                            return false;
                        }
                    };
                }
                case ALTER_TABLE: {
                    return new AlterTableEvent(this.catalogOpExecutor_, metrics, event){

                        @Override
                        protected boolean isSelfEvent() {
                            return false;
                        }
                    };
                }
                case ADD_PARTITION: {
                    return new AddPartitionEvent(this.catalogOpExecutor_, metrics, event){

                        @Override
                        public boolean isSelfEvent() {
                            return false;
                        }
                    };
                }
                case ALTER_PARTITION: {
                    return new AlterPartitionEvent(this.catalogOpExecutor_, metrics, event){

                        @Override
                        public boolean isSelfEvent() {
                            return false;
                        }
                    };
                }
                case DROP_PARTITION: {
                    return new DropPartitionEvent(this.catalogOpExecutor_, metrics, event){

                        @Override
                        public boolean isSelfEvent() {
                            return false;
                        }
                    };
                }
                case INSERT: {
                    return new InsertEvent(this.catalogOpExecutor_, metrics, event){

                        @Override
                        public boolean isSelfEvent() {
                            return false;
                        }
                    };
                }
            }
            return super.get(event, metrics);
        }
    }

    public static class MetastoreEventFactory
    implements EventFactory {
        private static final Logger LOG = LoggerFactory.getLogger(MetastoreEventFactory.class);
        protected final CatalogServiceCatalog catalog_;
        protected final CatalogOpExecutor catalogOpExecutor_;
        private static MetastoreEventFactory INSTANCE = null;

        public MetastoreEventFactory(CatalogOpExecutor catalogOpExecutor) {
            this.catalogOpExecutor_ = (CatalogOpExecutor)Preconditions.checkNotNull((Object)catalogOpExecutor);
            this.catalog_ = (CatalogServiceCatalog)Preconditions.checkNotNull((Object)catalogOpExecutor.getCatalog());
        }

        @Override
        public MetastoreEvent get(NotificationEvent event, Metrics metrics) throws MetastoreNotificationException {
            Preconditions.checkNotNull((Object)event.getEventType());
            MetastoreEventType metastoreEventType = MetastoreEventType.from(event.getEventType());
            if (BackendConfig.INSTANCE.getHMSEventIncrementalRefreshTransactionalTable()) {
                switch (metastoreEventType) {
                    case ALLOC_WRITE_ID_EVENT: {
                        return new AllocWriteIdEvent(this.catalogOpExecutor_, metrics, event);
                    }
                    case COMMIT_TXN: {
                        return new MetastoreShim.CommitTxnEvent(this.catalogOpExecutor_, metrics, event);
                    }
                    case ABORT_TXN: {
                        return new AbortTxnEvent(this.catalogOpExecutor_, metrics, event);
                    }
                }
            }
            switch (metastoreEventType) {
                case CREATE_TABLE: {
                    return new CreateTableEvent(this.catalogOpExecutor_, metrics, event);
                }
                case DROP_TABLE: {
                    return new DropTableEvent(this.catalogOpExecutor_, metrics, event);
                }
                case ALTER_TABLE: {
                    return new AlterTableEvent(this.catalogOpExecutor_, metrics, event);
                }
                case CREATE_DATABASE: {
                    return new CreateDatabaseEvent(this.catalogOpExecutor_, metrics, event);
                }
                case DROP_DATABASE: {
                    return new DropDatabaseEvent(this.catalogOpExecutor_, metrics, event);
                }
                case ALTER_DATABASE: {
                    return new AlterDatabaseEvent(this.catalogOpExecutor_, metrics, event);
                }
                case ADD_PARTITION: {
                    return new AddPartitionEvent(this.catalogOpExecutor_, metrics, event);
                }
                case DROP_PARTITION: {
                    return new DropPartitionEvent(this.catalogOpExecutor_, metrics, event);
                }
                case ALTER_PARTITION: {
                    return new AlterPartitionEvent(this.catalogOpExecutor_, metrics, event);
                }
                case RELOAD: {
                    return new ReloadEvent(this.catalogOpExecutor_, metrics, event);
                }
                case INSERT: {
                    return new InsertEvent(this.catalogOpExecutor_, metrics, event);
                }
                case COMMIT_COMPACTION: {
                    return new CommitCompactionEvent(this.catalogOpExecutor_, metrics, event);
                }
            }
            return new IgnoredEvent(this.catalogOpExecutor_, metrics, event);
        }

        List<MetastoreEvent> getFilteredEvents(List<NotificationEvent> events, Metrics metrics) throws MetastoreNotificationException {
            Preconditions.checkNotNull(events);
            if (events.isEmpty()) {
                return Collections.emptyList();
            }
            if (StringUtils.isNotEmpty((CharSequence)BackendConfig.INSTANCE.debugActions())) {
                DebugUtils.executeDebugAction(BackendConfig.INSTANCE.debugActions(), "catalogd_get_filtered_events_delay");
            }
            ArrayList<MetastoreEvent> metastoreEvents = new ArrayList<MetastoreEvent>(events.size());
            for (NotificationEvent event : events) {
                metastoreEvents.add(this.get(event, metrics));
            }
            int sizeBefore = metastoreEvents.size();
            int numFilteredEvents = 0;
            int i = 0;
            while (i < metastoreEvents.size()) {
                MetastoreEvent currentEvent = (MetastoreEvent)metastoreEvents.get(i);
                String catalogName = currentEvent.getCatalogName();
                String eventDb = currentEvent.getDbName();
                String eventTbl = currentEvent.getTableName();
                if (catalogName != null && !MetastoreShim.isDefaultCatalog(catalogName)) {
                    LOG.debug(currentEvent.debugString("Filtering out this event since it is on a non-default hive catalog %s", catalogName));
                    metastoreEvents.remove(i);
                    ++numFilteredEvents;
                    continue;
                }
                if (eventDb != null && this.catalog_.isBlacklistedDb(eventDb) || eventTbl != null && this.catalog_.isBlacklistedTable(eventDb, eventTbl)) {
                    String blacklistedObject = eventTbl != null ? new TableName(eventDb, eventTbl).toString() : eventDb;
                    LOG.info(currentEvent.debugString("Filtering out this event since it is on a blacklisted database or table %s", blacklistedObject));
                    metastoreEvents.remove(i);
                    ++numFilteredEvents;
                    continue;
                }
                ++i;
            }
            LOG.info(String.format("Total number of events received: %d Total number of events filtered out: %d", sizeBefore, numFilteredEvents));
            if (numFilteredEvents > 0) {
                metrics.getCounter("events-skipped").inc((long)numFilteredEvents);
                LOG.debug("Incremented skipped metric to " + metrics.getCounter("events-skipped").getCount());
            }
            return this.createBatchEvents(metastoreEvents, metrics);
        }

        void flushBatchesForDb(Map<String, Map<String, MetastoreEvent>> pendingTableEventsMap, TreeMap<Long, MetastoreEvent> sortedFinalBatches, String dbName) {
            String lowerDbName = dbName.toLowerCase();
            Map<String, MetastoreEvent> dbMap = pendingTableEventsMap.get(lowerDbName);
            if (dbMap != null) {
                for (MetastoreEvent event : dbMap.values()) {
                    sortedFinalBatches.put(event.getEventId(), event);
                }
                pendingTableEventsMap.remove(lowerDbName);
            }
        }

        void flushBatchForTable(Map<String, Map<String, MetastoreEvent>> pendingTableEventsMap, TreeMap<Long, MetastoreEvent> sortedFinalBatches, org.apache.hadoop.hive.metastore.api.Table table) {
            MetastoreEvent tableEvent;
            String dbName = table.getDbName().toLowerCase();
            String tableName = table.getTableName().toLowerCase();
            Map<String, MetastoreEvent> dbMap = pendingTableEventsMap.get(dbName);
            if (dbMap != null && (tableEvent = dbMap.get(tableName)) != null) {
                sortedFinalBatches.put(tableEvent.getEventId(), tableEvent);
                dbMap.remove(tableName);
                if (dbMap.isEmpty()) {
                    pendingTableEventsMap.remove(dbName);
                }
            }
        }

        void cutBatchesForCrossTableEvents(MetastoreEvent event, Map<String, Map<String, MetastoreEvent>> pendingTableEventsMap, TreeMap<Long, MetastoreEvent> sortedFinalBatches) {
            AlterTableEvent alterTable;
            if (event instanceof DropDatabaseEvent || event instanceof AlterDatabaseEvent) {
                this.flushBatchesForDb(pendingTableEventsMap, sortedFinalBatches, event.getDbName());
            } else if (event instanceof AlterTableEvent && (alterTable = (AlterTableEvent)event).isRename()) {
                org.apache.hadoop.hive.metastore.api.Table beforeTable = alterTable.getBeforeTable();
                this.flushBatchForTable(pendingTableEventsMap, sortedFinalBatches, beforeTable);
                org.apache.hadoop.hive.metastore.api.Table afterTable = alterTable.getAfterTable();
                this.flushBatchForTable(pendingTableEventsMap, sortedFinalBatches, afterTable);
            }
        }

        @VisibleForTesting
        List<MetastoreEvent> createBatchEvents(List<MetastoreEvent> events, Metrics metrics) {
            if (events.size() < 2) {
                return events;
            }
            HashMap<String, Map<String, MetastoreEvent>> pendingTableEventsMap = new HashMap<String, Map<String, MetastoreEvent>>();
            TreeMap<Long, MetastoreEvent> sortedFinalBatches = new TreeMap<Long, MetastoreEvent>();
            for (MetastoreEvent next : events) {
                this.cutBatchesForCrossTableEvents(next, pendingTableEventsMap, sortedFinalBatches);
                if (!(next instanceof MetastoreTableEvent)) {
                    sortedFinalBatches.put(next.getEventId(), next);
                    continue;
                }
                String dbName = next.getDbName().toLowerCase();
                String tableName = next.getTableName().toLowerCase();
                Map dbMap = pendingTableEventsMap.computeIfAbsent(dbName, k -> new HashMap());
                MetastoreEvent current = (MetastoreEvent)dbMap.get(tableName);
                if (current != null) {
                    if (!current.canBeBatched(next)) {
                        sortedFinalBatches.put(current.getEventId(), current);
                        dbMap.put(tableName, next);
                        continue;
                    }
                    dbMap.put(tableName, Preconditions.checkNotNull((Object)current.addToBatchEvents(next)));
                    continue;
                }
                dbMap.put(tableName, next);
            }
            for (Map dbMap : pendingTableEventsMap.values()) {
                for (MetastoreEvent event : dbMap.values()) {
                    sortedFinalBatches.put(event.getEventId(), event);
                }
            }
            ArrayList<MetastoreEvent> batchedEventList = new ArrayList<MetastoreEvent>(sortedFinalBatches.values());
            for (MetastoreEvent event : batchedEventList) {
                if (event.getNumberOfEvents() <= 1) continue;
                Preconditions.checkState((boolean)(event instanceof BatchPartitionEvent));
                BatchPartitionEvent batchEvent = (BatchPartitionEvent)event;
                batchEvent.infoLog("Created a batch event for {} events between {} and {}", batchEvent.getNumberOfEvents(), batchEvent.getFirstEventId(), batchEvent.getLastEventId());
                metrics.getCounter("batch-events-created").inc();
            }
            return batchedEventList;
        }
    }

    public static enum MetastoreEventType {
        CREATE_TABLE("CREATE_TABLE"),
        DROP_TABLE("DROP_TABLE"),
        ALTER_TABLE("ALTER_TABLE"),
        CREATE_DATABASE("CREATE_DATABASE"),
        DROP_DATABASE("DROP_DATABASE"),
        ALTER_DATABASE("ALTER_DATABASE"),
        ADD_PARTITION("ADD_PARTITION"),
        ALTER_PARTITION("ALTER_PARTITION"),
        ALTER_PARTITIONS("ALTER_PARTITIONS"),
        DROP_PARTITION("DROP_PARTITION"),
        INSERT("INSERT"),
        INSERT_PARTITIONS("INSERT_PARTITIONS"),
        RELOAD("RELOAD"),
        ALLOC_WRITE_ID_EVENT("ALLOC_WRITE_ID_EVENT"),
        COMMIT_TXN("COMMIT_TXN"),
        ABORT_TXN("ABORT_TXN"),
        COMMIT_COMPACTION("COMMIT_COMPACTION_EVENT"),
        OTHER("OTHER");

        private final String eventType_;

        private MetastoreEventType(String msEventType) {
            this.eventType_ = msEventType;
        }

        public String toString() {
            return this.eventType_;
        }

        public static MetastoreEventType from(String eventType) {
            for (MetastoreEventType metastoreEventType : MetastoreEventType.values()) {
                if (!metastoreEventType.eventType_.equalsIgnoreCase(eventType)) continue;
                return metastoreEventType;
            }
            return OTHER;
        }
    }

    public static enum MetastoreEventPropertyKey {
        CATALOG_VERSION("impala.events.catalogVersion"),
        CATALOG_SERVICE_ID("impala.events.catalogServiceId"),
        DISABLE_EVENT_HMS_SYNC("impala.disableHmsSync");

        private String key_;

        private MetastoreEventPropertyKey(String key) {
            this.key_ = key;
        }

        public String getKey() {
            return this.key_;
        }
    }
}

