/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.events;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hadoop.util.StringUtils;
import org.apache.impala.catalog.events.ConfigValidator;
import org.apache.impala.catalog.events.MetastoreEvents;

public class EventPropertyRegexValidator
implements ConfigValidator {
    private final String configKey_;

    public EventPropertyRegexValidator(String configKey) {
        this.configKey_ = (String)Preconditions.checkNotNull((Object)configKey);
    }

    @Override
    public ConfigValidator.ValidationResult validate(String filterRegex) {
        List<String> excludePatterns = Arrays.asList(StringUtils.getTrimmedStrings((String)filterRegex));
        Predicate<String> paramsFilter = EventPropertyRegexValidator.compilePatternsToPredicates(excludePatterns).stream().reduce(Predicate::or).orElse(x -> false);
        for (MetastoreEvents.MetastoreEventPropertyKey param : MetastoreEvents.MetastoreEventPropertyKey.values()) {
            if (!paramsFilter.test(param.getKey())) continue;
            return new ConfigValidator.ValidationResult(false, String.format("Failed config validation. Required Impala parameter %s is filtered out using the Hive configuration %s=%s", param.getKey(), this.configKey_, filterRegex));
        }
        return new ConfigValidator.ValidationResult(true, null);
    }

    @Override
    public String getConfigKey() {
        return this.configKey_;
    }

    private static List<Predicate<String>> compilePatternsToPredicates(List<String> patterns) {
        return patterns.stream().map(pattern -> Pattern.compile(pattern).asPredicate()).collect(Collectors.toList());
    }
}

