/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.events;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.apache.impala.catalog.events.ConfigValidator;

public class DefaultConfigValidator
implements ConfigValidator {
    private final String CONFIG_VALIDATION_ERROR_MSG = "Unexpected configuration value for %s in Hive Metastore. Expected: %s Found: %s";
    private final String CONFIG_UNAVAILABLE_ERROR_MSG = "Configuration key %s unavailable in Hive Metastore. Expected value: %s";
    private final String expectedValue_;
    private final String configKey_;

    public DefaultConfigValidator(String configKey, String expectedConfigValue) {
        this.expectedValue_ = (String)Preconditions.checkNotNull((Object)expectedConfigValue);
        this.configKey_ = (String)Preconditions.checkNotNull((Object)configKey);
    }

    @Override
    public ConfigValidator.ValidationResult validate(String configValue) {
        if (this.expectedValue_.equalsIgnoreCase(configValue)) {
            return new ConfigValidator.ValidationResult(true, null);
        }
        if (StringUtils.isBlank((CharSequence)configValue)) {
            return new ConfigValidator.ValidationResult(false, String.format("Configuration key %s unavailable in Hive Metastore. Expected value: %s", this.configKey_, this.expectedValue_));
        }
        return new ConfigValidator.ValidationResult(false, String.format("Unexpected configuration value for %s in Hive Metastore. Expected: %s Found: %s", this.configKey_, this.expectedValue_, configValue));
    }

    @Override
    public String getConfigKey() {
        return this.configKey_;
    }

    public String toString() {
        return String.format("Config : %s, Expected Value : %s", this.configKey_, this.expectedValue_);
    }
}

