/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog.events;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;

public interface ConfigValidator {
    public ValidationResult validate(String var1);

    public String getConfigKey();

    @Immutable
    public static class ValidationResult {
        private final boolean valid_;
        private final String reason_;

        public ValidationResult(boolean valid, String reason) {
            Preconditions.checkArgument((valid || reason != null ? 1 : 0) != 0, (Object)"Must include a reason if the validation result is false");
            this.valid_ = valid;
            this.reason_ = reason;
        }

        public boolean isValid() {
            return this.valid_;
        }

        public String getReason() {
            Preconditions.checkState((!this.valid_ ? 1 : 0) != 0);
            return this.reason_;
        }
    }
}

