/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.impala.analysis.TableName;
import org.apache.impala.catalog.ArrayType;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.FeDb;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.SqlConstraints;
import org.apache.impala.catalog.StructField;
import org.apache.impala.catalog.StructType;
import org.apache.impala.thrift.TCatalogObjectType;
import org.apache.impala.thrift.TImpalaTableType;
import org.apache.impala.util.AcidUtils;

public abstract class VirtualTable
implements FeTable {
    protected final Table msTable_;
    protected final FeDb db_;
    protected final String name_;
    protected final String owner_;
    protected final List<Column> colsByPos_ = new ArrayList<Column>();
    protected final Map<String, Column> colsByName_ = new HashMap<String, Column>();
    protected int numClusteringCols_ = 0;
    protected final ArrayType type_ = new ArrayType(new StructType());

    public VirtualTable(Table msTable, FeDb db, String name, String owner) {
        this.msTable_ = msTable;
        this.db_ = db;
        this.name_ = name;
        this.owner_ = owner;
    }

    protected void addColumn(Column col) {
        this.colsByPos_.add(col);
        this.colsByName_.put(col.getName().toLowerCase(), col);
        ((StructType)this.type_.getItemType()).addField(new StructField(col.getName(), col.getType(), col.getComment()));
    }

    @Override
    public String getTableComment() {
        return null;
    }

    @Override
    public boolean isLoaded() {
        return true;
    }

    @Override
    public Table getMetaStoreTable() {
        return this.msTable_;
    }

    @Override
    public String getStorageHandlerClassName() {
        return null;
    }

    @Override
    public TCatalogObjectType getCatalogObjectType() {
        return TCatalogObjectType.TABLE;
    }

    @Override
    public TImpalaTableType getTableType() {
        return TImpalaTableType.TABLE;
    }

    @Override
    public FeDb getDb() {
        return this.db_;
    }

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public String getFullName() {
        return (this.db_ != null ? this.db_.getName() + "." : "") + this.name_;
    }

    @Override
    public TableName getTableName() {
        return new TableName(this.db_ != null ? this.db_.getName() : null, this.name_);
    }

    @Override
    public List<Column> getColumns() {
        return this.colsByPos_;
    }

    @Override
    public List<Column> getColumnsInHiveOrder() {
        ArrayList columns = Lists.newArrayList(this.getNonClusteringColumns());
        if (this.getMetaStoreTable() != null && AcidUtils.isFullAcidTable(this.getMetaStoreTable().getParameters())) {
            Preconditions.checkState((boolean)((Column)columns.get(0)).getName().equals("row__id"));
            columns.remove(0);
        }
        columns.addAll(this.getClusteringColumns());
        return Collections.unmodifiableList(columns);
    }

    @Override
    public List<Column> getClusteringColumns() {
        return Collections.unmodifiableList(this.colsByPos_.subList(0, this.numClusteringCols_));
    }

    @Override
    public List<Column> getNonClusteringColumns() {
        return Collections.unmodifiableList(this.colsByPos_.subList(this.numClusteringCols_, this.colsByPos_.size()));
    }

    @Override
    public List<String> getColumnNames() {
        return Column.toColumnNames(this.colsByPos_);
    }

    @Override
    public SqlConstraints getSqlConstraints() {
        return null;
    }

    @Override
    public int getNumClusteringCols() {
        return this.numClusteringCols_;
    }

    @Override
    public boolean isClusteringColumn(Column c) {
        return c.getPosition() < this.numClusteringCols_;
    }

    @Override
    public Column getColumn(String name) {
        return this.colsByName_.get(name.toLowerCase());
    }

    @Override
    public ArrayType getType() {
        return this.type_;
    }

    @Override
    public long getWriteId() {
        return 0L;
    }

    @Override
    public ValidWriteIdList getValidWriteIds() {
        return null;
    }

    @Override
    public String getOwnerUser() {
        return this.owner_;
    }
}

