/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.Type;
import org.apache.impala.thrift.TColumn;
import org.apache.impala.thrift.TVirtualColumnType;

public class VirtualColumn
extends Column {
    private final TVirtualColumnType virtualColType_;
    public static VirtualColumn INPUT_FILE_NAME = new VirtualColumn("INPUT__FILE__NAME", (Type)Type.STRING, TVirtualColumnType.INPUT_FILE_NAME);
    public static VirtualColumn FILE_POSITION = new VirtualColumn("FILE__POSITION", (Type)Type.BIGINT, TVirtualColumnType.FILE_POSITION);
    public static VirtualColumn PARTITION_SPEC_ID = new VirtualColumn("PARTITION__SPEC__ID", (Type)Type.INT, TVirtualColumnType.PARTITION_SPEC_ID);
    public static VirtualColumn ICEBERG_PARTITION_SERIALIZED = new VirtualColumn("ICEBERG__PARTITION__SERIALIZED", (Type)Type.BINARY, TVirtualColumnType.ICEBERG_PARTITION_SERIALIZED);
    public static VirtualColumn ICEBERG_DATA_SEQUENCE_NUMBER = new VirtualColumn("ICEBERG__DATA__SEQUENCE__NUMBER", (Type)Type.BIGINT, TVirtualColumnType.ICEBERG_DATA_SEQUENCE_NUMBER);

    public static VirtualColumn getVirtualColumn(TVirtualColumnType virtColType) {
        switch (virtColType) {
            case INPUT_FILE_NAME: {
                return INPUT_FILE_NAME;
            }
            case FILE_POSITION: {
                return FILE_POSITION;
            }
            case PARTITION_SPEC_ID: {
                return PARTITION_SPEC_ID;
            }
            case ICEBERG_PARTITION_SERIALIZED: {
                return ICEBERG_PARTITION_SERIALIZED;
            }
            case ICEBERG_DATA_SEQUENCE_NUMBER: {
                return ICEBERG_DATA_SEQUENCE_NUMBER;
            }
        }
        return null;
    }

    public TVirtualColumnType getVirtualColumnType() {
        return this.virtualColType_;
    }

    private VirtualColumn(String name, Type type, TVirtualColumnType virtualColType) {
        super(name.toLowerCase(), type, 0);
        this.virtualColType_ = virtualColType;
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    public static VirtualColumn fromThrift(TColumn columnDesc) {
        Preconditions.checkState((boolean)columnDesc.isSetVirtual_column_type());
        return new VirtualColumn(columnDesc.getColumnName(), Type.fromThrift(columnDesc.getColumnType()), columnDesc.getVirtual_column_type());
    }

    @Override
    public TColumn toThrift() {
        TColumn colDesc = super.toThrift();
        colDesc.setVirtual_column_type(this.virtualColType_);
        return colDesc;
    }
}

