/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.impala.analysis.Parser;
import org.apache.impala.analysis.QueryStmt;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.FeView;
import org.apache.impala.catalog.Table;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TCatalogObjectType;
import org.apache.impala.thrift.TImpalaTableType;
import org.apache.impala.thrift.TTable;
import org.apache.impala.thrift.TTableDescriptor;
import org.apache.impala.thrift.TTableStats;
import org.apache.impala.thrift.TTableType;
import org.apache.impala.util.EventSequence;

public class View
extends Table
implements FeView {
    private QueryStmt queryStmt_;
    private final boolean isLocalView_;
    private List<String> colLabels_;

    public View(org.apache.hadoop.hive.metastore.api.Table msTable, Db db, String name, String owner) {
        super(msTable, db, name, owner);
        this.isLocalView_ = false;
    }

    public View(String alias, QueryStmt queryStmt, List<String> colLabels) {
        super(null, null, alias, null);
        this.isLocalView_ = true;
        this.queryStmt_ = queryStmt;
        this.colLabels_ = colLabels;
    }

    private View(Db db, String name, QueryStmt queryStmt) {
        super(null, db, name, null);
        this.isLocalView_ = false;
        this.queryStmt_ = queryStmt;
        this.colLabels_ = null;
    }

    @Override
    public void load(boolean reuseMetadata, IMetaStoreClient client, org.apache.hadoop.hive.metastore.api.Table msTbl, String reason, EventSequence catalogTimeline) throws TableLoadingException {
        try {
            Table.LOADING_TABLES.incrementAndGet();
            this.clearColumns();
            this.msTable_ = msTbl;
            List fieldSchemas = client.getFields(this.db_.getName(), this.name_);
            for (int i = 0; i < fieldSchemas.size(); ++i) {
                FieldSchema s = (FieldSchema)fieldSchemas.get(i);
                Type type = this.parseColumnType(s);
                Column col = new Column(s.getName(), type, s.getComment(), i);
                this.addColumn(col);
            }
            this.numClusteringCols_ = 0;
            this.tableStats_ = new TTableStats(-1L);
            this.tableStats_.setTotal_file_bytes(-1L);
            this.queryStmt_ = View.parseViewDef(this);
            this.refreshLastUsedTime();
        }
        catch (TableLoadingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TableLoadingException("Failed to load metadata for view: " + this.name_, e);
        }
        finally {
            Table.LOADING_TABLES.decrementAndGet();
        }
    }

    @Override
    protected void loadFromThrift(TTable t) throws TableLoadingException {
        super.loadFromThrift(t);
        this.queryStmt_ = View.parseViewDef(this);
    }

    public static QueryStmt parseViewDef(FeView view) throws TableLoadingException {
        StatementBase node;
        String inlineViewDef = view.getMetaStoreTable().getViewExpandedText();
        try {
            node = Parser.parse(inlineViewDef);
        }
        catch (AnalysisException e) {
            throw new TableLoadingException(String.format("Failed to parse view-definition statement of view: %s", view.getFullName()));
        }
        if (!(node instanceof QueryStmt)) {
            throw new TableLoadingException(String.format("View definition of %s is not a query statement", view.getFullName()));
        }
        return (QueryStmt)node;
    }

    @Override
    public TCatalogObjectType getCatalogObjectType() {
        return TCatalogObjectType.VIEW;
    }

    @Override
    public QueryStmt getQueryStmt() {
        return this.queryStmt_;
    }

    @Override
    public boolean isLocalView() {
        return this.isLocalView_;
    }

    @Override
    public TImpalaTableType getTableType() {
        return TImpalaTableType.VIEW;
    }

    public List<String> getOriginalColLabels() {
        return this.colLabels_;
    }

    @Override
    public List<String> getColLabels() {
        if (this.colLabels_ == null) {
            return null;
        }
        if (this.colLabels_.size() >= this.queryStmt_.getColLabels().size()) {
            return this.colLabels_;
        }
        ArrayList explicitColLabels = Lists.newArrayList(this.colLabels_);
        explicitColLabels.addAll(this.queryStmt_.getColLabels().subList(this.colLabels_.size(), this.queryStmt_.getColLabels().size()));
        return explicitColLabels;
    }

    @Override
    public TTableDescriptor toThriftDescriptor(int tableId, Set<Long> referencedPartitions) {
        throw new IllegalStateException("Cannot call toThriftDescriptor() on a view.");
    }

    @Override
    public TTable toThrift() {
        TTable view = super.toThrift();
        view.setTable_type(TTableType.VIEW);
        return view;
    }

    public static View createTestView(Db db, String name, QueryStmt viewDefStmt) {
        return new View(db, name, viewDefStmt);
    }
}

