/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;

public enum TypeCompatibility {
    UNSAFE,
    DEFAULT,
    STRICT_DECIMAL,
    STRICT,
    ALL_STRICT;


    public static TypeCompatibility applyStrictDecimal(TypeCompatibility compatibility) {
        switch (compatibility) {
            case DEFAULT: 
            case STRICT_DECIMAL: {
                return STRICT_DECIMAL;
            }
            case STRICT: 
            case ALL_STRICT: {
                return ALL_STRICT;
            }
            case UNSAFE: {
                return UNSAFE;
            }
        }
        Preconditions.checkState((boolean)false);
        return compatibility;
    }

    public boolean isDefault() {
        return this.equals((Object)DEFAULT);
    }

    public boolean isUnsafe() {
        return this.equals((Object)UNSAFE);
    }

    public boolean isStrict() {
        return this.equals((Object)STRICT) || this.equals((Object)ALL_STRICT);
    }

    public boolean isStrictDecimal() {
        return this.equals((Object)STRICT_DECIMAL) || this.equals((Object)ALL_STRICT);
    }
}

