/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.impala.catalog.StructField;
import org.apache.impala.catalog.Type;
import org.apache.impala.thrift.TColumnType;
import org.apache.impala.thrift.TStructField;
import org.apache.impala.thrift.TTypeNode;
import org.apache.impala.thrift.TTypeNodeType;

public class StructType
extends Type {
    private final Map<String, StructField> fieldMap_ = new HashMap<String, StructField>();
    private final List<StructField> fields_;

    public StructType(List<StructField> fields) {
        Preconditions.checkNotNull(fields);
        this.fields_ = fields;
        for (int i = 0; i < this.fields_.size(); ++i) {
            this.fields_.get(i).setPosition(i);
            this.fieldMap_.put(this.fields_.get(i).getName().toLowerCase(), this.fields_.get(i));
        }
    }

    public StructType() {
        this.fields_ = new ArrayList<StructField>();
    }

    @Override
    public String toSql(int depth) {
        if (depth >= MAX_NESTING_DEPTH) {
            return "STRUCT<...>";
        }
        ArrayList<String> fieldsSql = new ArrayList<String>();
        for (StructField f : this.fields_) {
            fieldsSql.add(f.toSql(depth + 1));
        }
        return String.format("STRUCT<%s>", Joiner.on((String)",").join(fieldsSql));
    }

    @Override
    protected String prettyPrint(int lpad) {
        String leftPadding = StringUtils.repeat((char)' ', (int)lpad);
        ArrayList<String> fieldsSql = new ArrayList<String>();
        for (StructField f : this.fields_) {
            fieldsSql.add(f.prettyPrint(lpad + 2));
        }
        return String.format("%sSTRUCT<\n%s\n%s>", leftPadding, Joiner.on((String)",\n").join(fieldsSql), leftPadding);
    }

    public void addField(StructField field) {
        field.setPosition(this.fields_.size());
        this.fields_.add(field);
        this.fieldMap_.put(field.getName().toLowerCase(), field);
    }

    public List<StructField> getFields() {
        return this.fields_;
    }

    public StructField getField(String fieldName) {
        return this.fieldMap_.get(fieldName.toLowerCase());
    }

    public void clearFields() {
        this.fields_.clear();
        this.fieldMap_.clear();
    }

    public void updateFields(int pos, StructField field) {
        if (this.fields_.size() >= pos) {
            this.fieldMap_.put(field.getName(), field);
            this.fields_.set(pos, field);
        }
    }

    @Override
    public int getSlotSize() {
        int size = 0;
        for (StructField structField : this.fields_) {
            size += structField.getType().getSlotSize();
        }
        return size;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof StructType)) {
            return false;
        }
        StructType otherStructType = (StructType)other;
        return otherStructType.getFields().equals(this.fields_);
    }

    @Override
    public int hashCode() {
        return this.fields_.hashCode();
    }

    @Override
    public void toThrift(TColumnType container) {
        TTypeNode node = new TTypeNode();
        container.types.add(node);
        Preconditions.checkNotNull(this.fields_);
        Preconditions.checkState((!this.fields_.isEmpty() ? 1 : 0) != 0);
        node.setType(TTypeNodeType.STRUCT);
        node.setStruct_fields(new ArrayList<TStructField>());
        for (StructField field : this.fields_) {
            field.toThrift(container, node);
        }
    }
}

