/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.impala.catalog.Type;
import org.apache.impala.thrift.TColumnType;
import org.apache.impala.thrift.TStructField;
import org.apache.impala.thrift.TTypeNode;

public class StructField {
    protected final String name_;
    protected final Type type_;
    protected final String comment_;
    protected int position_;
    protected boolean isHidden_ = false;

    public StructField(String name, Type type, String comment, boolean isHidden) {
        this.name_ = name.toLowerCase();
        this.type_ = type;
        this.comment_ = comment;
        this.isHidden_ = isHidden;
    }

    public StructField(String name, Type type, String comment) {
        this(name, type, comment, false);
    }

    public StructField(String name, Type type) {
        this(name, type, null);
    }

    public String getComment() {
        return this.comment_;
    }

    public String getName() {
        return this.name_;
    }

    public Type getType() {
        return this.type_;
    }

    public int getPosition() {
        return this.position_;
    }

    public void setPosition(int position) {
        this.position_ = position;
    }

    public boolean isHidden() {
        return this.isHidden_;
    }

    public String toSql(int depth) {
        String typeSql = depth < Type.MAX_NESTING_DEPTH ? this.type_.toSql(depth) : "...";
        StringBuilder sb = new StringBuilder(this.name_);
        if (this.type_ != null) {
            sb.append(":" + typeSql);
        }
        if (this.comment_ != null) {
            sb.append(String.format(" COMMENT '%s'", this.comment_));
        }
        return sb.toString();
    }

    public String prettyPrint(int lpad) {
        String leftPadding = StringUtils.repeat((char)' ', (int)lpad);
        StringBuilder sb = new StringBuilder(leftPadding + this.name_);
        if (this.type_ != null) {
            String typeStr = this.type_.prettyPrint(lpad);
            typeStr = typeStr.substring(lpad);
            sb.append(":" + typeStr);
        }
        if (this.comment_ != null) {
            sb.append(String.format(" COMMENT '%s'", this.comment_));
        }
        return sb.toString();
    }

    public void toThrift(TColumnType container, TTypeNode node) {
        TStructField field = new TStructField();
        field.setName(this.name_);
        if (this.comment_ != null) {
            field.setComment(this.comment_);
        }
        node.struct_fields.add(field);
        this.type_.toThrift(container);
    }

    public boolean equals(Object other) {
        if (!(other instanceof StructField)) {
            return false;
        }
        StructField otherStructField = (StructField)other;
        return otherStructField.name_.equals(this.name_) && otherStructField.type_.equals(this.type_);
    }

    public int hashCode() {
        return Objects.hash(this.name_, this.type_);
    }
}

