/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.impala.thrift.TSqlConstraints;

public class SqlConstraints {
    private final List<SQLPrimaryKey> primaryKeys_;
    private final List<SQLForeignKey> foreignKeys_;

    public SqlConstraints(List<SQLPrimaryKey> primaryKeys, List<SQLForeignKey> foreignKeys) {
        this.primaryKeys_ = primaryKeys == null ? new ArrayList() : primaryKeys;
        this.foreignKeys_ = foreignKeys == null ? new ArrayList() : foreignKeys;
        this.sortSqlConstraints();
    }

    private void sortSqlConstraints() {
        this.primaryKeys_.sort((pk1, pk2) -> {
            int keyNameComp = pk1.getPk_name().compareTo(pk2.getPk_name());
            if (keyNameComp == 0) {
                return Integer.compare(pk1.getKey_seq(), pk2.getKey_seq());
            }
            return keyNameComp;
        });
        this.foreignKeys_.sort((fk1, fk2) -> {
            int parentTableNameComp = fk1.getPktable_name().compareTo(fk2.getPktable_name());
            if (parentTableNameComp == 0) {
                return Integer.compare(fk1.getKey_seq(), fk2.getKey_seq());
            }
            return parentTableNameComp;
        });
    }

    public List<SQLPrimaryKey> getPrimaryKeys() {
        Preconditions.checkNotNull(this.primaryKeys_);
        return ImmutableList.copyOf(this.primaryKeys_);
    }

    public List<SQLForeignKey> getForeignKeys() {
        Preconditions.checkNotNull(this.foreignKeys_);
        return ImmutableList.copyOf(this.foreignKeys_);
    }

    public TSqlConstraints toThrift() {
        Preconditions.checkNotNull(this.primaryKeys_);
        Preconditions.checkNotNull(this.foreignKeys_);
        TSqlConstraints tSqlConstraints = new TSqlConstraints();
        tSqlConstraints.setPrimary_keys(this.primaryKeys_);
        tSqlConstraints.setForeign_keys(this.foreignKeys_);
        return tSqlConstraints;
    }

    public static SqlConstraints fromThrift(TSqlConstraints tSqlConstraints) {
        return new SqlConstraints(tSqlConstraints.getPrimary_keys(), tSqlConstraints.getForeign_keys());
    }
}

