/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.util.List;
import org.apache.impala.analysis.FunctionName;
import org.apache.impala.analysis.HdfsUri;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.thrift.TFunction;
import org.apache.impala.thrift.TFunctionBinaryType;
import org.apache.impala.thrift.TScalarFunction;
import org.apache.impala.thrift.TSymbolLookupParams;
import org.apache.impala.thrift.TSymbolType;

public class ScalarFunction
extends Function {
    protected String symbolName_;
    protected String prepareFnSymbol_;
    protected String closeFnSymbol_;

    public ScalarFunction(FunctionName fnName, List<Type> argTypes, Type retType, boolean hasVarArgs) {
        super(fnName, argTypes, retType, hasVarArgs);
    }

    public ScalarFunction(FunctionName fnName, Type[] argTypes, Type retType, boolean hasVarArgs) {
        super(fnName, argTypes, retType, hasVarArgs);
    }

    public ScalarFunction(FunctionName fnName, List<Type> argTypes, Type retType, HdfsUri location, String symbolName, String initFnSymbol, String closeFnSymbol) {
        super(fnName, argTypes, retType, false);
        this.setLocation(location);
        this.setSymbolName(symbolName);
        this.setPrepareFnSymbol(initFnSymbol);
        this.setCloseFnSymbol(closeFnSymbol);
    }

    public static ScalarFunction createBuiltin(String name, List<Type> argTypes, boolean hasVarArgs, Type retType, String symbol, String prepareFnSymbol, String closeFnSymbol, boolean userVisible) {
        Preconditions.checkNotNull((Object)symbol);
        ScalarFunction fn = new ScalarFunction(new FunctionName("_impala_builtins", name), argTypes, retType, hasVarArgs);
        fn.setBinaryType(TFunctionBinaryType.BUILTIN);
        fn.setUserVisible(userVisible);
        fn.setIsPersistent(true);
        try {
            fn.symbolName_ = fn.lookupSymbol(symbol, TSymbolType.UDF_EVALUATE, null, fn.hasVarArgs(), fn.getArgs());
        }
        catch (AnalysisException e) {
            throw new RuntimeException("Builtin symbol '" + symbol + "'" + argTypes + " not found!", e);
        }
        if (prepareFnSymbol != null) {
            try {
                fn.prepareFnSymbol_ = fn.lookupSymbol(prepareFnSymbol, TSymbolType.UDF_PREPARE);
            }
            catch (AnalysisException e) {
                throw new RuntimeException("Builtin symbol '" + prepareFnSymbol + "' not found!", e);
            }
        }
        if (closeFnSymbol != null) {
            try {
                fn.closeFnSymbol_ = fn.lookupSymbol(closeFnSymbol, TSymbolType.UDF_CLOSE);
            }
            catch (AnalysisException e) {
                throw new RuntimeException("Builtin symbol '" + closeFnSymbol + "' not found!", e);
            }
        }
        return fn;
    }

    public static ScalarFunction createBuiltinOperator(String name, List<Type> argTypes, Type retType) {
        String beFn = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        boolean usesDecimal = false;
        block14: for (int i = 0; i < argTypes.size(); ++i) {
            switch (argTypes.get(i).getPrimitiveType()) {
                case BOOLEAN: {
                    beFn = beFn + "_BooleanVal";
                    continue block14;
                }
                case TINYINT: {
                    beFn = beFn + "_TinyIntVal";
                    continue block14;
                }
                case SMALLINT: {
                    beFn = beFn + "_SmallIntVal";
                    continue block14;
                }
                case INT: {
                    beFn = beFn + "_IntVal";
                    continue block14;
                }
                case BIGINT: {
                    beFn = beFn + "_BigIntVal";
                    continue block14;
                }
                case FLOAT: {
                    beFn = beFn + "_FloatVal";
                    continue block14;
                }
                case DOUBLE: {
                    beFn = beFn + "_DoubleVal";
                    continue block14;
                }
                case STRING: 
                case VARCHAR: 
                case BINARY: {
                    beFn = beFn + "_StringVal";
                    continue block14;
                }
                case CHAR: {
                    beFn = beFn + "_Char";
                    continue block14;
                }
                case TIMESTAMP: {
                    beFn = beFn + "_TimestampVal";
                    continue block14;
                }
                case DECIMAL: {
                    beFn = beFn + "_DecimalVal";
                    usesDecimal = true;
                    continue block14;
                }
                case DATE: {
                    beFn = beFn + "_DateVal";
                    continue block14;
                }
                default: {
                    Preconditions.checkState((boolean)false, (Object)("Argument type not supported: " + argTypes.get(i).toSql()));
                }
            }
        }
        String beClass = usesDecimal ? "DecimalOperators" : "Operators";
        String symbol = "impala::" + beClass + "::" + beFn;
        return ScalarFunction.createBuiltinOperator(name, symbol, argTypes, retType);
    }

    public static ScalarFunction createBuiltinOperator(String name, String symbol, List<Type> argTypes, Type retType) {
        return ScalarFunction.createBuiltin(name, symbol, argTypes, false, retType, false);
    }

    public static ScalarFunction createBuiltin(String name, String symbol, List<Type> argTypes, boolean hasVarArgs, Type retType, boolean userVisible) {
        ScalarFunction fn = new ScalarFunction(new FunctionName("_impala_builtins", name), argTypes, retType, hasVarArgs);
        fn.setBinaryType(TFunctionBinaryType.BUILTIN);
        fn.setUserVisible(userVisible);
        fn.setIsPersistent(true);
        try {
            fn.symbolName_ = fn.lookupSymbol(symbol, TSymbolType.UDF_EVALUATE, null, fn.hasVarArgs(), fn.getArgs());
        }
        catch (AnalysisException e) {
            Preconditions.checkState((boolean)false, (Object)("Builtin symbol '" + symbol + "'" + argTypes + " not found: " + Throwables.getStackTraceAsString((Throwable)e)));
            throw new RuntimeException("Builtin symbol not found!", e);
        }
        return fn;
    }

    public static ScalarFunction createForTesting(String db, String fnName, List<Type> args, Type retType, String uriPath, String symbolName, String initFnSymbol, String closeFnSymbol, TFunctionBinaryType type) {
        ScalarFunction fn = new ScalarFunction(new FunctionName(db, fnName), args, retType, new HdfsUri(uriPath), symbolName, initFnSymbol, closeFnSymbol);
        fn.setBinaryType(type);
        fn.setIsPersistent(true);
        return fn;
    }

    public void setSymbolName(String s) {
        this.symbolName_ = s;
    }

    public void setPrepareFnSymbol(String s) {
        this.prepareFnSymbol_ = s;
    }

    public void setCloseFnSymbol(String s) {
        this.closeFnSymbol_ = s;
    }

    public String getSymbolName() {
        return this.symbolName_;
    }

    public String getPrepareFnSymbol() {
        return this.prepareFnSymbol_;
    }

    public String getCloseFnSymbol() {
        return this.closeFnSymbol_;
    }

    @Override
    protected TSymbolLookupParams getLookupParams() {
        return this.buildLookupParams(this.getSymbolName(), TSymbolType.UDF_EVALUATE, null, this.hasVarArgs(), false, this.getArgs());
    }

    @Override
    public String toSql(boolean ifNotExists) {
        StringBuilder sb = new StringBuilder("CREATE FUNCTION ");
        if (ifNotExists) {
            sb.append("IF NOT EXISTS ");
        }
        sb.append(this.dbName()).append(".");
        if (this.binaryType_ == TFunctionBinaryType.JAVA) {
            sb.append(this.name_.getFunction());
        } else {
            sb.append(this.signatureString()).append("\n");
            sb.append(" RETURNS " + this.getReturnType());
        }
        if (this.getLocation() != null) {
            sb.append("\n").append(" LOCATION '" + this.getLocation()).append("'");
        }
        if (this.getSymbolName() != null) {
            sb.append("\n").append(" SYMBOL='" + this.getSymbolName()).append("'");
        }
        return sb.toString();
    }

    public String toString() {
        return this.toSql(false);
    }

    @Override
    public TFunction toThrift() {
        TFunction fn = super.toThrift();
        fn.setScalar_fn(new TScalarFunction());
        fn.getScalar_fn().setSymbol(this.symbolName_);
        if (this.prepareFnSymbol_ != null) {
            fn.getScalar_fn().setPrepare_fn_symbol(this.prepareFnSymbol_);
        }
        if (this.closeFnSymbol_ != null) {
            fn.getScalar_fn().setClose_fn_symbol(this.closeFnSymbol_);
        }
        return fn;
    }
}

