/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import java.util.ArrayList;
import java.util.List;
import org.apache.impala.thrift.TPrimitiveType;

public enum PrimitiveType {
    INVALID_TYPE("INVALID_TYPE", -1, TPrimitiveType.INVALID_TYPE),
    NULL_TYPE("NULL_TYPE", 1, TPrimitiveType.NULL_TYPE),
    BOOLEAN("BOOLEAN", 1, TPrimitiveType.BOOLEAN),
    TINYINT("TINYINT", 1, TPrimitiveType.TINYINT),
    SMALLINT("SMALLINT", 2, TPrimitiveType.SMALLINT),
    INT("INT", 4, TPrimitiveType.INT),
    BIGINT("BIGINT", 8, TPrimitiveType.BIGINT),
    FLOAT("FLOAT", 4, TPrimitiveType.FLOAT),
    DOUBLE("DOUBLE", 8, TPrimitiveType.DOUBLE),
    DATETIME("DATETIME", 8, TPrimitiveType.DATETIME),
    TIMESTAMP("TIMESTAMP", 16, TPrimitiveType.TIMESTAMP),
    DATE("DATE", 4, TPrimitiveType.DATE),
    STRING("STRING", 12, TPrimitiveType.STRING),
    VARCHAR("VARCHAR", 12, TPrimitiveType.VARCHAR),
    BINARY("BINARY", 12, TPrimitiveType.BINARY),
    DECIMAL("DECIMAL", 16, TPrimitiveType.DECIMAL),
    CHAR("CHAR", -1, TPrimitiveType.CHAR),
    FIXED_UDA_INTERMEDIATE("FIXED_UDA_INTERMEDIATE", -1, TPrimitiveType.FIXED_UDA_INTERMEDIATE);

    private final String description_;
    private final int slotSize_;
    private final TPrimitiveType thriftType_;

    private PrimitiveType(String description, int slotSize, TPrimitiveType thriftType) {
        this.description_ = description;
        this.slotSize_ = slotSize;
        this.thriftType_ = thriftType;
    }

    public String toString() {
        return this.description_;
    }

    public static PrimitiveType fromThrift(TPrimitiveType t) {
        switch (t) {
            case INVALID_TYPE: {
                return INVALID_TYPE;
            }
            case NULL_TYPE: {
                return NULL_TYPE;
            }
            case BOOLEAN: {
                return BOOLEAN;
            }
            case TINYINT: {
                return TINYINT;
            }
            case SMALLINT: {
                return SMALLINT;
            }
            case INT: {
                return INT;
            }
            case BIGINT: {
                return BIGINT;
            }
            case FLOAT: {
                return FLOAT;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case DATE: {
                return DATE;
            }
            case DATETIME: {
                return DATETIME;
            }
            case STRING: {
                return STRING;
            }
            case VARCHAR: {
                return VARCHAR;
            }
            case TIMESTAMP: {
                return TIMESTAMP;
            }
            case CHAR: {
                return CHAR;
            }
            case DECIMAL: {
                return DECIMAL;
            }
            case BINARY: {
                return BINARY;
            }
            case FIXED_UDA_INTERMEDIATE: {
                return FIXED_UDA_INTERMEDIATE;
            }
        }
        return INVALID_TYPE;
    }

    public TPrimitiveType toThrift() {
        return this.thriftType_;
    }

    public static List<TPrimitiveType> toThrift(PrimitiveType[] types) {
        ArrayList<TPrimitiveType> result = new ArrayList<TPrimitiveType>();
        for (PrimitiveType t : types) {
            result.add(t.toThrift());
        }
        return result;
    }

    public int getSlotSize() {
        return this.slotSize_;
    }
}

