/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.RetryingMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.impala.catalog.MetastoreClientInstantiationException;
import org.apache.log4j.Logger;

public class MetaStoreClientPool {
    private static final String HIVE_METASTORE_CNXN_DELAY_MS_CONF = "impala.catalog.metastore.cnxn.creation.delay.ms";
    private static final int DEFAULT_HIVE_METASTORE_CNXN_DELAY_MS_CONF = 0;
    private static final int MAX_HMS_CONNECTION_POOL_SIZE = 32;
    private final AtomicInteger numHmsClientsInUse_ = new AtomicInteger(0);
    private final int clientCreationDelayMs_;
    private static final Logger LOG = Logger.getLogger(MetaStoreClientPool.class);
    private final ConcurrentLinkedQueue<MetaStoreClient> clientPool_ = new ConcurrentLinkedQueue();
    private Boolean poolClosed_ = false;
    private final Object poolCloseLock_ = new Object();
    private final HiveConf hiveConf_;
    private static final HiveMetaHookLoader dummyHookLoader = new HiveMetaHookLoader(){

        public HiveMetaHook getHook(Table tbl) throws MetaException {
            return null;
        }
    };

    public MetaStoreClientPool(int initialSize, int initialCnxnTimeoutSec) {
        this(initialSize, initialCnxnTimeoutSec, new HiveConf(MetaStoreClientPool.class));
    }

    public MetaStoreClientPool(int initialSize, int initialCnxnTimeoutSec, HiveConf hiveConf) {
        this.hiveConf_ = hiveConf;
        this.clientCreationDelayMs_ = this.hiveConf_.getInt(HIVE_METASTORE_CNXN_DELAY_MS_CONF, 0);
        this.initClients(initialSize, initialCnxnTimeoutSec);
    }

    public void initClients(int numClients, int initialCnxnTimeoutSec) {
        Preconditions.checkState((this.clientPool_.size() == 0 ? 1 : 0) != 0);
        if (numClients > 0) {
            this.clientPool_.add(new MetaStoreClient(this.hiveConf_, initialCnxnTimeoutSec));
            for (int i = 0; i < numClients - 1; ++i) {
                this.clientPool_.add(new MetaStoreClient(this.hiveConf_, 0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaStoreClient getClient() {
        MetaStoreClient client;
        if (Thread.currentThread().getContextClassLoader() == null) {
            Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
        }
        if ((client = this.clientPool_.poll()) == null) {
            MetaStoreClientPool metaStoreClientPool = this;
            synchronized (metaStoreClientPool) {
                try {
                    Thread.sleep(this.clientCreationDelayMs_);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                client = new MetaStoreClient(this.hiveConf_, 0);
            }
        }
        client.markInUse();
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.poolCloseLock_;
        synchronized (object) {
            if (this.poolClosed_.booleanValue()) {
                return;
            }
            this.poolClosed_ = true;
        }
        MetaStoreClient client = null;
        while ((client = this.clientPool_.poll()) != null) {
            client.getHiveClient().close();
        }
    }

    public int getNumHmsClientsIdle() {
        return this.clientPool_.size();
    }

    public int getNumHmsClientsInUse() {
        return this.numHmsClientsInUse_.get();
    }

    public class MetaStoreClient
    implements AutoCloseable {
        private final IMetaStoreClient hiveClient_;
        private boolean isInUse_;

        private MetaStoreClient(HiveConf hiveConf, int cnxnTimeoutSec) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Creating MetaStoreClient. Pool Size = " + MetaStoreClientPool.this.clientPool_.size()));
            }
            long retryDelaySeconds = hiveConf.getTimeVar(HiveConf.ConfVars.METASTORE_CLIENT_CONNECT_RETRY_DELAY, TimeUnit.SECONDS);
            long retryDelayMillis = retryDelaySeconds * 1000L;
            long endTimeMillis = System.currentTimeMillis() + (long)(cnxnTimeoutSec * 1000);
            IMetaStoreClient hiveClient = null;
            block4: while (true) {
                try {
                    hiveClient = RetryingMetaStoreClient.getProxy((Configuration)hiveConf, (HiveMetaHookLoader)dummyHookLoader, (String)HiveMetaStoreClient.class.getName());
                }
                catch (Exception e) {
                    long delayUntilMillis = System.currentTimeMillis() + retryDelayMillis;
                    if (delayUntilMillis >= endTimeMillis) {
                        throw new MetastoreClientInstantiationException(e);
                    }
                    LOG.warn((Object)"Failed to connect to Hive MetaStore. Retrying.", (Throwable)e);
                    while (true) {
                        if (delayUntilMillis <= System.currentTimeMillis()) continue block4;
                        try {
                            Thread.sleep(delayUntilMillis - System.currentTimeMillis());
                        }
                        catch (IllegalArgumentException | InterruptedException exception) {}
                    }
                }
                break;
            }
            this.hiveClient_ = hiveClient;
            this.isInUse_ = false;
        }

        public IMetaStoreClient getHiveClient() {
            return this.hiveClient_;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Preconditions.checkState((boolean)this.isInUse_);
            this.isInUse_ = false;
            MetaStoreClientPool.this.numHmsClientsInUse_.decrementAndGet();
            Object object = MetaStoreClientPool.this.poolCloseLock_;
            synchronized (object) {
                if (MetaStoreClientPool.this.poolClosed_.booleanValue() || MetaStoreClientPool.this.clientPool_.size() >= 32) {
                    this.hiveClient_.close();
                } else {
                    MetaStoreClientPool.this.clientPool_.offer(this);
                }
            }
        }

        private void markInUse() {
            Preconditions.checkState((!this.isInUse_ ? 1 : 0) != 0);
            this.isInUse_ = true;
            MetaStoreClientPool.this.numHmsClientsInUse_.incrementAndGet();
        }
    }
}

