/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.thrift.TColumn;
import org.apache.impala.util.KuduUtil;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Schema;

public class KuduColumn
extends Column {
    private final String kuduName_;
    private final boolean isKey_;
    private final boolean isPrimaryKeyUnique_;
    private final boolean isNullable_;
    private final boolean isAutoIncrementing_;
    private final ColumnSchema.Encoding encoding_;
    private final ColumnSchema.CompressionAlgorithm compression_;
    private final int blockSize_;
    private final LiteralExpr defaultValue_;

    private KuduColumn(String name, Type type, boolean isKey, boolean isPrimaryKeyUnique, boolean isNullable, boolean isAutoIncrementing, ColumnSchema.Encoding encoding, ColumnSchema.CompressionAlgorithm compression, LiteralExpr defaultValue, int blockSize, String comment, int position) {
        super(name.toLowerCase(), type, comment, position);
        Preconditions.checkArgument((defaultValue == null || type == defaultValue.getType() || type.isTimestamp() && defaultValue.getType().isIntegerType() ? 1 : 0) != 0);
        if (isKey) {
            Preconditions.checkArgument((!isPrimaryKeyUnique || !isAutoIncrementing ? 1 : 0) != 0);
        } else {
            Preconditions.checkArgument((!isPrimaryKeyUnique && !isAutoIncrementing ? 1 : 0) != 0);
        }
        this.kuduName_ = name;
        this.isKey_ = isKey;
        this.isPrimaryKeyUnique_ = isPrimaryKeyUnique;
        this.isNullable_ = isNullable;
        this.isAutoIncrementing_ = isAutoIncrementing;
        this.encoding_ = encoding;
        this.compression_ = compression;
        this.defaultValue_ = defaultValue;
        this.blockSize_ = blockSize;
    }

    public static KuduColumn fromColumnSchema(ColumnSchema colSchema, int position) throws ImpalaRuntimeException {
        Type type = KuduUtil.toImpalaType(colSchema.getType(), colSchema.getTypeAttributes());
        Object defaultValue = colSchema.getDefaultValue();
        LiteralExpr defaultValueExpr = null;
        if (defaultValue != null) {
            Type defaultValueType = type.isTimestamp() ? Type.BIGINT : type;
            try {
                defaultValueExpr = LiteralExpr.createFromUnescapedStr(defaultValue.toString(), defaultValueType);
            }
            catch (AnalysisException e) {
                throw new ImpalaRuntimeException(String.format("Error parsing default value: '%s'", defaultValue), e);
            }
            Preconditions.checkNotNull((Object)defaultValueExpr);
        }
        String comment = !colSchema.getComment().isEmpty() ? colSchema.getComment() : null;
        return new KuduColumn(colSchema.getName(), type, colSchema.isKey(), colSchema.isKeyUnique(), colSchema.isNullable(), colSchema.isAutoIncrementing(), colSchema.getEncoding(), colSchema.getCompressionAlgorithm(), defaultValueExpr, colSchema.getDesiredBlockSize(), comment, position);
    }

    public static KuduColumn fromThrift(TColumn column, int position) throws ImpalaRuntimeException {
        Preconditions.checkState((boolean)column.isSetIs_key());
        Preconditions.checkState((boolean)column.isSetIs_primary_key_unique());
        boolean isNullable = false;
        if (column.isSetIs_nullable()) {
            isNullable = column.isIs_nullable();
        }
        Type columnType = Type.fromThrift(column.getColumnType());
        ColumnSchema.Encoding encoding = null;
        if (column.isSetEncoding()) {
            encoding = KuduUtil.fromThrift(column.getEncoding());
        }
        ColumnSchema.CompressionAlgorithm compression = null;
        if (column.isSetCompression()) {
            compression = KuduUtil.fromThrift(column.getCompression());
        }
        LiteralExpr defaultValue = null;
        if (column.isSetDefault_value()) {
            Type defaultValueType = columnType.isTimestamp() ? Type.BIGINT : columnType;
            defaultValue = LiteralExpr.fromThrift(column.getDefault_value().getNodes().get(0), defaultValueType);
        }
        int blockSize = 0;
        if (column.isSetBlock_size()) {
            blockSize = column.getBlock_size();
        }
        String comment = column.isSetComment() && !column.getComment().isEmpty() ? column.getComment() : null;
        return new KuduColumn(column.getKudu_column_name(), columnType, column.isIs_key(), column.isIs_primary_key_unique(), isNullable, column.isIs_auto_incrementing(), encoding, compression, defaultValue, blockSize, comment, position);
    }

    public static KuduColumn createAutoIncrementingColumn(int position) throws ImpalaRuntimeException {
        org.apache.kudu.Type kuduType = Schema.getAutoIncrementingColumnType();
        Preconditions.checkArgument((kuduType != org.apache.kudu.Type.DECIMAL && kuduType != org.apache.kudu.Type.VARCHAR ? 1 : 0) != 0);
        Type type = KuduUtil.toImpalaType(kuduType, null);
        return new KuduColumn(Schema.getAutoIncrementingColumnName(), type, true, false, false, true, null, null, null, 0, "", position);
    }

    public String getKuduName() {
        return this.kuduName_;
    }

    public boolean isKey() {
        return this.isKey_;
    }

    public boolean isPrimaryKeyUnique() {
        return this.isPrimaryKeyUnique_;
    }

    public boolean isNullable() {
        return this.isNullable_;
    }

    public boolean isAutoIncrementing() {
        return this.isAutoIncrementing_;
    }

    public ColumnSchema.Encoding getEncoding() {
        return this.encoding_;
    }

    public ColumnSchema.CompressionAlgorithm getCompression() {
        return this.compression_;
    }

    public int getBlockSize() {
        return this.blockSize_;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue_ != null;
    }

    public String getDefaultValueSql() {
        if (!this.hasDefaultValue()) {
            return null;
        }
        if (!this.type_.isTimestamp()) {
            return this.defaultValue_.toSql();
        }
        return "unix_micros_to_utc_timestamp(" + this.defaultValue_.getStringValue() + ")";
    }

    public String getDefaultValueString() {
        if (!this.hasDefaultValue()) {
            return null;
        }
        return this.defaultValue_.getStringValue();
    }

    @Override
    public TColumn toThrift() {
        TColumn colDesc = new TColumn(this.name_, this.type_.toThrift());
        KuduUtil.setColumnOptions(colDesc, this.isKey_, this.isPrimaryKeyUnique_, this.isNullable_, this.isAutoIncrementing_, this.encoding_, this.compression_, this.defaultValue_, this.blockSize_, this.kuduName_);
        if (this.comment_ != null) {
            colDesc.setComment(this.comment_);
        }
        colDesc.setCol_stats(this.getStats().toThrift());
        colDesc.setPosition(this.position_);
        colDesc.setIs_kudu_column(true);
        return colDesc;
    }
}

