/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.util.SnapshotUtil;
import org.apache.impala.analysis.TimeTravelSpec;
import org.apache.impala.catalog.ArrayType;
import org.apache.impala.catalog.CatalogObject;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.FeCatalogUtils;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.ForwardingFeIcebergTable;
import org.apache.impala.catalog.IcebergColumn;
import org.apache.impala.catalog.IcebergStructField;
import org.apache.impala.catalog.StructType;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.thrift.TColumnDescriptor;
import org.apache.impala.thrift.THdfsTable;
import org.apache.impala.thrift.TTableDescriptor;
import org.apache.impala.thrift.TTableType;
import org.apache.impala.util.IcebergSchemaConverter;

public class IcebergTimeTravelTable
extends ForwardingFeIcebergTable
implements FeIcebergTable {
    private final FeIcebergTable base_;
    private final TimeTravelSpec timeTravelSpec_;
    protected final ArrayList<Column> colsByPos_ = new ArrayList();
    protected final Map<String, Column> colsByName_ = new HashMap<String, Column>();
    protected final ArrayType type_ = new ArrayType(new StructType());

    public IcebergTimeTravelTable(FeIcebergTable base, TimeTravelSpec timeTravelSpec) throws AnalysisException {
        super(base);
        this.base_ = base;
        this.timeTravelSpec_ = timeTravelSpec;
        this.readSchema();
    }

    public FeIcebergTable getBase() {
        return this.base_;
    }

    private void readSchema() throws AnalysisException {
        Schema icebergSchema;
        Table icebergApiTable = this.getIcebergApiTable();
        if (this.timeTravelSpec_.getKind() == TimeTravelSpec.Kind.VERSION_AS_OF) {
            long snapshotId = this.timeTravelSpec_.getAsOfVersion();
            icebergSchema = SnapshotUtil.schemaFor((Table)icebergApiTable, (Long)snapshotId, null);
        } else {
            Preconditions.checkState((this.timeTravelSpec_.getKind() == TimeTravelSpec.Kind.TIME_AS_OF ? 1 : 0) != 0);
            long timestampMillis = this.timeTravelSpec_.getAsOfMillis();
            try {
                icebergSchema = SnapshotUtil.schemaFor((Table)icebergApiTable, null, (Long)timestampMillis);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Cannot find a snapshot older than " + this.timeTravelSpec_.toTimeString());
            }
        }
        try {
            for (Column col : IcebergSchemaConverter.convertToImpalaSchema(icebergSchema)) {
                this.addColumn(col);
            }
        }
        catch (ImpalaRuntimeException e) {
            throw new AnalysisException("Could not create iceberg schema.", e);
        }
    }

    @Override
    public List<Column> getColumnsInHiveOrder() {
        Preconditions.checkState((this.base_.getNumClusteringCols() == 0 ? 1 : 0) != 0);
        return this.colsByPos_;
    }

    @Override
    public List<String> getColumnNames() {
        return Column.toColumnNames(this.colsByPos_);
    }

    @Override
    public List<Column> getColumns() {
        return this.colsByPos_;
    }

    @Override
    public List<Column> getClusteringColumns() {
        return Collections.emptyList();
    }

    @Override
    public Column getColumn(String name) {
        return this.colsByName_.get(name.toLowerCase());
    }

    @Override
    public List<Column> getNonClusteringColumns() {
        return this.colsByPos_;
    }

    @Override
    public boolean isClusteringColumn(Column c) {
        Preconditions.checkArgument((this.colsByPos_.get(c.getPosition()) == c ? 1 : 0) != 0);
        return false;
    }

    @Override
    public TTableDescriptor toThriftDescriptor(int tableId, Set<Long> referencedPartitions) {
        TTableDescriptor desc = new TTableDescriptor(tableId, TTableType.ICEBERG_TABLE, this.getTColumnDescriptors(), 0, this.getName(), this.getDb().getName());
        desc.setIcebergTable(FeIcebergTable.Utils.getTIcebergTable(this, CatalogObject.ThriftObjectType.DESCRIPTOR_ONLY));
        desc.setHdfsTable(this.transformToTHdfsTable(false, CatalogObject.ThriftObjectType.DESCRIPTOR_ONLY));
        return desc;
    }

    public List<TColumnDescriptor> getTColumnDescriptors() {
        return FeCatalogUtils.getTColumnDescriptors(this);
    }

    @Override
    public ArrayType getType() {
        return this.type_;
    }

    public void addColumn(Column col) {
        Preconditions.checkState((boolean)(col instanceof IcebergColumn));
        IcebergColumn iCol = (IcebergColumn)col;
        this.colsByPos_.add(iCol);
        this.colsByName_.put(iCol.getName().toLowerCase(), col);
        ((StructType)this.type_.getItemType()).addField(new IcebergStructField(col.getName(), col.getType(), col.getComment(), iCol.getFieldId()));
    }

    @Override
    public THdfsTable transformToTHdfsTable(boolean updatePartitionFlag, CatalogObject.ThriftObjectType type) {
        return this.base_.transformToTHdfsTable(updatePartitionFlag, type);
    }
}

