/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.iceberg.expressions.Expression;
import org.apache.impala.analysis.IcebergPartitionField;
import org.apache.impala.analysis.IcebergPartitionSpec;
import org.apache.impala.analysis.IcebergPartitionTransform;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.CatalogObject;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.HdfsFileFormat;
import org.apache.impala.catalog.HdfsPartition;
import org.apache.impala.catalog.HdfsTable;
import org.apache.impala.catalog.IcebergColumn;
import org.apache.impala.catalog.IcebergContentFileStore;
import org.apache.impala.catalog.IcebergStructField;
import org.apache.impala.catalog.IcebergTableLoadingException;
import org.apache.impala.catalog.StructType;
import org.apache.impala.catalog.Table;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.VirtualColumn;
import org.apache.impala.catalog.iceberg.GroupedContentFiles;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.thrift.TCatalogObjectType;
import org.apache.impala.thrift.TCompressionCodec;
import org.apache.impala.thrift.TGetPartialCatalogObjectRequest;
import org.apache.impala.thrift.TGetPartialCatalogObjectResponse;
import org.apache.impala.thrift.THdfsCompression;
import org.apache.impala.thrift.THdfsTable;
import org.apache.impala.thrift.TIcebergCatalog;
import org.apache.impala.thrift.TIcebergFileFormat;
import org.apache.impala.thrift.TIcebergPartitionField;
import org.apache.impala.thrift.TIcebergPartitionSpec;
import org.apache.impala.thrift.TIcebergPartitionStats;
import org.apache.impala.thrift.TIcebergTable;
import org.apache.impala.thrift.TPartialPartitionInfo;
import org.apache.impala.thrift.TTable;
import org.apache.impala.thrift.TTableDescriptor;
import org.apache.impala.thrift.TTableType;
import org.apache.impala.util.EventSequence;
import org.apache.impala.util.IcebergSchemaConverter;
import org.apache.impala.util.IcebergUtil;
import org.apache.thrift.TException;

public class IcebergTable
extends Table
implements FeIcebergTable {
    public static final String KEY_STORAGE_HANDLER = "storage_handler";
    public static final String ICEBERG_STORAGE_HANDLER = "org.apache.iceberg.mr.hive.HiveIcebergStorageHandler";
    public static final String ICEBERG_FILE_FORMAT = "write.format.default";
    public static final String ICEBERG_CATALOG = "iceberg.catalog";
    public static final int ICEBERG_FORMAT_V1 = 1;
    public static final int ICEBERG_FORMAT_V2 = 2;
    public static final String ICEBERG_CATALOG_LOCATION = "iceberg.catalog_location";
    public static final String ICEBERG_TABLE_IDENTIFIER = "iceberg.table_identifier";
    public static final String METADATA_LOCATION = "metadata_location";
    public static final String PREVIOUS_METADATA_LOCATION = "previous_metadata_location";
    public static final String CURRENT_SCHEMA = "current-schema";
    public static final String SNAPSHOT_COUNT = "snapshot-count";
    public static final String CURRENT_SNAPSHOT_ID = "current-snapshot-id";
    public static final String CURRENT_SNAPSHOT_SUMMARY = "current-snapshot-summary";
    public static final String CURRENT_SNAPSHOT_TIMESTAMP_MS = "current-snapshot-timestamp-ms";
    public static final String DEFAULT_PARTITION_SPEC = "default-partition-spec";
    public static final String UUID = "uuid";
    public static final String PARQUET_COMPRESSION_CODEC = "write.parquet.compression-codec";
    public static final String PARQUET_COMPRESSION_LEVEL = "write.parquet.compression-level";
    public static final String MERGE_ON_READ = "merge-on-read";
    public static final THdfsCompression DEFAULT_PARQUET_COMPRESSION_CODEC = THdfsCompression.SNAPPY;
    public static final int DEFAULT_PARQUET_ZSTD_COMPRESSION_LEVEL = 3;
    public static final int MIN_PARQUET_COMPRESSION_LEVEL = 1;
    public static final int MAX_PARQUET_COMPRESSION_LEVEL = 22;
    public static final String PARQUET_ROW_GROUP_SIZE = "write.parquet.row-group-size-bytes";
    public static final long UNSET_PARQUET_ROW_GROUP_SIZE = 0L;
    public static final long MIN_PARQUET_ROW_GROUP_SIZE = 0x800000L;
    public static final long MAX_PARQUET_ROW_GROUP_SIZE = 0x7FF00000L;
    public static final String PARQUET_PLAIN_PAGE_SIZE = "write.parquet.page-size-bytes";
    public static final String PARQUET_DICT_PAGE_SIZE = "write.parquet.dict-size-bytes";
    public static final long UNSET_PARQUET_PAGE_SIZE = 0L;
    public static final long MIN_PARQUET_PAGE_SIZE = 65536L;
    public static final long MAX_PARQUET_PAGE_SIZE = 0x40000000L;
    public static final int V2_FILE_PATH_FIELD_ID = 2147483546;
    public static final int V2_POS_FIELD_ID = 0x7FFFFF99;
    public static final String METADATA_FOLDER_NAME = "metadata";
    private TIcebergCatalog icebergCatalog_;
    private TIcebergFileFormat icebergFileFormat_;
    private TCompressionCodec icebergParquetCompressionCodec_;
    private long icebergParquetRowGroupSize_;
    private long icebergParquetPlainPageSize_;
    private long icebergParquetDictPageSize_;
    private String icebergTableLocation_;
    private List<IcebergPartitionSpec> partitionSpecs_;
    private int defaultPartitionSpecId_;
    private IcebergContentFileStore fileStore_;
    private HdfsTable hdfsTable_;
    private org.apache.iceberg.Table icebergApiTable_;
    private long catalogSnapshotId_ = -1L;
    private Map<String, TIcebergPartitionStats> partitionStats_;

    protected IcebergTable(org.apache.hadoop.hive.metastore.api.Table msTable, Db db, String name, String owner) {
        super(msTable, db, name, owner);
        this.icebergTableLocation_ = msTable.getSd().getLocation();
        this.icebergCatalog_ = IcebergUtil.getTIcebergCatalog(msTable);
        this.icebergFileFormat_ = IcebergUtil.getIcebergFileFormat(msTable);
        this.icebergParquetCompressionCodec_ = FeIcebergTable.Utils.getIcebergParquetCompressionCodec(msTable);
        this.icebergParquetRowGroupSize_ = FeIcebergTable.Utils.getIcebergParquetRowGroupSize(msTable);
        this.icebergParquetPlainPageSize_ = FeIcebergTable.Utils.getIcebergParquetPlainPageSize(msTable);
        this.icebergParquetDictPageSize_ = FeIcebergTable.Utils.getIcebergParquetDictPageSize(msTable);
        this.hdfsTable_ = new HdfsTable(msTable, db, name, owner);
    }

    public static boolean isSynchronizedTable(org.apache.hadoop.hive.metastore.api.Table msTbl) {
        Preconditions.checkState((boolean)IcebergTable.isIcebergTable(msTbl));
        return IcebergTable.isManagedTable(msTbl) || IcebergTable.isExternalPurgeTable(msTbl);
    }

    public static boolean isManagedTable(org.apache.hadoop.hive.metastore.api.Table msTbl) {
        return msTbl.getTableType().equalsIgnoreCase(TableType.MANAGED_TABLE.toString());
    }

    public HdfsTable getHdfsTable() {
        return this.hdfsTable_;
    }

    @Override
    public org.apache.iceberg.Table getIcebergApiTable() {
        return this.icebergApiTable_;
    }

    @Override
    public TCatalogObjectType getCatalogObjectType() {
        return TCatalogObjectType.TABLE;
    }

    @Override
    public void setCatalogVersion(long newVersion) {
        super.setCatalogVersion(newVersion);
        this.hdfsTable_.setCatalogVersion(newVersion);
    }

    @Override
    public String getStorageHandlerClassName() {
        return ICEBERG_STORAGE_HANDLER;
    }

    public static boolean isIcebergStorageHandler(String handler) {
        return handler != null && handler.equals(ICEBERG_STORAGE_HANDLER);
    }

    public static boolean isIcebergTable(org.apache.hadoop.hive.metastore.api.Table msTbl) {
        String inputFormat = msTbl.getSd().getInputFormat();
        HdfsFileFormat hdfsFileFormat = inputFormat != null ? HdfsFileFormat.fromHdfsInputFormatClass(inputFormat, null) : null;
        return IcebergTable.isIcebergStorageHandler((String)msTbl.getParameters().get(KEY_STORAGE_HANDLER)) || hdfsFileFormat == HdfsFileFormat.ICEBERG || hdfsFileFormat == null && "ICEBERG".equals(msTbl.getParameters().get("table_type"));
    }

    @Override
    public TIcebergCatalog getIcebergCatalog() {
        return this.icebergCatalog_;
    }

    @Override
    public String getIcebergCatalogLocation() {
        return FeIcebergTable.Utils.getIcebergCatalogLocation(this);
    }

    @Override
    public TIcebergFileFormat getIcebergFileFormat() {
        return this.icebergFileFormat_;
    }

    @Override
    public TCompressionCodec getIcebergParquetCompressionCodec() {
        return this.icebergParquetCompressionCodec_;
    }

    @Override
    public long getIcebergParquetRowGroupSize() {
        return this.icebergParquetRowGroupSize_;
    }

    @Override
    public long getIcebergParquetPlainPageSize() {
        return this.icebergParquetPlainPageSize_;
    }

    @Override
    public long getIcebergParquetDictPageSize() {
        return this.icebergParquetDictPageSize_;
    }

    @Override
    public String getIcebergTableLocation() {
        return this.icebergTableLocation_;
    }

    @Override
    public FeFsTable getFeFsTable() {
        return this.hdfsTable_;
    }

    @Override
    public List<IcebergPartitionSpec> getPartitionSpecs() {
        Preconditions.checkState((this.partitionSpecs_ != null ? 1 : 0) != 0);
        return ImmutableList.copyOf(this.partitionSpecs_);
    }

    @Override
    public IcebergPartitionSpec getDefaultPartitionSpec() {
        return FeIcebergTable.Utils.getDefaultPartitionSpec(this);
    }

    @Override
    public int getDefaultPartitionSpecId() {
        return this.defaultPartitionSpecId_;
    }

    @Override
    public long snapshotId() {
        return this.catalogSnapshotId_;
    }

    @Override
    public Map<String, TIcebergPartitionStats> getIcebergPartitionStats() {
        return this.partitionStats_;
    }

    @Override
    public TTable toThrift() {
        TTable table = super.toThrift();
        table.setTable_type(TTableType.ICEBERG_TABLE);
        table.setIceberg_table(FeIcebergTable.Utils.getTIcebergTable(this));
        table.setHdfs_table(this.transformToTHdfsTable(true, CatalogObject.ThriftObjectType.FULL));
        return table;
    }

    @Override
    public TTable toHumanReadableThrift() {
        TTable table = super.toThrift();
        table.setTable_type(TTableType.ICEBERG_TABLE);
        table.setIceberg_table(FeIcebergTable.Utils.getTIcebergTable(this));
        table.setHdfs_table(this.transformToTHdfsTable(true, CatalogObject.ThriftObjectType.DESCRIPTOR_ONLY));
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(boolean reuseMetadata, IMetaStoreClient msClient, org.apache.hadoop.hive.metastore.api.Table msTbl, String reason, EventSequence catalogTimeline) throws TableLoadingException {
        Timer.Context context = this.getMetrics().getTimer("load-duration").time();
        this.verifyTable(msTbl);
        try {
            this.msTable_ = msTbl.deepCopy();
            FeIcebergTable.setIcebergStorageDescriptor(this.msTable_);
            this.setTableStats(this.msTable_);
            Timer.Context ctxStorageLdTime = this.getMetrics().getTimer("load-duration.storage-metadata").time();
            try {
                this.icebergApiTable_ = IcebergUtil.loadTable(this);
                catalogTimeline.markEvent("Loaded Iceberg API table");
                this.catalogSnapshotId_ = FeIcebergTable.super.snapshotId();
                this.loadSchemaFromIceberg();
                catalogTimeline.markEvent("Loaded schema from Iceberg");
                this.icebergFileFormat_ = IcebergUtil.getIcebergFileFormat(msTbl);
                this.icebergParquetCompressionCodec_ = FeIcebergTable.Utils.getIcebergParquetCompressionCodec(msTbl);
                this.icebergParquetRowGroupSize_ = FeIcebergTable.Utils.getIcebergParquetRowGroupSize(msTbl);
                this.icebergParquetPlainPageSize_ = FeIcebergTable.Utils.getIcebergParquetPlainPageSize(msTbl);
                this.icebergParquetDictPageSize_ = FeIcebergTable.Utils.getIcebergParquetDictPageSize(msTbl);
                GroupedContentFiles icebergFiles = IcebergUtil.getIcebergFiles(this, new ArrayList<Expression>(), null);
                catalogTimeline.markEvent("Loaded Iceberg files");
                this.hdfsTable_.setIcebergFiles(icebergFiles);
                this.hdfsTable_.setCanDataBeOutsideOfTableLocation(!FeIcebergTable.Utils.requiresDataFilesInTableLocation(this));
                this.hdfsTable_.load(reuseMetadata, msClient, this.msTable_, reason, catalogTimeline);
                this.fileStore_ = FeIcebergTable.Utils.loadAllPartition(this, icebergFiles);
                this.partitionStats_ = FeIcebergTable.Utils.loadPartitionStats(this, icebergFiles);
                this.setIcebergTableStats();
                this.loadAllColumnStats(msClient, catalogTimeline);
                this.setAvroSchema(msClient, msTbl, this.fileStore_, catalogTimeline);
            }
            catch (Exception e) {
                throw new IcebergTableLoadingException("Error loading metadata for Iceberg table " + this.icebergTableLocation_, e);
            }
            finally {
                this.storageMetadataLoadTime_ = ctxStorageLdTime.stop();
            }
            this.refreshLastUsedTime();
            FeIcebergTable.resetIcebergStorageDescriptor(this.msTable_, msTbl);
            if (this.msTable_.equals(msTbl)) {
                return;
            }
            try {
                IcebergTable.updateTimestampProperty(this.msTable_, "transient_lastDdlTime");
                this.msTable_.putToParameters("DO_NOT_UPDATE_STATS", "true");
                msClient.alter_table(this.msTable_.getDbName(), this.msTable_.getTableName(), this.msTable_);
                catalogTimeline.markEvent("Updated table schema in Metastore");
            }
            catch (TException e) {
                throw new TableLoadingException(e.getMessage());
            }
        }
        finally {
            context.stop();
        }
    }

    private void verifyTable(org.apache.hadoop.hive.metastore.api.Table msTbl) throws TableLoadingException {
        Map params;
        String tableId;
        if (!(!IcebergUtil.isHiveCatalog(msTbl.getParameters()) || (tableId = IcebergUtil.getIcebergTableIdentifier(msTbl.getDbName(), msTbl.getTableName()).toString()).equalsIgnoreCase((params = msTbl.getParameters()).getOrDefault(ICEBERG_TABLE_IDENTIFIER, tableId)) && tableId.equalsIgnoreCase(params.getOrDefault("name", tableId)) && tableId.equalsIgnoreCase(params.getOrDefault("iceberg.mr.table.identifier", tableId)))) {
            throw new TableLoadingException(String.format("Table %s cannot be loaded because it is an EXTERNAL table in the HiveCatalog that points to another table. Query the original table instead.", this.getFullName()));
        }
    }

    public void loadSchemaFromIceberg() throws TableLoadingException, ImpalaRuntimeException {
        this.loadSchema();
        this.addVirtualColumns();
        this.partitionSpecs_ = FeIcebergTable.Utils.loadPartitionSpecByIceberg(this);
        this.defaultPartitionSpecId_ = this.icebergApiTable_.spec().specId();
    }

    private void loadSchema() throws TableLoadingException {
        this.clearColumns();
        try {
            this.msTable_.getSd().setCols(IcebergSchemaConverter.convertToHiveSchema(this.getIcebergSchema()));
            for (Column col : IcebergSchemaConverter.convertToImpalaSchema(this.getIcebergSchema())) {
                this.addColumn(col);
            }
        }
        catch (ImpalaRuntimeException e) {
            throw new TableLoadingException(e.getMessage(), e);
        }
    }

    private void setAvroSchema(IMetaStoreClient msClient, org.apache.hadoop.hive.metastore.api.Table msTbl, IcebergContentFileStore fileStore, EventSequence catalogTimeline) throws Exception {
        if (fileStore.hasAvro()) {
            this.hdfsTable_.setAvroSchemaInternal(msClient, msTbl, catalogTimeline);
        }
    }

    @Override
    public void addColumn(Column col) {
        Preconditions.checkState((boolean)(col instanceof IcebergColumn));
        IcebergColumn iCol = (IcebergColumn)col;
        this.colsByPos_.add(iCol);
        this.colsByName_.put(iCol.getName().toLowerCase(), col);
        ((StructType)this.type_.getItemType()).addField(new IcebergStructField(col.getName(), col.getType(), col.getComment(), iCol.getFieldId()));
    }

    private void addVirtualColumns() {
        this.addVirtualColumn(VirtualColumn.INPUT_FILE_NAME);
        this.addVirtualColumn(VirtualColumn.FILE_POSITION);
        this.addVirtualColumn(VirtualColumn.PARTITION_SPEC_ID);
        this.addVirtualColumn(VirtualColumn.ICEBERG_PARTITION_SERIALIZED);
        this.addVirtualColumn(VirtualColumn.ICEBERG_DATA_SEQUENCE_NUMBER);
    }

    @Override
    protected void loadFromThrift(TTable thriftTable) throws TableLoadingException {
        super.loadFromThrift(thriftTable);
        TIcebergTable ticeberg = thriftTable.getIceberg_table();
        this.icebergTableLocation_ = ticeberg.getTable_location();
        this.icebergParquetCompressionCodec_ = ticeberg.getParquet_compression_codec();
        this.icebergParquetRowGroupSize_ = ticeberg.getParquet_row_group_size();
        this.icebergParquetPlainPageSize_ = ticeberg.getParquet_plain_page_size();
        this.icebergParquetDictPageSize_ = ticeberg.getParquet_dict_page_size();
        this.partitionSpecs_ = this.loadPartitionBySpecsFromThrift(ticeberg.getPartition_spec());
        this.defaultPartitionSpecId_ = ticeberg.getDefault_partition_spec_id();
        this.catalogSnapshotId_ = ticeberg.catalog_snapshot_id;
        this.icebergApiTable_ = IcebergUtil.loadTable(this);
        this.fileStore_ = IcebergContentFileStore.fromThrift(ticeberg.getContent_files(), null, null);
        this.hdfsTable_.loadFromThrift(thriftTable);
        this.partitionStats_ = ticeberg.getPartition_stats();
    }

    private List<IcebergPartitionSpec> loadPartitionBySpecsFromThrift(List<TIcebergPartitionSpec> params) {
        ArrayList<IcebergPartitionSpec> ret = new ArrayList<IcebergPartitionSpec>();
        for (TIcebergPartitionSpec param : params) {
            if (param.getPartition_fields() != null) {
                ArrayList<IcebergPartitionField> fields = new ArrayList<IcebergPartitionField>();
                for (TIcebergPartitionField field : param.getPartition_fields()) {
                    Integer transformParam = null;
                    if (field.getTransform().isSetTransform_param()) {
                        transformParam = field.getTransform().getTransform_param();
                    }
                    fields.add(new IcebergPartitionField(field.getSource_id(), field.getField_id(), field.getOrig_field_name(), field.getField_name(), new IcebergPartitionTransform(field.getTransform().getTransform_type(), transformParam), Type.fromTScalarType(field.getType())));
                }
                ret.add(new IcebergPartitionSpec(param.getSpec_id(), fields));
                continue;
            }
            ret.add(new IcebergPartitionSpec(param.getSpec_id(), null));
        }
        return ret;
    }

    @Override
    public TTableDescriptor toThriftDescriptor(int tableId, Set<Long> referencedPartitions) {
        TTableDescriptor desc = new TTableDescriptor(tableId, TTableType.ICEBERG_TABLE, this.getTColumnDescriptors(), this.numClusteringCols_, this.name_, this.db_.getName());
        desc.setIcebergTable(FeIcebergTable.Utils.getTIcebergTable(this, CatalogObject.ThriftObjectType.DESCRIPTOR_ONLY));
        desc.setHdfsTable(this.transformToTHdfsTable(false, CatalogObject.ThriftObjectType.DESCRIPTOR_ONLY));
        return desc;
    }

    @Override
    public THdfsTable transformToTHdfsTable(boolean updatePartitionFlag, CatalogObject.ThriftObjectType type) {
        THdfsTable hdfsTable = this.hdfsTable_.getTHdfsTable(type, null);
        if (updatePartitionFlag) {
            FeIcebergTable.Utils.updateIcebergPartitionFileFormat(this, hdfsTable);
        }
        return hdfsTable;
    }

    @Override
    public TGetPartialCatalogObjectResponse getPartialInfo(TGetPartialCatalogObjectRequest req) throws CatalogException {
        Preconditions.checkState((boolean)this.isLoaded(), (String)"unloaded table: %s", (Object)this.getFullName());
        HashMap<HdfsPartition, TPartialPartitionInfo> missingPartialInfos = new HashMap<HdfsPartition, TPartialPartitionInfo>();
        TGetPartialCatalogObjectResponse resp = this.getHdfsTable().getPartialInfo(req, missingPartialInfos);
        if (resp.table_info != null) {
            resp.table_info.unsetVirtual_columns();
            for (VirtualColumn vCol : this.getVirtualColumns()) {
                resp.table_info.addToVirtual_columns(vCol.toThrift());
            }
        }
        if (req.table_info_selector.want_iceberg_table) {
            resp.table_info.setIceberg_table(FeIcebergTable.Utils.getTIcebergTable(this));
            if (!resp.table_info.isSetNetwork_addresses()) {
                resp.table_info.setNetwork_addresses(this.getHostIndex().getList());
            }
            resp.table_info.iceberg_table.setCatalog_snapshot_id(this.catalogSnapshotId_);
        }
        return resp;
    }

    @Override
    public IcebergContentFileStore getContentFileStore() {
        return this.fileStore_;
    }
}

