/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import java.util.Collections;
import java.util.Set;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.HdfsPartition;
import org.apache.impala.catalog.IcebergColumn;
import org.apache.impala.catalog.IcebergDeleteTable;
import org.apache.impala.catalog.Type;
import org.apache.impala.thrift.TColumnStats;

public class IcebergPositionDeleteTable
extends IcebergDeleteTable {
    public static String FILE_PATH_COLUMN = "file_path";
    public static String POS_COLUMN = "pos";

    public IcebergPositionDeleteTable(FeIcebergTable baseTable) {
        this(baseTable, baseTable.getName() + "-POSITION-DELETE", Collections.emptySet(), 0L, new TColumnStats());
    }

    public IcebergPositionDeleteTable(FeIcebergTable baseTable, String name, Set<HdfsPartition.FileDescriptor> deleteFiles, long deleteRecordsCount, TColumnStats filePathsStats) {
        super(baseTable, name, deleteFiles, deleteRecordsCount);
        IcebergColumn filePath = new IcebergColumn(FILE_PATH_COLUMN, Type.STRING, "", this.colsByPos_.size(), 2147483546, -1, -1, false);
        IcebergColumn pos = new IcebergColumn(POS_COLUMN, Type.BIGINT, "", this.colsByPos_.size(), 0x7FFFFF99, -1, -1, false);
        filePath.updateStats(filePathsStats);
        pos.updateStats(this.getPosStats(pos));
        this.addColumn(filePath);
        this.addColumn(pos);
    }

    private TColumnStats getPosStats(Column pos) {
        TColumnStats colStats = new TColumnStats();
        colStats.num_distinct_values = this.deleteRecordsCount_;
        colStats.num_nulls = 0L;
        colStats.max_size = pos.getType().getSlotSize();
        return colStats;
    }
}

